/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationDataStorageImpl
extends AbstractService
implements NotificationDataStorage {
    private static final Log LOG = ExoLogger.getLogger(NotificationDataStorageImpl.class);
    private static final String REMOVE_ALL = "removeAll";
    private static final String REMOVE_DAILY = "removeDaily";
    private String workspace;
    private final ReentrantLock lock = new ReentrantLock();
    private Map<String, Set<String>> removeByCallBack = new ConcurrentHashMap<String, Set<String>>();

    public NotificationDataStorageImpl(NotificationConfiguration configuration) {
        this.workspace = configuration.getWorkspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(NotificationInfo message) throws Exception {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        ReentrantLock localLock = this.lock;
        try {
            localLock.lock();
            Node messageHomeNode = this.getOrCreateMessageParent(sProvider, this.workspace, message.getKey().getId());
            Node messageNode = messageHomeNode.addNode(message.getId(), "ntf:message");
            messageNode.setProperty("ntf:from", message.getFrom());
            messageNode.setProperty("ntf:order", (long)message.getOrder());
            messageNode.setProperty("ntf:providerType", message.getKey().getId());
            messageNode.setProperty("ntf:ownerParameter", message.getArrayOwnerParameter());
            messageNode.setProperty("ntf:sendToDaily", message.getSendToDaily());
            messageNode.setProperty("ntf:sendToWeekly", message.getSendToWeekly());
            messageHomeNode.getSession().save();
            if (NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled()) {
                NotificationContextFactory.getInstance().getStatisticsCollector().insertEntity("ntf:message");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save the NotificationMessage", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
            localLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PluginKey, List<NotificationInfo>> getByUser(NotificationContext context, UserSetting setting) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        LinkedHashMap<PluginKey, List<NotificationInfo>> notificationData = new LinkedHashMap<PluginKey, List<NotificationInfo>>();
        try {
            boolean isDaily;
            boolean isWeekly = (Boolean)context.value(NotificationJob.JOB_WEEKLY);
            if (isWeekly) {
                for (String pluginId : setting.getWeeklyPlugins()) {
                    NotificationDataStorageImpl.putMap(notificationData, PluginKey.key((String)pluginId), this.getWeeklyNotifs(sProvider, pluginId, setting.getUserId()));
                }
            }
            if (isDaily = ((Boolean)context.value(NotificationJob.JOB_DAILY)).booleanValue()) {
                for (String pluginId : setting.getDailyPlugins()) {
                    NotificationDataStorageImpl.putMap(notificationData, PluginKey.key((String)pluginId), this.getDailyNotifs(sProvider, context, pluginId, setting.getUserId()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get the NotificationMessage by user: " + setting.getUserId()), (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return notificationData;
    }

    private static void putMap(Map<PluginKey, List<NotificationInfo>> notificationData, PluginKey key, List<NotificationInfo> values) {
        if (notificationData.containsKey(key)) {
            List<NotificationInfo> messages = notificationData.get(key);
            for (NotificationInfo notificationMessage : values) {
                if (messages.size() != 0 && messages.contains(notificationMessage)) continue;
                messages.add(notificationMessage);
            }
            if (messages.size() > 0) {
                notificationData.put(key, messages);
            }
        } else if (values.size() > 0) {
            notificationData.put(key, values);
        }
    }

    private List<NotificationInfo> getDailyNotifs(SessionProvider sProvider, NotificationContext context, String pluginId, String userId) throws Exception {
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        Node plugInDayNode = this.getParentNodeByDate(sProvider, this.workspace, context, pluginId);
        NodeIterator iter = this.getDailyNodes(plugInDayNode, userId);
        Session session = plugInDayNode.getSession();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            NotificationInfo model = this.fillModel(node);
            messages.add(model.setTo(userId));
            this.removeDaily(session, model, node.getPath());
        }
        return messages;
    }

    private Node getParentNodeByDate(SessionProvider sProvider, String workspace, NotificationContext context, String pluginId) throws Exception {
        Node providerNode = this.getMessageNodeByPluginId(sProvider, workspace, pluginId);
        String dayName = (String)context.value(NotificationJob.DAY_OF_JOB);
        return this.getOrCreateMessageNode(providerNode, "d" + dayName);
    }

    private List<NotificationInfo> getWeeklyNotifs(SessionProvider sProvider, String pluginId, String userId) throws Exception {
        ArrayList<NotificationInfo> messages = new ArrayList<NotificationInfo>();
        Node messageHomeNode = this.getMessageNodeByPluginId(sProvider, this.workspace, pluginId);
        NodeIterator iter = this.getWeeklyNodes(messageHomeNode, userId);
        Session session = messageHomeNode.getSession();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            NotificationInfo model = this.fillModel(node);
            messages.add(model.setTo(userId));
            this.removeWeekly(session, model, node.getPath());
        }
        return messages;
    }

    private NodeIterator getWeeklyNodes(Node messageHomeNode, String userId) throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        userId = userId.replace("'", "''");
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("ntf:message").append(" WHERE ");
        strQuery.append(" jcr:path LIKE '").append(messageHomeNode.getPath()).append("/%'");
        strQuery.append(" AND (").append("ntf:sendToWeekly").append("='").append(userId).append("'");
        strQuery.append(" OR ").append("ntf:sendToWeekly").append("='").append("&forAllUser").append("') AND ").append("ntf:from").append("<>'").append(userId).append("'");
        strQuery.append(" order by ").append("ntf:order").append(" ASC").append(", exo:dateCreated").append(" DESC");
        QueryManager qm = messageHomeNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(strQuery.toString(), "sql");
        NodeIterator it = query.execute().getNodes();
        if (stats) {
            NotificationContextFactory.getInstance().getStatisticsCollector().queryExecuted(strQuery.toString(), it.getSize(), System.currentTimeMillis() - startTime);
        }
        return it;
    }

    private NodeIterator getDailyNodes(Node pluginDayNode, String userId) throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        userId = userId.replace("'", "''");
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("ntf:message").append(" WHERE ");
        strQuery.append(" (jcr:path LIKE '").append(pluginDayNode.getPath()).append("/%'").append(" AND NOT jcr:path LIKE '").append(pluginDayNode.getPath()).append("/%/%')");
        strQuery.append(" AND (").append("ntf:sendToDaily").append("='").append(userId).append("'");
        strQuery.append(" OR ").append("ntf:sendToDaily").append("='").append("&forAllUser").append("') AND ").append("ntf:from").append("<>'").append(userId).append("'");
        strQuery.append(" order by ").append("ntf:order").append(" ASC").append(", exo:dateCreated").append(" DESC");
        QueryManager qm = pluginDayNode.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(strQuery.toString(), "sql");
        NodeIterator it = query.execute().getNodes();
        if (stats) {
            NotificationContextFactory.getInstance().getStatisticsCollector().queryExecuted(strQuery.toString(), it.getSize(), System.currentTimeMillis() - startTime);
        }
        return it;
    }

    private NotificationInfo fillModel(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        if (!node.hasProperty("exo:lastModifiedDate")) {
            if (node.isNodeType("exo:modify")) {
                node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                node.save();
            } else if (node.canAddMixin("exo:modify")) {
                node.addMixin("exo:modify");
                node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
                node.save();
            } else {
                LOG.warn("Cannot add mixin to node '{}'.", new Object[]{node.getPath()});
            }
        }
        NotificationInfo message = NotificationInfo.instance().setFrom(node.getProperty("ntf:from").getString()).setOrder(Integer.valueOf(node.getProperty("ntf:order").getString()).intValue()).key(node.getProperty("ntf:providerType").getString()).setOwnerParameter(node.getProperty("ntf:ownerParameter").getValues()).setSendToDaily(NotificationUtils.valuesToArray(node.getProperty("ntf:sendToDaily").getValues())).setSendToWeekly(NotificationUtils.valuesToArray(node.getProperty("ntf:sendToWeekly").getValues())).setLastModifiedDate(node.getProperty("exo:lastModifiedDate").getDate()).setId(node.getName());
        return message;
    }

    private void putRemoveMap(String key, String value) {
        Set<String> set = this.removeByCallBack.get(key);
        if (set == null) {
            set = new HashSet<String>();
            this.removeByCallBack.put(key, set);
        }
        set.add(value);
    }

    private void removeDaily(Session session, NotificationInfo message, String path) throws Exception {
        if (message.getSendToDaily().length == 1 && message.getSendToWeekly().length == 0) {
            this.putRemoveMap(REMOVE_ALL, path);
        }
        if (message.getSendToDaily().length > 0 && "&forAllUser".equals(message.getSendToDaily()[0])) {
            this.putRemoveMap(REMOVE_DAILY, path);
        } else {
            this.removeProperty(session, path, "ntf:sendToDaily", message.getTo());
        }
    }

    private void removeWeekly(Session session, NotificationInfo message, String path) throws Exception {
        if (message.isSendAll() || message.getSendToWeekly().length == 1) {
            this.putRemoveMap(REMOVE_ALL, path);
        } else {
            this.removeProperty(session, path, "ntf:sendToWeekly", message.getTo());
        }
    }

    private void removeProperty(Session session, String path, String property, String value) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        try {
            Node node = (Node)session.getItem(path);
            List<String> values = NotificationUtils.valuesToList(node.getProperty(property).getValues());
            if (values.contains(value)) {
                values.remove(value);
                if (values.isEmpty()) {
                    values.add("");
                }
                node.setProperty(property, values.toArray(new String[values.size()]));
                node.save();
                if (stats) {
                    NotificationContextFactory.getInstance().getStatisticsCollector().updateEntity("ntf:message");
                }
            }
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to remove property %s of value %s on node ", property, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageAfterSent() throws Exception {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            Node notificationHome = NotificationDataStorageImpl.getNotificationHomeNode(sProvider, this.workspace);
            Session session = notificationHome.getSession();
            Set<String> listPaths = this.removeByCallBack.get(REMOVE_ALL);
            this.removeByCallBack.remove(REMOVE_ALL);
            if (listPaths != null && listPaths.size() > 0) {
                for (String nodePath : listPaths) {
                    try {
                        session.getItem(nodePath).remove();
                        if (stats) {
                            NotificationContextFactory.getInstance().getStatisticsCollector().deleteEntity("ntf:message");
                        }
                        LOG.debug((Object)("Remove NotificationMessage " + nodePath));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to remove node of NotificationMessage " + nodePath + "\n" + e.getMessage()));
                        LOG.debug((Object)("Remove NotificationMessage " + nodePath), (Throwable)e);
                    }
                }
                session.save();
            }
            if ((listPaths = this.removeByCallBack.get(REMOVE_DAILY)) != null && listPaths.size() > 0) {
                for (String nodePath : listPaths) {
                    try {
                        Item item = session.getItem(nodePath);
                        if (item.isNode()) {
                            Node node = (Node)item;
                            node.setProperty("ntf:sendToDaily", new String[]{""});
                        }
                        LOG.debug((Object)("Remove SendToDaily property " + nodePath));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Failed to remove SendToDaily property of " + nodePath + "\n" + e.getMessage()));
                        LOG.debug((Object)("Remove SendToDaily property " + nodePath), (Throwable)e);
                    }
                }
                session.save();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to remove message after sent email notification", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
    }
}

