/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;

public class StringCommonUtils {
    private static final int BUFFER_SIZE = 32;
    public static final String EMPTY_STR = "";
    public static final String SEMICOLON = ";";
    public static final String LESS_THAN = "&lt;";
    public static final String GREATER_THAN = "&gt;";
    public static final String AMP_NUMBER = "&#";
    private static int[] CHAR_CODES = new int[]{48, 32, 65, 57, 97, 90, 127, 122, 39};

    public static InputStream compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return new ByteArrayInputStream(compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(InputStream is) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(is, 32);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            String string = new String(buffer.toByteArray());
            return string;
        }
        finally {
            gis.close();
            is.close();
            buffer.close();
        }
    }

    public static String encodeSpecialCharInHTML(String s) {
        String charIgnore = "&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_";
        return StringCommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, false);
    }

    public static String encodeSpecialCharToHTMLnumber(String s, String charIgnore, boolean isTitle) {
        if (StringUtils.isBlank((String)s)) {
            return EMPTY_STR;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charIgnore.indexOf(String.valueOf(c)) >= 0) {
                builder.append(c);
                continue;
            }
            int t = s.codePointAt(i);
            if (t < CHAR_CODES[0] && t > CHAR_CODES[1] || t < CHAR_CODES[2] && t > CHAR_CODES[3] || t < CHAR_CODES[4] && t > CHAR_CODES[5] || t < CHAR_CODES[6] && t > CHAR_CODES[7]) {
                if (isTitle && (t == 60 || t == 62)) {
                    if (t == 60) {
                        builder.append(LESS_THAN);
                        continue;
                    }
                    if (t != 62) continue;
                    builder.append(GREATER_THAN);
                    continue;
                }
                builder.append(AMP_NUMBER).append(t).append(SEMICOLON);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

