/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.migration;

import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.impl.jpa.email.JPAMailNotificationStorage;
import org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl;
import org.exoplatform.commons.notification.impl.service.storage.MailNotificationStorageImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.RDBMSMigrationUtils;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.transaction.TransactionService;
import org.json.JSONObject;

public class MailNotificationsMigration {
    public static final String MAIL_NOTIFICATION_MIGRATION_DONE_KEY = "MAIL_NOTIFICATION_MIGRATION_DONE";
    public static final String MAIL_NOTIFICATION_RDBMS_MIGRATION_DONE = "MAIL_NOTIFICATION_RDBMS_MIGRATION_DONE";
    public static final String MAIL_NOTIFICATION_RDBMS_CLEANUP_DONE = "MAIL_NOTIFICATION_RDBMS_CLEANUP_DONE";
    private static final Log LOG = ExoLogger.getLogger(MailNotificationsMigration.class);
    private JPAMailNotificationStorage jpaMailNotificationStorage;
    private JPAQueueMessageImpl jpaQueueMessage;
    private MailNotificationStorageImpl jcrNotificationDataStorage;
    private String jcrWorkspace;
    private Session session;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private JobSchedulerService schedulerService;
    private RepositoryService repositoryService;
    private SettingService settingService;
    private TransactionService transactionService;

    public MailNotificationsMigration(MailNotificationStorageImpl jcrNotificationDataStorage, JPAMailNotificationStorage jpaMailNotificationStorage, JobSchedulerService schedulerService, SettingService settingService, NotificationConfiguration notificationConfiguration, RepositoryService repositoryService, TransactionService transactionService, NodeHierarchyCreator nodeHierarchyCreator) {
        this.jpaMailNotificationStorage = jpaMailNotificationStorage;
        this.jcrNotificationDataStorage = jcrNotificationDataStorage;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.schedulerService = schedulerService;
        this.repositoryService = repositoryService;
        this.settingService = settingService;
        this.transactionService = transactionService;
        this.jcrWorkspace = notificationConfiguration.getWorkspace();
        this.jpaQueueMessage = CommonsUtils.getService(JPAQueueMessageImpl.class);
    }

    private Session getJCRSession() {
        Session jcrSession = null;
        try {
            jcrSession = this.repositoryService.getRepository("repository").getSystemSession(this.jcrWorkspace);
            if (jcrSession instanceof SessionImpl) {
                ((SessionImpl)jcrSession).setTimeout(86400000L);
            }
            this.transactionService.setTransactionTimeout(86400);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting Notification nodes for Notifications migration - Cause : " + e.getMessage()), (Throwable)e);
        }
        return jcrSession;
    }

    public void migrate() {
        this.session = this.getJCRSession();
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                RDBMSMigrationUtils.getExecutorService().submit(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        if (!MailNotificationsMigration.this.isMailNotifMigrationDone()) {
                            try {
                                MailNotificationsMigration.this.schedulerService.pauseJob("NotificationDailyJob", "Notification");
                                MailNotificationsMigration.this.schedulerService.pauseJob("NotificationWeeklyJob", "Notification");
                                ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                                LOG.info((Object)"=== Start migration of Mail Notifications data from JCR");
                                long startTime = System.currentTimeMillis();
                                MailNotificationsMigration.this.migrateMailNotifData();
                                MailNotificationsMigration.this.setMailNotifMigrationDone();
                                long endTime = System.currentTimeMillis();
                                LOG.info((Object)("=== Migration of Mail Notification data done in " + (endTime - startTime) + " ms"));
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error while migrating Mail Notification data from JCR to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                            }
                            finally {
                                MailNotificationsMigration.this.schedulerService.resumeJob("NotificationDailyJob", "Notification");
                                MailNotificationsMigration.this.schedulerService.resumeJob("NotificationWeeklyJob", "Notification");
                            }
                        } else {
                            LOG.info((Object)"No mail notification data to migrate from JCR to RDBMS");
                        }
                        MailNotificationsMigration.this.cleanupMailNotifications();
                        return null;
                    }
                });
            }
        });
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                RDBMSMigrationUtils.getExecutorService().submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                        if (MailNotificationsMigration.this.hasQueueMessagesDataToMigrate()) {
                            try {
                                LOG.info((Object)"=== Start migration of Mail messages stored in the queue from JCR");
                                long startTime = System.currentTimeMillis();
                                MailNotificationsMigration.this.migrateQueueMessages();
                                long endTime = System.currentTimeMillis();
                                LOG.info((Object)("=== Migration of Mail messages data done in " + (endTime - startTime) + " ms"));
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error while migrating Mail messages data from JCR to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                            }
                        } else {
                            LOG.info((Object)"No queue messages data to migrate from JCR to RDBMS");
                        }
                        MailNotificationsMigration.this.cleanupQueue();
                        return null;
                    }
                });
            }
        });
    }

    public void cleanupMailNotifications() {
        RDBMSMigrationUtils.getExecutorService().submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                if (MailNotificationsMigration.this.isMailNotifMigrationDone() && !MailNotificationsMigration.this.isMailNotifCleanupDone()) {
                    long endTime;
                    long startTime;
                    MailNotificationsMigration.this.schedulerService.pauseJob("NotificationDailyJob", "Notification");
                    MailNotificationsMigration.this.schedulerService.pauseJob("NotificationWeeklyJob", "Notification");
                    try {
                        LOG.info((Object)"=== Start cleaning Mail notifications data from JCR");
                        startTime = System.currentTimeMillis();
                        MailNotificationsMigration.this.deleteJcrMailNotifications();
                        MailNotificationsMigration.this.setMailNotifCleanupDone();
                        endTime = System.currentTimeMillis();
                        LOG.info((Object)("=== Mail notifications JCR data cleaning due to RDBMS migration done in " + (endTime - startTime) + " ms"));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while cleaning Mail notifications JCR data", (Throwable)e);
                    }
                    finally {
                        RequestLifeCycle.end();
                    }
                    try {
                        LOG.info((Object)"=== Start cleaning Mail messages data from JCR");
                        startTime = System.currentTimeMillis();
                        MailNotificationsMigration.this.deleteJcrMailMessages();
                        endTime = System.currentTimeMillis();
                        LOG.info((Object)("=== Mail messages JCR data cleaning due to RDBMS migration done in " + (endTime - startTime) + " ms"));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while cleaning Mail messages JCR data to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    public void cleanupQueue() {
        RDBMSMigrationUtils.getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                if (MailNotificationsMigration.this.isMailNotifMigrationDone() && !MailNotificationsMigration.this.isMailNotifCleanupDone()) {
                    MailNotificationsMigration.this.schedulerService.pauseJob("NotificationDailyJob", "Notification");
                    MailNotificationsMigration.this.schedulerService.pauseJob("NotificationWeeklyJob", "Notification");
                    try {
                        LOG.info((Object)"=== Start cleaning Mail messages data from JCR");
                        long startTime = System.currentTimeMillis();
                        MailNotificationsMigration.this.deleteJcrMailMessages();
                        long endTime = System.currentTimeMillis();
                        LOG.info((Object)("=== Mail messages JCR data cleaning due to RDBMS migration done in " + (endTime - startTime) + " ms"));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while cleaning Mail messages JCR data to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
                    }
                }
                return null;
            }
        });
    }

    private void setMailNotifMigrationDone() {
        this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id(MAIL_NOTIFICATION_MIGRATION_DONE_KEY), MAIL_NOTIFICATION_RDBMS_MIGRATION_DONE, SettingValue.create((String)"true"));
    }

    private void setMailNotifCleanupDone() {
        this.settingService.set(Context.GLOBAL, Scope.APPLICATION.id(MAIL_NOTIFICATION_MIGRATION_DONE_KEY), MAIL_NOTIFICATION_RDBMS_CLEANUP_DONE, SettingValue.create((String)"true"));
    }

    private boolean isMailNotifMigrationDone() {
        SettingValue setting = this.settingService.get(Context.GLOBAL, Scope.APPLICATION.id(MAIL_NOTIFICATION_MIGRATION_DONE_KEY), MAIL_NOTIFICATION_RDBMS_MIGRATION_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    private boolean isMailNotifCleanupDone() {
        SettingValue setting = this.settingService.get(Context.GLOBAL, Scope.APPLICATION.id(MAIL_NOTIFICATION_MIGRATION_DONE_KEY), MAIL_NOTIFICATION_RDBMS_CLEANUP_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    private void deleteJcrMailMessages() throws RepositoryException {
        Node parentMsgHome = this.getNode("eXoNotification", "messageInfoHome");
        if (parentMsgHome != null) {
            parentMsgHome.remove();
            this.session.save();
        }
    }

    private void deleteJcrMailNotifications() throws RepositoryException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        NodeIterator pluginNodesIterator = this.getMailNotificationNodes();
        while (pluginNodesIterator.hasNext()) {
            Node pluginNode = pluginNodesIterator.nextNode();
            NodeIterator dayNodesIterator = pluginNode.getNodes();
            while (dayNodesIterator.hasNext()) {
                Node dayNode = dayNodesIterator.nextNode();
                NodeIterator notifNodes = dayNode.getNodes();
                LOG.info((Object)("    Removing JCR mail notifications for plugin: " + pluginNode.getName() + " - day: " + dayNode.getName()));
                int i = 0;
                while (notifNodes.hasNext()) {
                    notifNodes.nextNode().remove();
                    if (++i % 100 != 0) continue;
                    this.session.save();
                    RequestLifeCycle.end();
                    RequestLifeCycle.begin((ExoContainer)currentContainer);
                }
                if (i <= 0) continue;
                this.session.save();
                LOG.info((Object)("=== done removed " + i + " mail notifications from JCR for plugin: " + pluginNode.getName()));
            }
            pluginNode.remove();
            this.session.save();
        }
        Node parentMsgHome = this.getNode("eXoNotification", "messageHome");
        if (parentMsgHome != null) {
            parentMsgHome.remove();
            this.session.save();
        }
    }

    private void migrateQueueMessages() throws Exception {
        NodeIterator iterator = this.getMessageInfoNodes();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            this.jpaQueueMessage.put(this.getMessageInfo(node));
        }
    }

    private MessageInfo getMessageInfo(Node node) {
        String path = null;
        try {
            path = node.getPath();
            String messageJson = this.getDataJson(node);
            JSONObject object = new JSONObject(messageJson);
            MessageInfo info = new MessageInfo();
            info.pluginId(object.optString("pluginId")).from(object.getString("from")).to(object.getString("to")).subject(object.getString("subject")).body(object.getString("body")).footer(object.optString("footer")).setCreatedTime(object.getLong("createdTime"));
            return info;
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to map message from node " + path + ""), (Throwable)e);
            return null;
        }
    }

    private String getDataJson(Node node) throws Exception {
        Node fileNode = node.getNode("datajson");
        Node nodeContent = fileNode.getNode("jcr:content");
        InputStream stream = nodeContent.getProperty("jcr:data").getStream();
        return StringCommonUtils.decompress(stream);
    }

    private NodeIterator getMessageInfoNodes() {
        return this.getSubNodes("eXoNotification", "messageInfoHome");
    }

    private NodeIterator getMailNotificationNodes() {
        return this.getSubNodes("eXoNotification", "messageHome");
    }

    private NodeIterator getSubNodes(String jcrPathAlias, String relPath) {
        Node parentNode = this.getNode(jcrPathAlias, relPath);
        if (parentNode != null) {
            try {
                return parentNode.getNodes();
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Error while getting sub nodes with path '" + relPath + "' from node with alias'" + jcrPathAlias + "'"), (Throwable)e);
            }
        }
        return null;
    }

    private Node getNode(String jcrPathAlias, String relPath) {
        Node parentNode = null;
        try {
            Node msgInfoHome;
            String eXoNotificationJCRPath = this.nodeHierarchyCreator.getJcrPath(jcrPathAlias);
            if (StringUtils.isNotBlank((String)eXoNotificationJCRPath) && this.session.itemExists(eXoNotificationJCRPath) && (msgInfoHome = (Node)this.session.getItem(eXoNotificationJCRPath)).hasNode(relPath)) {
                parentNode = msgInfoHome.getNode(relPath);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting Path '" + relPath + "' from node with alias'" + jcrPathAlias + "'"), (Throwable)e);
        }
        return parentNode;
    }

    private void migrateMailNotifData() throws RepositoryException, RepositoryConfigurationException {
        NodeIterator pluginNodesIterator = this.getMailNotificationNodes();
        while (pluginNodesIterator.hasNext()) {
            Node pluginNode = pluginNodesIterator.nextNode();
            NodeIterator dayNodesIterator = pluginNode.getNodes();
            while (dayNodesIterator.hasNext()) {
                Node dayNode = dayNodesIterator.nextNode();
                NodeIterator notifNodes = dayNode.getNodes();
                if (notifNodes.getSize() <= 0L) continue;
                LOG.info((Object)("    Progression mail notifications migration for plugin: " + pluginNode.getName() + " - day: " + dayNode.getName()));
                while (notifNodes.hasNext()) {
                    this.migrateMailNotifNodeToRDBMS(notifNodes.nextNode());
                }
            }
        }
    }

    private void migrateMailNotifNodeToRDBMS(Node node) {
        try {
            this.jpaMailNotificationStorage.save(this.jcrNotificationDataStorage.fillModel(node));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasQueueMessagesDataToMigrate() {
        return this.getMessageInfoNodes() != null && this.getMessageInfoNodes().hasNext();
    }
}

