/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl;

import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class NotificationSessionManager {
    private static ThreadLocal<SessionProvider> session_ = new ThreadLocal();

    public static SessionProvider getSessionProvider() {
        SessionProvider sProvider = session_.get();
        if (sProvider != null) {
            return sProvider;
        }
        return null;
    }

    public static boolean isExistingSessionProvider() {
        return session_.get() != null;
    }

    public static void closeSessionProvider(boolean requestClose) {
        SessionProvider sProvider = session_.get();
        if (sProvider != null && requestClose) {
            sProvider.close();
            session_.set(null);
        }
    }

    public static boolean createSystemProvider() {
        if (session_.get() == null) {
            SessionProvider sProvider = SessionProvider.createSystemProvider();
            session_.set(sProvider);
            return true;
        }
        return false;
    }
}

