/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.api.notification.template.ElementVisitor;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.SimpleElement;
import org.exoplatform.commons.notification.template.SimpleElementVistior;
import org.exoplatform.jpa.BaseTest;

public class TemplateTestCase
extends BaseTest {
    public TemplateTestCase() {
        this.setForceContainerReload(true);
    }

    private Element makeSubject() {
        return new SimpleElement().template("$USER has joined $PORTAL_NAME");
    }

    private Element makeDigestOne() {
        return new SimpleElement().template("$USER has joined $PORTAL_NAME");
    }

    private Element makeDigestThree() {
        return new SimpleElement().template("$USER_LIST have joined $PORTAL_NAME.");
    }

    private Element makeDigestMore() {
        return new SimpleElement().template("$LAST3_USERS and $COUNT more have joined $PORTAL_NAME.");
    }

    private Element makeInstantly() {
        return new SimpleElement().template("$LAST3_USERS and $COUNT more have joined $PORTAL_NAME.");
    }

    private DigestTemplate makeDigestTemplate() {
        return new DigestTemplate().digestOne("$USER has joined $PORTAL_NAME").digestThree("$USER_LIST has joined $PORTAL_NAME").digestMore("$LAST3_USERS and $COUNT more have joined $PORTAL_NAME.");
    }

    public void testInstantlyMail() throws Exception {
        Element instantly = this.makeDigestMore().addNewLine(true);
        ElementVisitor visitor = SimpleElementVistior.instance();
        TemplateContext context = new TemplateContext();
        context.put((Object)"$LAST3_USERS", (Object)"root,mary,demo,jame");
        context.put((Object)"$COUNT", (Object)"4");
        context.put((Object)"$PORTAL_NAME", (Object)"intranet");
        String got = instantly.accept(visitor.with(context)).out();
        TemplateTestCase.assertEquals((String)"root,mary,demo,jame and 4 more have joined intranet.<br/>", (String)got);
    }

    public void testDigestOne() throws Exception {
        Element instantly = this.makeDigestOne().addNewLine(true);
        ElementVisitor visitor = SimpleElementVistior.instance();
        TemplateContext context = new TemplateContext();
        context.put((Object)"$USER", (Object)"root");
        context.put((Object)"$PORTAL_NAME", (Object)"intranet");
        String got = instantly.accept(visitor.with(context)).out();
        TemplateTestCase.assertEquals((String)"root has joined intranet<br/>", (String)got);
    }

    public void testDigestThree() throws Exception {
        Element instantly = this.makeDigestThree().addNewLine(true);
        ElementVisitor visitor = SimpleElementVistior.instance();
        TemplateContext context = new TemplateContext();
        context.put((Object)"$USER_LIST", (Object)"root,demo,mary");
        context.put((Object)"$PORTAL_NAME", (Object)"intranet");
        String got = instantly.accept(visitor.with(context)).out();
        TemplateTestCase.assertEquals((String)"root,demo,mary have joined intranet.<br/>", (String)got);
    }

    public void testDigestMore() throws Exception {
        Element instantly = this.makeDigestThree().addNewLine(true);
        TemplateTestCase.assertNotNull((Object)instantly);
        ElementVisitor visitor = SimpleElementVistior.instance();
        TemplateTestCase.assertNotNull((Object)visitor);
        TemplateContext context = new TemplateContext();
        context.put((Object)"$USER_LIST", (Object)"root,demo,mary");
        context.put((Object)"$PORTAL_NAME", (Object)"intranet");
        visitor = visitor.with(context);
        TemplateTestCase.assertNotNull((Object)visitor);
        visitor = instantly.accept(visitor);
        TemplateTestCase.assertNotNull((Object)visitor);
        String got = visitor.out();
        TemplateTestCase.assertNotNull((Object)got);
        TemplateTestCase.assertEquals((String)"root,demo,mary have joined intranet.<br/>", (String)got);
    }

    public void testDigest() throws Exception {
        DigestTemplate digest = this.makeDigestTemplate();
        ElementVisitor visitor = SimpleElementVistior.instance();
        TemplateContext context = new TemplateContext();
        context.put((Object)"$USER_LIST", (Object)"root,demo,mary");
        context.put((Object)"$PORTAL_NAME", (Object)"intranet");
        context.digestType(3);
        String got = digest.accept(visitor.with(context)).out();
        TemplateTestCase.assertEquals((String)"root,demo,mary has joined intranet", (String)got);
    }
}

