/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.commons.notification.BaseNotificationTestCase;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;

public class UserStateServiceTest
extends BaseNotificationTestCase {
    private String SUPER_USER = "root";
    private UserStateService userStateService;

    public void setUp() throws Exception {
        super.setUp();
        this.loginUser(this.SUPER_USER, false);
        this.userStateService = (UserStateService)this.getService(UserStateService.class);
    }

    protected void tearDown() throws Exception {
        this.userStateService.userStateCache.clearCache();
    }

    public void testGetUserState() throws Exception {
        UserStateModel userModel = new UserStateModel(this.SUPER_USER, new Date().getTime(), "available");
        this.userStateService.save(userModel);
        UserStateModel model1 = this.userStateService.getUserState(this.SUPER_USER + "temp");
        UserStateServiceTest.assertNull((Object)model1);
        UserStateModel model2 = this.userStateService.getUserState(this.SUPER_USER);
        UserStateServiceTest.assertNotNull((Object)model2);
        UserStateServiceTest.assertEquals((String)this.SUPER_USER, (String)model2.getUserId());
        UserStateServiceTest.assertEquals((long)userModel.getLastActivity(), (long)model2.getLastActivity());
        UserStateServiceTest.assertEquals((String)"available", (String)model2.getStatus());
    }

    public void testPing() throws Exception {
        UserStateModel userModel = new UserStateModel(this.SUPER_USER, new Date().getTime(), "available");
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        UserStateServiceTest.assertNotSame((Object)userModel.getLastActivity(), (Object)this.userStateService.getUserState(this.SUPER_USER).getLastActivity());
        GregorianCalendar currentTime = new GregorianCalendar();
        Calendar time = (Calendar)((Calendar)currentTime).clone();
        time.add(12, -10);
        userModel.setLastActivity(time.getTime().getTime());
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        UserStateServiceTest.assertNotSame((Object)userModel.getLastActivity(), (Object)this.userStateService.getUserState(this.SUPER_USER).getLastActivity());
        this.loginUser("mary", true);
        UserStateServiceTest.assertTrue((boolean)this.userStateService.getUserState("mary").getStatus().equals("available"));
        this.loginUser("demo", false);
        UserStateServiceTest.assertNotNull((String)"User state of 'mary' is null while it was pinged before", (Object)this.userStateService.getUserState("mary"));
        UserStateServiceTest.assertNotNull((String)"User state status of 'mary' is null while it was pinged before", (Object)this.userStateService.getUserState("mary").getStatus());
        UserStateServiceTest.assertTrue((boolean)this.userStateService.getUserState("mary").getStatus().equals("available"));
        ConversationState.setCurrent(null);
        UserStateServiceTest.assertNull((Object)this.userStateService.getUserState("demo"));
    }

    public void testOnline() throws Exception {
        long date = new Date().getTime();
        UserStateModel userModel = new UserStateModel(this.SUPER_USER, date, "available");
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        List onlines = this.userStateService.online();
        UserStateServiceTest.assertEquals((int)1, (int)onlines.size());
        UserStateServiceTest.assertEquals((String)this.SUPER_USER, (String)((UserStateModel)onlines.get(0)).getUserId());
        UserStateServiceTest.assertNotSame((Object)date, (Object)((UserStateModel)onlines.get(0)).getLastActivity());
        UserStateServiceTest.assertEquals((String)"available", (String)((UserStateModel)onlines.get(0)).getStatus());
    }

    public void testLastLogin() {
        UserStateServiceTest.assertNull((Object)this.userStateService.lastLogin());
        this.loginUser("user1", true);
        UserStateServiceTest.assertEquals((String)"user1", (String)this.userStateService.lastLogin().getUserId());
        this.loginUser("user2", true);
        UserStateServiceTest.assertEquals((String)"user2", (String)this.userStateService.lastLogin().getUserId());
    }

    public void testIsOnline() throws Exception {
        long date = new Date().getTime();
        UserStateModel userModel = new UserStateModel(this.SUPER_USER, date, "available");
        this.userStateService.save(userModel);
        this.userStateService.ping(userModel.getUserId());
        UserStateServiceTest.assertTrue((boolean)this.userStateService.isOnline(this.SUPER_USER));
        UserStateServiceTest.assertFalse((boolean)this.userStateService.isOnline("demo"));
        this.loginUser("demo", true);
        UserStateServiceTest.assertTrue((boolean)this.userStateService.isOnline("demo"));
    }

    private void loginUser(String userId, boolean hasPing) {
        ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
        MembershipEntry membershipEntry = new MembershipEntry("/platform/administrators", "*");
        membershipEntries.add(membershipEntry);
        Identity identity = new Identity(userId, membershipEntries);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
        if (hasPing) {
            this.userStateService.ping(userId);
        }
    }
}

