/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CommonsUtils.class, Util.class})
public class CommonsUtilsMockingTest {
    @Test
    public void testShouldReturnDefaultPortalSite() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getDefaultPortal()).thenReturn((Object)"intranet");
        PowerMockito.mockStatic(CommonsUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)((UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class))).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)CommonsUtils.getCurrentSite()).thenCallRealMethod();
        SiteKey site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"intranet", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.PORTAL, (Object)site.getType());
    }

    @Test
    public void testShouldReturnCurrentSite() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getDefaultPortal()).thenReturn((Object)"intranet");
        PortalRequestContext requestContext = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
        PowerMockito.mockStatic(Util.class, (Class[])new Class[0]);
        Mockito.when((Object)Util.getPortalRequestContext()).thenReturn((Object)requestContext);
        PowerMockito.mockStatic(CommonsUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)((UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class))).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)CommonsUtils.getCurrentSite()).thenCallRealMethod();
        Mockito.when((Object)requestContext.getSiteKey()).thenReturn((Object)SiteKey.portal((String)"test_site"));
        SiteKey site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"test_site", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.PORTAL, (Object)site.getType());
        Mockito.when((Object)requestContext.getSiteKey()).thenReturn((Object)SiteKey.group((String)"group_site"));
        site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"group_site", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.GROUP, (Object)site.getType());
        Mockito.when((Object)requestContext.getSiteKey()).thenReturn((Object)SiteKey.user((String)"user_site"));
        site = CommonsUtils.getCurrentSite();
        Assert.assertEquals((Object)"user_site", (Object)site.getName());
        Assert.assertEquals((Object)SiteType.USER, (Object)site.getType());
    }

    public void testShouldReturnDefaultPortalOwner() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getDefaultPortal()).thenReturn((Object)"intranet");
        PowerMockito.mockStatic(CommonsUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)((UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class))).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)CommonsUtils.getCurrentSite()).thenCallRealMethod();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        Assert.assertEquals((Object)"intranet", (Object)portalOwner);
    }

    public void testShouldReturnCurrentPortalOwner() {
        UserPortalConfigService userPortalConfig = (UserPortalConfigService)Mockito.mock(UserPortalConfigService.class);
        Mockito.when((Object)userPortalConfig.getDefaultPortal()).thenReturn((Object)"intranet");
        PortalRequestContext requestContext = (PortalRequestContext)Mockito.mock(PortalRequestContext.class);
        PowerMockito.mockStatic(Util.class, (Class[])new Class[0]);
        Mockito.when((Object)Util.getPortalRequestContext()).thenReturn((Object)requestContext);
        PowerMockito.mockStatic(CommonsUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)((UserPortalConfigService)CommonsUtils.getService(UserPortalConfigService.class))).thenReturn((Object)userPortalConfig);
        Mockito.when((Object)CommonsUtils.getCurrentSite()).thenCallRealMethod();
        Mockito.when((Object)requestContext.getPortalOwner()).thenReturn((Object)"current_portal_owner");
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        Assert.assertEquals((Object)"current_portal_owner", (Object)portalOwner);
    }
}

