/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.StateKey;

public class CommonsUtils {
    private static final Log LOG = ExoLogger.getLogger((String)CommonsUtils.class.getName());
    public static final String CONFIGURED_TENANT_MASTER_HOST_KEY = "tenant.masterhost";
    public static final String CONFIGURED_DOMAIN_URL_KEY = "gatein.email.domain.url";

    public static OrganizationService getOrganizationService() {
        return (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstance(OrganizationService.class);
    }

    public static ConversationRegistry getConversationRegistry() {
        return (ConversationRegistry)ExoContainerContext.getCurrentContainer().getComponentInstance(ConversationRegistry.class);
    }

    public static boolean isUserEnabled(String userId) throws Exception {
        if (IdentityConstants.ANONIM.equals(userId) || IdentityConstants.SYSTEM.equals(userId)) {
            return true;
        }
        User user = CommonsUtils.getOrganizationService().getUserHandler().findUserByName(userId, UserStatus.ANY);
        return user == null ? false : user.isEnabled();
    }

    public static ConversationState getConversationState(String userId) {
        ConversationRegistry conversationRegistry = CommonsUtils.getConversationRegistry();
        if (conversationRegistry == null) {
            return null;
        }
        List stateKeys = conversationRegistry.getStateKeys(userId);
        ConversationState conversationState = null;
        if (stateKeys != null && !stateKeys.isEmpty()) {
            StateKey stateKey = (StateKey)stateKeys.get(stateKeys.size() - 1);
            conversationState = conversationRegistry.getState(stateKey);
        }
        return conversationState;
    }

    public static User getUser(String userId) throws Exception {
        return CommonsUtils.getOrganizationService().getUserHandler().findUserByName(userId, UserStatus.ANY);
    }

    public static Collection<String> getGroupsOfUser(String userId) throws Exception {
        Identity identity;
        Collection groupIDs = null;
        ConversationState conversationState = CommonsUtils.getConversationState(userId);
        Identity identity2 = identity = conversationState == null ? null : conversationState.getIdentity();
        if (identity == null) {
            Collection groups = CommonsUtils.getOrganizationService().getGroupHandler().findGroupsOfUser(userId);
            groupIDs = groups.stream().map(Group::getId).collect(Collectors.toSet());
        } else {
            groupIDs = identity.getGroups();
        }
        return groupIDs;
    }

    public static <T> T getService(Class<T> clazz) {
        return CommonsUtils.getService(clazz, null);
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static String getRestContextName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return portalContainerConfig.getRestContextName(containerInfo.getContainerName());
    }

    public static boolean isFeatureActive(String featureName) {
        ExoFeatureService featureService = CommonsUtils.getService(ExoFeatureService.class);
        if (featureService == null) {
            return false;
        }
        return featureService.isActiveFeature(featureName);
    }

    public static boolean isFeatureActive(String featureName, String username) {
        ExoFeatureService featureService = CommonsUtils.getService(ExoFeatureService.class);
        if (featureService == null) {
            return false;
        }
        return featureService.isFeatureActiveForUser(featureName, username);
    }

    public static String getCurrentDomain() {
        String sysDomain = System.getProperty(CONFIGURED_DOMAIN_URL_KEY);
        if (sysDomain == null || sysDomain.length() == 0) {
            throw new NullPointerException("Get the domain is unsuccessfully. Please, add configuration domain on configuration.properties file with key: gatein.email.domain.url");
        }
        return sysDomain;
    }

    public static String getCurrentPortalOwner() {
        PortalRequestContext pContext = null;
        try {
            pContext = Util.getPortalRequestContext();
        }
        catch (NullPointerException e) {
            pContext = null;
        }
        if (pContext != null) {
            return pContext.getPortalOwner();
        }
        UserPortalConfigService portalConfig = CommonsUtils.getService(UserPortalConfigService.class);
        return portalConfig == null ? null : portalConfig.getDefaultPortal();
    }

    public static SiteKey getCurrentSite() {
        PortalRequestContext pContext = null;
        try {
            pContext = Util.getPortalRequestContext();
        }
        catch (NullPointerException e) {
            pContext = null;
        }
        if (pContext != null) {
            return pContext.getSiteKey();
        }
        UserPortalConfigService portalConfig = CommonsUtils.getService(UserPortalConfigService.class);
        return portalConfig == null ? null : SiteKey.portal((String)portalConfig.getDefaultPortal());
    }

    public static void startRequest(Object service) {
        if (service instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)service).startRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static void endRequest(Object service) {
        if (service instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)service).endRequest(ExoContainerContext.getCurrentContainer());
        }
    }
}

