/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.net;

import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class WebNotificationSender {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationSender.class);
    private static final String COMETD_CHANNEL = "/eXo/Application/web/NotificationMessage";

    public static void sendJsonMessage(String remoteId, MessageInfo message) {
        try {
            ContinuationService continuation;
            if (message != null && (continuation = CommonsUtils.getService(ContinuationService.class)).isPresent(remoteId)) {
                JsonValue json = new JsonGeneratorImpl().createJsonObject((Object)message);
                continuation.sendMessage(remoteId, COMETD_CHANNEL, (Object)json);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to send notification message:" + e.getMessage()));
        }
    }
}

