/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.notification.NotificationUtils;

public class NotificationUtilsTest
extends TestCase {
    public void testGetLocale() {
        String language = null;
        Locale actual = NotificationUtils.getLocale(language);
        NotificationUtilsTest.assertEquals((Object)Locale.ENGLISH, (Object)actual);
        language = "";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)Locale.ENGLISH, (Object)actual);
        language = "fr";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)Locale.FRENCH, (Object)actual);
        language = "pt_BR";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)new Locale("pt", "BR"), (Object)actual);
        language = "pt_BR_BR";
        actual = NotificationUtils.getLocale((String)language);
        NotificationUtilsTest.assertEquals((Object)new Locale("pt", "BR", "BR"), (Object)actual);
    }

    public void testIsValidNotificationSenderName() {
        String senderName = "";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "    ";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "    test123456";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test12, 34 56; test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "123456";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "123 test 456";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "123 45 6";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test123456";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test12 34 56 test";
        NotificationUtilsTest.assertFalse((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
        senderName = "test  test";
        NotificationUtilsTest.assertTrue((boolean)NotificationUtils.isValidNotificationSenderName((String)senderName));
    }

    public void testIsValidEmailAddresses() {
        String emails = "";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "#%^&test@test.com";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.787";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "no reply aaa@xyz.com, demo+aaa@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)false, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test.ABC@demo.COM";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test.ABC.def@demo2test.vn";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com.vn";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com, demo@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test@test.com ,  demo@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "test+test@test.com, demo+aaa@demo.com, ";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "Justin Dickey<justin.dickey@apprentice.university>";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
        emails = "eXo Admin<team-cwi@exoplatform.com>";
        NotificationUtilsTest.assertEquals((boolean)true, (boolean)NotificationUtils.isValidEmailAddresses((String)emails));
    }

    public void testProcessLinkInActivityTitle() throws Exception {
        String title = "<a href=\"www.yahoo.com\">Yahoo Site</a> is better than <a href=\"www.hotmail.com\">Hotmail Site</a>";
        title = NotificationUtils.processLinkTitle((String)title);
        NotificationUtilsTest.assertEquals((String)"<a href=\"www.yahoo.com\" style=\"color: #2f5e92; text-decoration: none;\">Yahoo Site</a> is better than <a href=\"www.hotmail.com\" style=\"color: #2f5e92; text-decoration: none;\">Hotmail Site</a>", (String)title);
    }

    public void testCloneUserSettting() {
        UserSetting setting = UserSetting.getInstance();
        setting.setUserId("test");
        setting.setChannelActive("channel_test");
        List<String> pluginIds = Arrays.asList("ActivityMentionPlugin,PostActivityPlugin,ActivityCommentPlugin,SpaceInvitationPlugin,RequestJoinSpacePlugin".split(","));
        for (String pluginId : pluginIds) {
            setting.addChannelPlugin("channel_test", pluginId);
        }
        UserSetting clone = setting.clone();
        NotificationUtilsTest.assertEquals((String)setting.getUserId(), (String)clone.getUserId());
        clone.setUserId("test1");
        clone.setChannelActive("channel_test1");
        clone.addChannelPlugin("channel_test", "NewUserPlugin");
        clone.addChannelPlugin("channel_test1", "NewUserPlugin");
        NotificationUtilsTest.assertFalse((boolean)setting.getUserId().equals(clone.getUserId()));
        NotificationUtilsTest.assertFalse((boolean)setting.getPlugins("channel_test").contains("NewUserPlugin"));
        NotificationUtilsTest.assertTrue((boolean)clone.getPlugins("channel_test").contains("NewUserPlugin"));
        NotificationUtilsTest.assertTrue((boolean)setting.getPlugins("channel_test1").isEmpty());
        NotificationUtilsTest.assertTrue((boolean)clone.getPlugins("channel_test1").contains("NewUserPlugin"));
        NotificationUtilsTest.assertTrue((boolean)setting.getChannelActives().contains("channel_test"));
        NotificationUtilsTest.assertFalse((boolean)setting.getChannelActives().contains("channel_test1"));
        NotificationUtilsTest.assertTrue((boolean)clone.getChannelActives().contains("channel_test"));
        NotificationUtilsTest.assertTrue((boolean)clone.getChannelActives().contains("channel_test1"));
    }

    public void testNotificationInfoClone() {
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        ownerParameter.put("test", "value test");
        NotificationInfo info = NotificationInfo.instance();
        info.setFrom("demo").key("notifiId").setOrder(1).setOwnerParameter(ownerParameter).setSendToDaily(new String[]{"plugin1", "plugin2"}).setSendToWeekly(new String[]{"plugin2", "plugin3"}).setTo("root");
        NotificationInfo clone = info.clone();
        NotificationUtilsTest.assertEquals((String)info.getId(), (String)clone.getId());
        NotificationUtilsTest.assertEquals((String)info.getId(), (String)clone.getId());
        NotificationUtilsTest.assertEquals((String)info.getFrom(), (String)clone.getFrom());
        NotificationUtilsTest.assertEquals((String)info.getTo(), (String)clone.getTo());
        NotificationUtilsTest.assertTrue((boolean)Arrays.equals(info.getSendToDaily(), clone.getSendToDaily()));
        NotificationUtilsTest.assertTrue((boolean)Arrays.equals(info.getSendToWeekly(), clone.getSendToWeekly()));
        NotificationUtilsTest.assertTrue((boolean)CollectionUtils.isEqualCollection(info.getOwnerParameter().keySet(), clone.getOwnerParameter().keySet()));
        NotificationUtilsTest.assertTrue((boolean)CollectionUtils.isEqualCollection(info.getOwnerParameter().values(), clone.getOwnerParameter().values()));
        NotificationUtilsTest.assertEquals((String)info.getValueOwnerParameter("test"), (String)clone.getValueOwnerParameter("test"));
        clone.getSendToDaily()[0] = "plugin4";
        clone.getOwnerParameter().put("test", "value clone");
        NotificationUtilsTest.assertFalse((boolean)Arrays.equals(info.getSendToDaily(), clone.getSendToDaily()));
        NotificationUtilsTest.assertFalse((boolean)CollectionUtils.isEqualCollection(info.getOwnerParameter().values(), clone.getOwnerParameter().values()));
        NotificationUtilsTest.assertFalse((boolean)info.getValueOwnerParameter("test").equals(clone.getValueOwnerParameter("test")));
    }
}

