/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage;
import org.exoplatform.commons.notification.impl.service.storage.cache.CacheKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.CacheLoader;
import org.exoplatform.commons.notification.impl.service.storage.cache.ServiceContext;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.IntegerData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoCacheKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;

public class CachedWebNotificationStorage
implements WebNotificationStorage {
    private static final String WEB_NOTIFICATION_CACHING_NAME = "commons.WebNotificationCache";
    private static final String LIST_WEB_NOTIFICATION_CACHING_NAME = "commons.WebNotificationsCache";
    private static final String WEB_NOTIFICATION_COUNT_CACHING_NAME = "commons.WebNotificationCountCache";
    private static final String WEB_NOTIFICATION_BY_PLUGIN_COUNT_CACHING_NAME = "commons.WebNotificationCountByPluginCache";
    private final ExoCache<WebNotifInfoCacheKey, NotificationInfo> webNotificationCache;
    private final ExoCache<WebNotifInfoCacheKey, IntegerData> webNotificationCountCache;
    private final ExoCache<WebNotifInfoCacheKey, Map<String, Integer>> webNotificationCountByPluginCache;
    private final ExoCache<ListWebNotificationsKey, ListWebNotificationsData> webNotificationsCache;
    private FutureExoCache<WebNotifInfoCacheKey, NotificationInfo, ServiceContext<NotificationInfo>> futureWebNotificationCache;
    private FutureExoCache<ListWebNotificationsKey, ListWebNotificationsData, ServiceContext<ListWebNotificationsData>> futureWebNotificationsCache;
    private FutureExoCache<WebNotifInfoCacheKey, IntegerData, ServiceContext<IntegerData>> futureWebNotificationCountCache;
    private FutureExoCache<WebNotifInfoCacheKey, Map<String, Integer>, Object> futureWebNotificationCountByPluginCache;
    private WebNotificationStorage storage;

    public CachedWebNotificationStorage(final JPAWebNotificationStorage storage, CacheService cacheService) {
        this.storage = storage;
        this.webNotificationCache = cacheService.getCacheInstance(WEB_NOTIFICATION_CACHING_NAME);
        this.webNotificationsCache = cacheService.getCacheInstance(LIST_WEB_NOTIFICATION_CACHING_NAME);
        this.webNotificationCountCache = cacheService.getCacheInstance(WEB_NOTIFICATION_COUNT_CACHING_NAME);
        this.webNotificationCountByPluginCache = cacheService.getCacheInstance(WEB_NOTIFICATION_BY_PLUGIN_COUNT_CACHING_NAME);
        this.futureWebNotificationCache = this.createFutureCache(this.webNotificationCache);
        this.futureWebNotificationsCache = this.createFutureCache(this.webNotificationsCache);
        this.futureWebNotificationCountCache = this.createFutureCache(this.webNotificationCountCache);
        this.futureWebNotificationCountByPluginCache = new FutureExoCache((Loader)new Loader<WebNotifInfoCacheKey, Map<String, Integer>, Object>(){

            public Map<String, Integer> retrieve(Object context, WebNotifInfoCacheKey key) throws Exception {
                return storage.countUnreadByPlugin(key.getId());
            }
        }, this.webNotificationCountByPluginCache);
    }

    public void save(NotificationInfo notification) {
        if (notification.isUpdate()) {
            this.storage.update(notification, true);
        } else {
            this.storage.save(notification);
        }
        this.updateCacheByUser(notification.getTo());
    }

    public void update(NotificationInfo notification, boolean moveTop) {
        notification.setUpdate(true);
        notification.setResetOnBadge(!moveTop);
        this.storage.update(notification, moveTop);
        this.updateCacheByUser(notification.getTo());
    }

    public void markRead(String notificationId) {
        this.storage.markRead(notificationId);
        this.updateRead(notificationId);
    }

    public void markAllRead(String userId) {
        this.storage.markAllRead(userId);
        this.updateCacheByUser(userId);
    }

    public void markAllRead(List<String> plugins, String username) {
        this.storage.markAllRead(plugins, username);
        this.updateCacheByUser(username);
    }

    public void hidePopover(String notificationId) {
        this.storage.hidePopover(notificationId);
        NotificationInfo infoData = (NotificationInfo)this.webNotificationCache.get((Serializable)WebNotifInfoCacheKey.key(notificationId));
        if (infoData != null) {
            this.updateCacheByUser(infoData.getTo());
        }
    }

    public List<NotificationInfo> get(WebNotificationFilter filter, int offset, int limit) {
        ListWebNotificationsKey key = new ListWebNotificationsKey(filter, offset, limit);
        ListWebNotificationsData keys = (ListWebNotificationsData)this.futureWebNotificationsCache.get(() -> {
            List got = this.storage.get(filter, offset, limit);
            return this.buildWebNotifDataIds(key, got);
        }, (Object)key);
        return this.buildNotifications(keys);
    }

    public boolean remove(String notificationId) {
        NotificationInfo notification = this.get(notificationId);
        if (notification == null) {
            return false;
        }
        this.storage.remove(notificationId);
        this.clearWebNotificationCache(notificationId);
        this.clearWebNotificationCountCache(notification.getTo());
        this.clearUserWebNotificationList(notification.getTo());
        return true;
    }

    public NotificationInfo get(String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        NotificationInfo notificationInfo = (NotificationInfo)this.futureWebNotificationCache.get(() -> this.storage.get(notificationId), (Object)key);
        return notificationInfo == null ? null : notificationInfo.clone();
    }

    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String owner) {
        return this.storage.getUnreadNotification(pluginId, activityId, owner);
    }

    public boolean remove(String userId, long seconds) {
        this.clearWebNotificationCountCache(userId);
        this.updateCacheByUser(userId);
        return this.storage.remove(userId, seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long seconds) {
        boolean removed = false;
        try {
            boolean bl = removed = this.storage.remove(seconds);
            return bl;
        }
        finally {
            if (removed) {
                this.webNotificationCache.clearCache();
                this.webNotificationCountCache.clearCache();
                this.webNotificationCountByPluginCache.clearCache();
            }
        }
    }

    public int getNumberOnBadge(String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(userId);
            IntegerData numberOfMessageData = (IntegerData)this.futureWebNotificationCountCache.get(() -> new IntegerData(this.storage.getNumberOnBadge(userId)), (Object)key);
            return (Integer)numberOfMessageData.build();
        }
        return 0;
    }

    public Map<String, Integer> countUnreadByPlugin(String userId) {
        return (Map)this.futureWebNotificationCountByPluginCache.get(null, (Object)WebNotifInfoCacheKey.key(userId));
    }

    public void resetNumberOnBadge(String userId) {
        this.storage.resetNumberOnBadge(userId);
        this.clearWebNotificationCountCache(userId);
    }

    public void resetNumberOnBadge(List<String> plugins, String username) {
        this.storage.resetNumberOnBadge(plugins, username);
        this.clearWebNotificationCountCache(username);
    }

    public void setStorage(WebNotificationStorage storage) {
        this.storage = storage;
    }

    public void updateAllRead(String userId) {
        this.updateCacheByUser(userId);
    }

    private void updateRead(String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        NotificationInfo infoData = (NotificationInfo)this.webNotificationCache.get((Serializable)key);
        if (infoData != null) {
            this.updateCacheByUser(infoData.getTo());
        }
    }

    private void updateCacheByUser(String userId) {
        this.clearUserWebNotificationList(userId);
        this.clearUserWebNotifications(userId);
        this.clearWebNotificationCountCache(userId);
    }

    private void clearUserWebNotifications(final String userId) {
        try {
            this.webNotificationCache.select((CachedObjectSelector)new CachedObjectSelector<WebNotifInfoCacheKey, NotificationInfo>(){

                public boolean select(WebNotifInfoCacheKey key, ObjectCacheInfo<? extends NotificationInfo> ocinfo) {
                    return ocinfo.get() != null && userId.equals(((NotificationInfo)ocinfo.get()).getTo());
                }

                public void onSelect(ExoCache<? extends WebNotifInfoCacheKey, ? extends NotificationInfo> cache, WebNotifInfoCacheKey key, ObjectCacheInfo<? extends NotificationInfo> ocinfo) throws Exception {
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't update Notifications List Cache entries for user " + userId, e);
        }
    }

    private void clearUserWebNotificationList(final String userId) {
        try {
            this.webNotificationsCache.select((CachedObjectSelector)new CachedObjectSelector<ListWebNotificationsKey, ListWebNotificationsData>(){

                public boolean select(ListWebNotificationsKey key, ObjectCacheInfo<? extends ListWebNotificationsData> ocinfo) {
                    return userId.equals(key.getUserId());
                }

                public void onSelect(ExoCache<? extends ListWebNotificationsKey, ? extends ListWebNotificationsData> cache, ListWebNotificationsKey key, ObjectCacheInfo<? extends ListWebNotificationsData> ocinfo) throws Exception {
                    cache.remove((Serializable)key);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't update Notification Cache entries for user " + userId, e);
        }
    }

    private ListWebNotificationsData getWebNotificationsData(ListWebNotificationsKey key) {
        ListWebNotificationsData data = (ListWebNotificationsData)this.webNotificationsCache.get((Serializable)key);
        if (data == null) {
            data = new ListWebNotificationsData(key);
            this.webNotificationsCache.put((Serializable)key, (Object)data);
        }
        return data;
    }

    private ListWebNotificationsData buildWebNotifDataIds(ListWebNotificationsKey key, List<NotificationInfo> notifications) {
        ListWebNotificationsData data = this.getWebNotificationsData(key);
        int len = notifications.size();
        for (int i = 0; i < len; ++i) {
            NotificationInfo notif = notifications.get(i);
            if (notif == null) continue;
            WebNotifInfoCacheKey webNotifKey = WebNotifInfoCacheKey.key(notif.getId());
            NotificationInfo cachedNotificationInfo = (NotificationInfo)this.webNotificationCache.get((Serializable)webNotifKey);
            if (cachedNotificationInfo == null) {
                this.webNotificationCache.put((Serializable)webNotifKey, (Object)notif);
            }
            if (data.contains(notif.getId())) continue;
            data.insertLast(notif.getId());
        }
        return data;
    }

    private List<NotificationInfo> buildNotifications(ListWebNotificationsData data) {
        ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
        for (String id : data.getList()) {
            NotificationInfo a = this.get(id);
            if (a == null) continue;
            notifications.add(a);
        }
        return notifications;
    }

    private void clearWebNotificationCountCache(String userId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(userId);
        this.webNotificationCountCache.remove((Serializable)key);
        this.webNotificationCountByPluginCache.remove((Serializable)key);
    }

    public void clearWebNotificationCache(String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        this.webNotificationCache.remove((Serializable)key);
    }

    private <K extends CacheKey, V extends Serializable> FutureExoCache<K, V, ServiceContext<V>> createFutureCache(ExoCache<K, V> cache) {
        return new FutureExoCache(new CacheLoader(), cache);
    }
}

