/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import org.apache.commons.dbcp.BasicDataSource;
import org.exoplatform.commons.persistence.impl.ChangeLogsPlugin;
import org.exoplatform.commons.persistence.impl.LiquibaseDataInitializer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LiquibaseDataInitializerTest {
    @Test
    public void shouldSetDatasourceNameWhenDatasourceNameIsDefinedInConfiguration() {
        InitParams initParams = new InitParams();
        ValueParam datasourceNameValueParam = new ValueParam();
        datasourceNameValueParam.setName("liquibase.datasource");
        datasourceNameValueParam.setValue("datasource1");
        initParams.addParam((Object)datasourceNameValueParam);
        LiquibaseDataInitializer liquibaseDataInitializer = new LiquibaseDataInitializer(initParams);
        Assert.assertEquals((Object)liquibaseDataInitializer.getDatasourceName(), (Object)"datasource1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenDatasourceNameIsNotDefinedInConfiguration() {
        InitParams initParams = new InitParams();
        LiquibaseDataInitializer liquibaseDataInitializer = new LiquibaseDataInitializer(initParams);
    }

    @Test
    public void shouldSetContextsWhenContextsAreDefinedInConfiguration() {
        InitParams initParams = new InitParams();
        ValueParam datasourceNameValueParam = new ValueParam();
        datasourceNameValueParam.setName("liquibase.datasource");
        datasourceNameValueParam.setValue("datasource1");
        initParams.addParam((Object)datasourceNameValueParam);
        ValueParam contextsValueParam = new ValueParam();
        contextsValueParam.setName("liquibase.contexts");
        contextsValueParam.setValue("context1");
        initParams.addParam((Object)contextsValueParam);
        LiquibaseDataInitializer liquibaseDataInitializer = new LiquibaseDataInitializer(initParams);
        Assert.assertEquals((Object)liquibaseDataInitializer.getContexts(), (Object)"context1");
    }

    @Test
    public void shouldUseDefaultContextsWhenContextsAreNotDefinedInConfiguration() {
        InitParams initParams = new InitParams();
        ValueParam datasourceNameValueParam = new ValueParam();
        datasourceNameValueParam.setName("liquibase.datasource");
        datasourceNameValueParam.setValue("datasource1");
        initParams.addParam((Object)datasourceNameValueParam);
        LiquibaseDataInitializer liquibaseDataInitializer = new LiquibaseDataInitializer(initParams);
        Assert.assertEquals((Object)liquibaseDataInitializer.getContexts(), (Object)"production");
    }

    @Test
    public void shouldNotCallLiquibaseWhenNoChangeLogs() throws LiquibaseException {
        InitParams initParams = new InitParams();
        ValueParam datasourceNameValueParam = new ValueParam();
        datasourceNameValueParam.setName("liquibase.datasource");
        datasourceNameValueParam.setValue("datasource1");
        initParams.addParam((Object)datasourceNameValueParam);
        LiquibaseDataInitializer liquibaseDataInitializer = (LiquibaseDataInitializer)Mockito.spy((Object)new LiquibaseDataInitializer(initParams));
        liquibaseDataInitializer.initData();
        ((LiquibaseDataInitializer)Mockito.verify((Object)liquibaseDataInitializer, (VerificationMode)Mockito.never())).applyChangeLog((DataSource)Mockito.any(DataSource.class), (String)Mockito.any(String.class));
    }

    @Test
    public void shouldCallLiquibaseWhenChangeLogsAreAdded() throws LiquibaseException, SQLException {
        InitParams initParams = new InitParams();
        ValueParam datasourceNameValueParam = new ValueParam();
        datasourceNameValueParam.setName("liquibase.datasource");
        datasourceNameValueParam.setValue("datasource1");
        initParams.addParam((Object)datasourceNameValueParam);
        LiquibaseDataInitializer liquibaseDataInitializer = (LiquibaseDataInitializer)Mockito.spy((Object)new LiquibaseDataInitializer(initParams));
        ((LiquibaseDataInitializer)Mockito.doNothing().when((Object)liquibaseDataInitializer)).applyChangeLog((DataSource)Mockito.any(DataSource.class), (String)Mockito.any(String.class));
        ((LiquibaseDataInitializer)Mockito.doReturn((Object)new BasicDataSource()).when((Object)liquibaseDataInitializer)).getDatasource((String)Mockito.any(String.class));
        ArrayList<String> changeLogsPaths = new ArrayList<String>(3);
        changeLogsPaths.add("changelog1");
        changeLogsPaths.add("changelog2");
        changeLogsPaths.add("changelog3");
        InitParams changeLogsPluginInitParams = new InitParams();
        ValuesParam changeLogsValuesParam = new ValuesParam();
        changeLogsValuesParam.setName("changelogs");
        changeLogsValuesParam.setValues(changeLogsPaths);
        changeLogsPluginInitParams.addParam((Object)changeLogsValuesParam);
        ChangeLogsPlugin changeLogsPlugin = new ChangeLogsPlugin(changeLogsPluginInitParams);
        liquibaseDataInitializer.addChangeLogsPlugin(changeLogsPlugin);
        liquibaseDataInitializer.initData();
        ((LiquibaseDataInitializer)Mockito.verify((Object)liquibaseDataInitializer, (VerificationMode)Mockito.times((int)3))).applyChangeLog((DataSource)Mockito.any(DataSource.class), (String)Mockito.any(String.class));
    }
}

