/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.user;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.user.UserStateModel;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class UserStateService {
    public static final String DEFAULT_STATUS = "available";
    public static final String STATUS_OFFLINE = "offline";
    public static final String INVISIBLE = "invisible";
    public static final String USER_STATE_CACHE_NAME = "commons.UserStateService";
    private static final int DEFAULT_OFFLINE_DELAY = 60000;
    private final ExoCache<String, String> userStateCache;
    private final EXoContinuationBayeux eXoContinuationBayeux;

    public UserStateService(EXoContinuationBayeux eXoContinuationBayeux, CacheService cacheService) {
        this.eXoContinuationBayeux = eXoContinuationBayeux;
        this.userStateCache = cacheService.getCacheInstance(USER_STATE_CACHE_NAME);
    }

    public List<UserStateModel> online() {
        long lastActivity = System.currentTimeMillis();
        Set connectedUserIds = this.eXoContinuationBayeux.getConnectedUserIds();
        return connectedUserIds.stream().map(userId -> {
            String status = (String)this.userStateCache.get((Serializable)((Object)userId));
            if (status == null) {
                status = DEFAULT_STATUS;
            } else if (STATUS_OFFLINE.equals(status) || INVISIBLE.equals(status)) {
                return null;
            }
            return new UserStateModel((String)userId, lastActivity, status);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean isOnline(String userId) {
        return this.eXoContinuationBayeux.isPresent(userId);
    }

    public UserStateModel getUserState(String userId) {
        boolean online = this.eXoContinuationBayeux.isPresent(userId);
        if (!online) {
            return new UserStateModel(userId, 0L, STATUS_OFFLINE);
        }
        String status = (String)this.userStateCache.get((Serializable)((Object)userId));
        if (status == null) {
            status = DEFAULT_STATUS;
        }
        return new UserStateModel(userId, System.currentTimeMillis(), status);
    }

    public UserStateModel lastLogin() {
        List<UserStateModel> online = this.online();
        if (!online.isEmpty()) {
            return online.get(online.size() - 1);
        }
        return null;
    }

    public void saveStatus(String userId, String status) {
        this.userStateCache.put((Serializable)((Object)userId), (Object)status);
    }

    @Deprecated
    public int getDelay() {
        return 60000;
    }

    @Deprecated
    public void save(UserStateModel model) {
        this.saveStatus(model.getUserId(), model.getStatus());
    }

    @Deprecated
    public UserStateModel ping(String userId) {
        UserStateModel userState = this.getUserState(userId);
        if (userState == null) {
            this.saveStatus(userId, DEFAULT_STATUS);
            return new UserStateModel(userId, System.currentTimeMillis(), DEFAULT_STATUS);
        }
        return userState;
    }

    public void clearCache() {
        this.userStateCache.clearCache();
    }
}

