/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.FeaturePlugin;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;

public class FeatureServiceTest
extends BaseCommonsTestCase {
    private ExoFeatureService featureService;
    private IdentityRegistry identityRegistry;

    public void setUp() throws Exception {
        super.setUp();
        this.featureService = (ExoFeatureService)this.getService(ExoFeatureService.class);
        this.identityRegistry = (IdentityRegistry)this.getService(IdentityRegistry.class);
    }

    public void testShouldFeatureBeActiveWhenSettingIsTrue() {
        this.featureService.saveActiveFeature("feature1", true);
        boolean activeFeature = this.featureService.isActiveFeature("feature1");
        FeatureServiceTest.assertTrue((boolean)activeFeature);
    }

    public void testShouldFeatureNotBeActiveWhenSettingIsFalse() {
        this.featureService.saveActiveFeature("feature2", false);
        boolean activeFeature = this.featureService.isActiveFeature("feature2");
        FeatureServiceTest.assertFalse((boolean)activeFeature);
    }

    public void testShouldFeatureBeActiveWhenNoSettingAndNoProperty() {
        boolean activeFeature = this.featureService.isActiveFeature("feature3");
        FeatureServiceTest.assertTrue((boolean)activeFeature);
    }

    public void testShouldFeatureBeActiveWhenNoSettingAndPropertyIsTrue() {
        System.setProperty("exo.feature.feature3.enabled", "true");
        boolean activeFeature = this.featureService.isActiveFeature("feature3");
        FeatureServiceTest.assertTrue((boolean)activeFeature);
    }

    public void testShouldFeatureNotBeActiveWhenNoSettingAndPropertyIsFalse() {
        System.setProperty("exo.feature.feature4.enabled", "false");
        boolean activeFeature = this.featureService.isActiveFeature("feature4");
        FeatureServiceTest.assertFalse((boolean)activeFeature);
    }

    public void testShouldFeatureBeActiveWhenSettingIsTrueAndPropertyIsFalse() {
        this.featureService.saveActiveFeature("feature5", true);
        System.setProperty("exo.feature.feature5.enabled", "false");
        boolean activeFeature = this.featureService.isActiveFeature("feature5");
        FeatureServiceTest.assertTrue((boolean)activeFeature);
    }

    public void testShouldFeatureNotBeActiveWhenSettingIsFalseAndPropertyIsTrue() {
        this.featureService.saveActiveFeature("feature6", false);
        System.setProperty("exo.feature.feature6.enabled", "true");
        boolean activeFeature = this.featureService.isActiveFeature("feature6");
        FeatureServiceTest.assertFalse((boolean)activeFeature);
    }

    public void testSaveActiveFeature() throws Exception {
        this.featureService.saveActiveFeature("notification", false);
        FeatureServiceTest.assertFalse((boolean)this.featureService.isActiveFeature("notification"));
        this.featureService.saveActiveFeature("notification", true);
        FeatureServiceTest.assertTrue((boolean)this.featureService.isActiveFeature("notification"));
    }

    public void testActiveFeatureForUser() throws Exception {
        FeatureServiceTest.assertTrue((String)"Feature should be enabled if no flag is stored in DB", (boolean)this.featureService.isActiveFeature("wallet"));
        FeatureServiceTest.assertTrue((String)"Feature should be enabled for a user if no plugin is added with this feature", (boolean)this.featureService.isFeatureActiveForUser("wallet", "toto"));
        this.featureService.saveActiveFeature("wallet", false);
        FeatureServiceTest.assertFalse((String)"Feature should be disabled after disabling it", (boolean)this.featureService.isActiveFeature("wallet"));
        FeatureServiceTest.assertFalse((String)"Feature should be disabled for all users after disabling it", (boolean)this.featureService.isFeatureActiveForUser("wallet", "toto"));
        this.featureService.saveActiveFeature("wallet", true);
        FeatureServiceTest.assertTrue((String)"Feature should be enabled if it's changed on DB", (boolean)this.featureService.isActiveFeature("wallet"));
        FeatureServiceTest.assertTrue((String)"Feature should be enabled for user after enabling it", (boolean)this.featureService.isFeatureActiveForUser("wallet", "toto"));
        this.featureService.addFeaturePlugin(new FeaturePlugin(){

            public String getName() {
                return "wallet";
            }

            public boolean isFeatureActiveForUser(String featureName, String username) {
                return StringUtils.equals((CharSequence)"toto", (CharSequence)username);
            }
        });
        FeatureServiceTest.assertTrue((String)"Feature should be globally enabled even after adding a plugin", (boolean)this.featureService.isActiveFeature("wallet"));
        FeatureServiceTest.assertTrue((String)"Feature should be enabled for user 'toto' only switch plugin code", (boolean)this.featureService.isFeatureActiveForUser("wallet", "toto"));
        FeatureServiceTest.assertTrue((String)"Feature should be enabled for user 'toto' only switch plugin code", (boolean)CommonsUtils.isFeatureActive((String)"wallet", (String)"toto"));
        FeatureServiceTest.assertFalse((String)"Feature should be enabled only for user 'toto' switch plugin code", (boolean)this.featureService.isFeatureActiveForUser("wallet", "titi"));
        FeatureServiceTest.assertFalse((String)"Feature should be enabled only for user 'toto' switch plugin code", (boolean)CommonsUtils.isFeatureActive((String)"wallet", (String)"titi"));
    }

    public void testActiveFeatureForAuthorizedUser() throws Exception {
        System.setProperty("exo.feature.feature1.permissions", "*:/platform/developers");
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/developers", "manager"));
        Identity identity = new Identity("usera", memberships);
        this.identityRegistry.register(identity);
        this.featureService.saveActiveFeature("feature1", true);
        boolean isActiveFeature = this.featureService.isFeatureActiveForUser("feature1", identity.getUserId());
        FeatureServiceTest.assertTrue((boolean)isActiveFeature);
        System.setProperty("exo.feature.feature1.permissions", "");
        isActiveFeature = this.featureService.isFeatureActiveForUser("feature1", identity.getUserId());
        FeatureServiceTest.assertTrue((boolean)isActiveFeature);
        System.setProperty("exo.feature.feature1.permissions", "*:/platform/developers");
        HashSet<MembershipEntry> memberships1 = new HashSet<MembershipEntry>();
        memberships1.add(new MembershipEntry("/platform/designers", "member"));
        Identity identity1 = new Identity("userb", memberships1);
        this.identityRegistry.register(identity1);
        this.featureService.saveActiveFeature("feature1", true);
        boolean test2 = this.featureService.isFeatureActiveForUser("feature1", identity1.getUserId());
        FeatureServiceTest.assertFalse((boolean)test2);
    }
}

