/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services.util;

import java.io.InputStream;
import java.security.MessageDigest;
import org.exoplatform.commons.utils.PropertyManager;

public final class FileChecksum {
    private static String defaultAlgorithm = "MD5";
    private static final String ALGORITHM_FILE_CHECKSUM_PROPERTY_NAME = "exo.file-rdbms.algorithm.checksum";
    private static String digestAlgorithm;

    public static String getChecksum(String string) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        digest.update(string.getBytes());
        byte[] messageDigest = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            sb.append(Integer.toString((messageDigest[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static String getChecksum(InputStream fis) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    static {
        String algorithm = PropertyManager.getProperty((String)ALGORITHM_FILE_CHECKSUM_PROPERTY_NAME);
        digestAlgorithm = algorithm != null && !algorithm.isEmpty() ? algorithm : defaultAlgorithm;
    }
}

