/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.imageio.plugins.gif;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.exoplatform.imageio.plugins.common.LZWCompressor;
import org.exoplatform.imageio.plugins.common.PaletteBuilder;
import org.exoplatform.imageio.plugins.gif.GIFImageWriteParam;
import org.exoplatform.imageio.plugins.gif.GIFImageWriterSpi;
import org.exoplatform.imageio.plugins.gif.GIFWritableImageMetadata;
import org.exoplatform.imageio.plugins.gif.GIFWritableStreamMetadata;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GIFImageWriter
extends ImageWriter {
    private static final Log LOG = ExoLogger.getLogger(GIFImageWriter.class);
    static final String STANDARD_METADATA_NAME = "javax_imageio_1.0";
    static final String STREAM_METADATA_NAME = "javax_imageio_gif_stream_1.0";
    static final String IMAGE_METADATA_NAME = "javax_imageio_gif_image_1.0";
    private ImageOutputStream stream = null;
    private boolean isWritingSequence = false;
    private boolean wroteSequenceHeader = false;
    private GIFWritableStreamMetadata theStreamMetadata = null;
    private int imageIndex = 0;

    private static int getNumBits(int value) throws IOException {
        int numBits;
        switch (value) {
            case 2: {
                numBits = 1;
                break;
            }
            case 4: {
                numBits = 2;
                break;
            }
            case 8: {
                numBits = 3;
                break;
            }
            case 16: {
                numBits = 4;
                break;
            }
            case 32: {
                numBits = 5;
                break;
            }
            case 64: {
                numBits = 6;
                break;
            }
            case 128: {
                numBits = 7;
                break;
            }
            case 256: {
                numBits = 8;
                break;
            }
            default: {
                throw new IOException("Bad palette length: " + value + "!");
            }
        }
        return numBits;
    }

    private static void computeRegions(Rectangle sourceBounds, Dimension destSize, ImageWriteParam p) {
        int periodX = 1;
        int periodY = 1;
        if (p != null) {
            int[] sourceBands = p.getSourceBands();
            if (sourceBands != null && (sourceBands.length != 1 || sourceBands[0] != 0)) {
                throw new IllegalArgumentException("Cannot sub-band image!");
            }
            Rectangle sourceRegion = p.getSourceRegion();
            if (sourceRegion != null) {
                sourceRegion = sourceRegion.intersection(sourceBounds);
                sourceBounds.setBounds(sourceRegion);
            }
            int gridX = p.getSubsamplingXOffset();
            int gridY = p.getSubsamplingYOffset();
            sourceBounds.x += gridX;
            sourceBounds.y += gridY;
            sourceBounds.width -= gridX;
            sourceBounds.height -= gridY;
            periodX = p.getSourceXSubsampling();
            periodY = p.getSourceYSubsampling();
        }
        destSize.setSize((sourceBounds.width + periodX - 1) / periodX, (sourceBounds.height + periodY - 1) / periodY);
        if (destSize.width <= 0 || destSize.height <= 0) {
            throw new IllegalArgumentException("Empty source region!");
        }
    }

    private static byte[] createColorTable(ColorModel colorModel, SampleModel sampleModel) {
        byte[] colorTable;
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            int mapSize = icm.getMapSize();
            int ctSize = GIFImageWriter.getGifPaletteSize(mapSize);
            byte[] reds = new byte[ctSize];
            byte[] greens = new byte[ctSize];
            byte[] blues = new byte[ctSize];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            for (int i = mapSize; i < ctSize; ++i) {
                reds[i] = reds[0];
                greens[i] = greens[0];
                blues[i] = blues[0];
            }
            colorTable = new byte[3 * ctSize];
            int idx = 0;
            for (int i = 0; i < ctSize; ++i) {
                colorTable[idx++] = reds[i];
                colorTable[idx++] = greens[i];
                colorTable[idx++] = blues[i];
            }
        } else if (sampleModel.getNumBands() == 1) {
            int numBits = sampleModel.getSampleSize()[0];
            if (numBits > 8) {
                numBits = 8;
            }
            int colorTableLength = 3 * (1 << numBits);
            colorTable = new byte[colorTableLength];
            for (int i = 0; i < colorTableLength; ++i) {
                colorTable[i] = (byte)(i / 3);
            }
        } else {
            colorTable = null;
        }
        return colorTable;
    }

    private static int getGifPaletteSize(int x) {
        if (x <= 2) {
            return 2;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public GIFImageWriter(GIFImageWriterSpi originatingProvider) {
        super(originatingProvider);
        LOG.debug((Object)"GIF Writer is created");
    }

    @Override
    public boolean canWriteSequence() {
        return true;
    }

    private void convertMetadata(String metadataFormatName, IIOMetadata inData, IIOMetadata outData) {
        String formatName = null;
        String nativeFormatName = inData.getNativeMetadataFormatName();
        if (nativeFormatName != null && nativeFormatName.equals(metadataFormatName)) {
            formatName = metadataFormatName;
        } else {
            String[] extraFormatNames = inData.getExtraMetadataFormatNames();
            if (extraFormatNames != null) {
                for (int i = 0; i < extraFormatNames.length; ++i) {
                    if (!extraFormatNames[i].equals(metadataFormatName)) continue;
                    formatName = metadataFormatName;
                    break;
                }
            }
        }
        if (formatName == null && inData.isStandardMetadataFormatSupported()) {
            formatName = STANDARD_METADATA_NAME;
        }
        if (formatName != null) {
            try {
                Node root = inData.getAsTree(formatName);
                outData.mergeTree(formatName, root);
            }
            catch (IIOInvalidTreeException e) {
                // empty catch block
            }
        }
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        IIOMetadata sm = this.getDefaultStreamMetadata(param);
        this.convertMetadata(STREAM_METADATA_NAME, inData, sm);
        return sm;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageType == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        GIFWritableImageMetadata im = (GIFWritableImageMetadata)this.getDefaultImageMetadata(imageType, param);
        boolean isProgressive = im.interlaceFlag;
        this.convertMetadata(IMAGE_METADATA_NAME, inData, im);
        if (param != null && param.canWriteProgressive()) {
            if (param.getProgressiveMode() != 3) {
                im.interlaceFlag = isProgressive;
            }
        }
        return im;
    }

    @Override
    public void endWriteSequence() throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() was not invoked!");
        }
        this.writeTrailer();
        this.resetLocal();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        int transparentIndex;
        GIFWritableImageMetadata imageMetadata = new GIFWritableImageMetadata();
        SampleModel sampleModel = imageType.getSampleModel();
        Rectangle sourceBounds = new Rectangle(sampleModel.getWidth(), sampleModel.getHeight());
        Dimension destSize = new Dimension();
        GIFImageWriter.computeRegions(sourceBounds, destSize, param);
        imageMetadata.imageWidth = destSize.width;
        imageMetadata.imageHeight = destSize.height;
        imageMetadata.interlaceFlag = param == null || !param.canWriteProgressive() || param.getProgressiveMode() != 0;
        ColorModel colorModel = imageType.getColorModel();
        imageMetadata.localColorTable = GIFImageWriter.createColorTable(colorModel, sampleModel);
        if (colorModel instanceof IndexColorModel && (transparentIndex = ((IndexColorModel)colorModel).getTransparentPixel()) != -1) {
            imageMetadata.transparentColorFlag = true;
            imageMetadata.transparentColorIndex = transparentIndex;
        }
        return imageMetadata;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        GIFWritableStreamMetadata streamMetadata = new GIFWritableStreamMetadata();
        streamMetadata.version = "89a";
        return streamMetadata;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }

    @Override
    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("Output is not set.");
        }
        this.resetLocal();
        if (streamMetadata == null) {
            this.theStreamMetadata = (GIFWritableStreamMetadata)this.getDefaultStreamMetadata(null);
        } else {
            this.theStreamMetadata = new GIFWritableStreamMetadata();
            this.convertMetadata(STREAM_METADATA_NAME, streamMetadata, this.theStreamMetadata);
        }
        this.isWritingSequence = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.resetLocal();
    }

    private void resetLocal() {
        this.isWritingSequence = false;
        this.wroteSequenceHeader = false;
        this.theStreamMetadata = null;
        this.imageIndex = 0;
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException("output is not an ImageOutputStream");
            }
            this.stream = (ImageOutputStream)output;
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream = null;
        }
    }

    @Override
    public void write(IIOMetadata sm, IIOImage iioimage, ImageWriteParam p) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (iioimage == null) {
            throw new IllegalArgumentException("iioimage == null!");
        }
        if (iioimage.hasRaster()) {
            throw new UnsupportedOperationException("canWriteRasters() == false!");
        }
        this.resetLocal();
        GIFWritableStreamMetadata streamMetadata = sm == null ? (GIFWritableStreamMetadata)this.getDefaultStreamMetadata(p) : (GIFWritableStreamMetadata)this.convertStreamMetadata(sm, p);
        this.write(true, true, streamMetadata, iioimage, p);
    }

    @Override
    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        if (this.stream == null) {
            throw new IllegalStateException("output == null!");
        }
        if (image == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("canWriteRasters() == false!");
        }
        if (!this.isWritingSequence) {
            throw new IllegalStateException("prepareWriteSequence() was not invoked!");
        }
        this.write(!this.wroteSequenceHeader, false, this.theStreamMetadata, image, param);
        if (!this.wroteSequenceHeader) {
            this.wroteSequenceHeader = true;
        }
        ++this.imageIndex;
    }

    private boolean needToCreateIndex(RenderedImage image) {
        SampleModel sampleModel = image.getSampleModel();
        ColorModel colorModel = image.getColorModel();
        return sampleModel.getNumBands() != 1 || sampleModel.getSampleSize()[0] > 8 || colorModel.getComponentSize()[0] > 8;
    }

    private void write(boolean writeHeader, boolean writeTrailer, IIOMetadata sm, IIOImage iioimage, ImageWriteParam p) throws IOException {
        this.clearAbortRequest();
        RenderedImage image = iioimage.getRenderedImage();
        if (this.needToCreateIndex(image)) {
            image = PaletteBuilder.createIndexedImage(image);
            iioimage.setRenderedImage(image);
        }
        ColorModel colorModel = image.getColorModel();
        SampleModel sampleModel = image.getSampleModel();
        Rectangle sourceBounds = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        Dimension destSize = new Dimension();
        GIFImageWriter.computeRegions(sourceBounds, destSize, p);
        GIFWritableImageMetadata imageMetadata = null;
        if (iioimage.getMetadata() != null) {
            imageMetadata = new GIFWritableImageMetadata();
            this.convertMetadata(IMAGE_METADATA_NAME, iioimage.getMetadata(), imageMetadata);
            if (imageMetadata.localColorTable == null) {
                imageMetadata.localColorTable = GIFImageWriter.createColorTable(colorModel, sampleModel);
                if (colorModel instanceof IndexColorModel) {
                    IndexColorModel icm = (IndexColorModel)colorModel;
                    int index = icm.getTransparentPixel();
                    boolean bl = imageMetadata.transparentColorFlag = index != -1;
                    if (imageMetadata.transparentColorFlag) {
                        imageMetadata.transparentColorIndex = index;
                    }
                }
            }
        }
        byte[] globalColorTable = null;
        if (writeHeader) {
            if (sm == null) {
                throw new IllegalArgumentException("Cannot write null header!");
            }
            GIFWritableStreamMetadata streamMetadata = (GIFWritableStreamMetadata)sm;
            if (streamMetadata.version == null) {
                streamMetadata.version = "89a";
            }
            if (streamMetadata.logicalScreenWidth == -1) {
                streamMetadata.logicalScreenWidth = destSize.width;
            }
            if (streamMetadata.logicalScreenHeight == -1) {
                streamMetadata.logicalScreenHeight = destSize.height;
            }
            if (streamMetadata.colorResolution == -1) {
                int n = streamMetadata.colorResolution = colorModel != null ? colorModel.getComponentSize()[0] : sampleModel.getSampleSize()[0];
            }
            if (streamMetadata.globalColorTable == null) {
                if (this.isWritingSequence && imageMetadata != null && imageMetadata.localColorTable != null) {
                    streamMetadata.globalColorTable = imageMetadata.localColorTable;
                } else if (imageMetadata == null || imageMetadata.localColorTable == null) {
                    streamMetadata.globalColorTable = GIFImageWriter.createColorTable(colorModel, sampleModel);
                }
            }
            int bitsPerPixel = (globalColorTable = streamMetadata.globalColorTable) != null ? GIFImageWriter.getNumBits(globalColorTable.length / 3) : (imageMetadata != null && imageMetadata.localColorTable != null ? GIFImageWriter.getNumBits(imageMetadata.localColorTable.length / 3) : sampleModel.getSampleSize(0));
            this.writeHeader(streamMetadata, bitsPerPixel);
        } else if (this.isWritingSequence) {
            globalColorTable = this.theStreamMetadata.globalColorTable;
        } else {
            throw new IllegalArgumentException("Must write header for single image!");
        }
        this.writeImage(iioimage.getRenderedImage(), imageMetadata, p, globalColorTable, sourceBounds, destSize);
        if (writeTrailer) {
            this.writeTrailer();
        }
    }

    private void writeImage(RenderedImage image, GIFWritableImageMetadata imageMetadata, ImageWriteParam param, byte[] globalColorTable, Rectangle sourceBounds, Dimension destSize) throws IOException {
        boolean writeGraphicsControlExtension;
        ColorModel colorModel = image.getColorModel();
        SampleModel sampleModel = image.getSampleModel();
        if (imageMetadata == null) {
            imageMetadata = (GIFWritableImageMetadata)this.getDefaultImageMetadata(new ImageTypeSpecifier(image), param);
            writeGraphicsControlExtension = imageMetadata.transparentColorFlag;
        } else {
            NodeList list = null;
            IIOMetadataNode root = (IIOMetadataNode)imageMetadata.getAsTree(IMAGE_METADATA_NAME);
            list = root.getElementsByTagName("GraphicControlExtension");
            boolean bl = writeGraphicsControlExtension = list != null && list.getLength() > 0;
            if (param != null && param.canWriteProgressive()) {
                if (param.getProgressiveMode() == 0) {
                    imageMetadata.interlaceFlag = false;
                } else if (param.getProgressiveMode() == 1) {
                    imageMetadata.interlaceFlag = true;
                }
            }
        }
        if (Arrays.equals(globalColorTable, imageMetadata.localColorTable)) {
            imageMetadata.localColorTable = null;
        }
        imageMetadata.imageWidth = destSize.width;
        imageMetadata.imageHeight = destSize.height;
        if (writeGraphicsControlExtension) {
            this.writeGraphicControlExtension(imageMetadata);
        }
        this.writePlainTextExtension(imageMetadata);
        this.writeApplicationExtension(imageMetadata);
        this.writeCommentExtension(imageMetadata);
        int bitsPerPixel = GIFImageWriter.getNumBits(imageMetadata.localColorTable == null ? (globalColorTable == null ? sampleModel.getSampleSize(0) : globalColorTable.length / 3) : imageMetadata.localColorTable.length / 3);
        this.writeImageDescriptor(imageMetadata, bitsPerPixel);
        this.writeRasterData(image, sourceBounds, destSize, param, imageMetadata.interlaceFlag);
    }

    private void writeRows(RenderedImage image, LZWCompressor compressor, int sx, int sdx, int sy, int sdy, int sw, int dy, int ddy, int dw, int dh, int numRowsWritten, int progressReportRowPeriod) throws IOException {
        LOG.debug((Object)"Writing unoptimized");
        int[] sbuf = new int[sw];
        byte[] dbuf = new byte[dw];
        Raster raster = image.getNumXTiles() == 1 && image.getNumYTiles() == 1 ? image.getTile(0, 0) : image.getData();
        for (int y = dy; y < dh; y += ddy) {
            if (numRowsWritten % progressReportRowPeriod == 0) {
                if (this.abortRequested()) {
                    this.processWriteAborted();
                    return;
                }
                this.processImageProgress((float)numRowsWritten * 100.0f / (float)dh);
            }
            raster.getSamples(sx, sy, sw, 1, 0, sbuf);
            int i = 0;
            int j = 0;
            while (i < dw) {
                dbuf[i] = (byte)sbuf[j];
                ++i;
                j += sdx;
            }
            compressor.compress(dbuf, 0, dw);
            ++numRowsWritten;
            sy += sdy;
        }
    }

    private void writeRowsOpt(byte[] data, int offset, int lineStride, LZWCompressor compressor, int dy, int ddy, int dw, int dh, int numRowsWritten, int progressReportRowPeriod) throws IOException {
        LOG.debug((Object)"Writing optimized");
        offset += dy * lineStride;
        lineStride *= ddy;
        for (int y = dy; y < dh; y += ddy) {
            if (numRowsWritten % progressReportRowPeriod == 0) {
                if (this.abortRequested()) {
                    this.processWriteAborted();
                    return;
                }
                this.processImageProgress((float)numRowsWritten * 100.0f / (float)dh);
            }
            compressor.compress(data, offset, dw);
            ++numRowsWritten;
            offset += lineStride;
        }
    }

    private void writeRasterData(RenderedImage image, Rectangle sourceBounds, Dimension destSize, ImageWriteParam param, boolean interlaceFlag) throws IOException {
        int bitsPerPixel;
        int periodY;
        int periodX;
        int sourceXOffset = sourceBounds.x;
        int sourceYOffset = sourceBounds.y;
        int sourceWidth = sourceBounds.width;
        int sourceHeight = sourceBounds.height;
        int destWidth = destSize.width;
        int destHeight = destSize.height;
        if (param == null) {
            periodX = 1;
            periodY = 1;
        } else {
            periodX = param.getSourceXSubsampling();
            periodY = param.getSourceYSubsampling();
        }
        SampleModel sampleModel = image.getSampleModel();
        int initCodeSize = bitsPerPixel = sampleModel.getSampleSize()[0];
        if (initCodeSize == 1) {
            ++initCodeSize;
        }
        this.stream.write(initCodeSize);
        LZWCompressor compressor = new LZWCompressor(this.stream, initCodeSize, false);
        boolean isOptimizedCase = periodX == 1 && periodY == 1 && sampleModel instanceof ComponentSampleModel && image.getNumXTiles() == 1 && image.getNumYTiles() == 1 && image.getTile(0, 0).getDataBuffer() instanceof DataBufferByte;
        int numRowsWritten = 0;
        int progressReportRowPeriod = Math.max(destHeight / 20, 1);
        this.processImageStarted(this.imageIndex);
        if (interlaceFlag) {
            LOG.debug((Object)"Writing interlaced");
            if (isOptimizedCase) {
                Raster tile = image.getTile(0, 0);
                byte[] data = ((DataBufferByte)tile.getDataBuffer()).getData();
                ComponentSampleModel csm = (ComponentSampleModel)tile.getSampleModel();
                int offset = csm.getOffset(sourceXOffset, sourceYOffset, 0);
                int lineStride = csm.getScanlineStride();
                this.writeRowsOpt(data, offset, lineStride, compressor, 0, 8, destWidth, destHeight, numRowsWritten, progressReportRowPeriod);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRowsOpt(data, offset, lineStride, compressor, 4, 8, destWidth, destHeight, numRowsWritten += destHeight / 8, progressReportRowPeriod);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRowsOpt(data, offset, lineStride, compressor, 2, 4, destWidth, destHeight, numRowsWritten += (destHeight - 4) / 8, progressReportRowPeriod);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRowsOpt(data, offset, lineStride, compressor, 1, 2, destWidth, destHeight, numRowsWritten += (destHeight - 2) / 4, progressReportRowPeriod);
            } else {
                this.writeRows(image, compressor, sourceXOffset, periodX, sourceYOffset, 8 * periodY, sourceWidth, 0, 8, destWidth, destHeight, numRowsWritten, progressReportRowPeriod);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRows(image, compressor, sourceXOffset, periodX, sourceYOffset + 4 * periodY, 8 * periodY, sourceWidth, 4, 8, destWidth, destHeight, numRowsWritten += destHeight / 8, progressReportRowPeriod);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRows(image, compressor, sourceXOffset, periodX, sourceYOffset + 2 * periodY, 4 * periodY, sourceWidth, 2, 4, destWidth, destHeight, numRowsWritten += (destHeight - 4) / 8, progressReportRowPeriod);
                if (this.abortRequested()) {
                    return;
                }
                this.writeRows(image, compressor, sourceXOffset, periodX, sourceYOffset + periodY, 2 * periodY, sourceWidth, 1, 2, destWidth, destHeight, numRowsWritten += (destHeight - 2) / 4, progressReportRowPeriod);
            }
        } else {
            LOG.debug((Object)"Writing non-interlaced");
            if (isOptimizedCase) {
                Raster tile = image.getTile(0, 0);
                byte[] data = ((DataBufferByte)tile.getDataBuffer()).getData();
                ComponentSampleModel csm = (ComponentSampleModel)tile.getSampleModel();
                int offset = csm.getOffset(sourceXOffset, sourceYOffset, 0);
                int lineStride = csm.getScanlineStride();
                this.writeRowsOpt(data, offset, lineStride, compressor, 0, 1, destWidth, destHeight, numRowsWritten, progressReportRowPeriod);
            } else {
                this.writeRows(image, compressor, sourceXOffset, periodX, sourceYOffset, periodY, sourceWidth, 0, 1, destWidth, destHeight, numRowsWritten, progressReportRowPeriod);
            }
        }
        if (this.abortRequested()) {
            return;
        }
        this.processImageProgress(100.0f);
        compressor.flush();
        this.stream.write(0);
        this.processImageComplete();
    }

    private void writeHeader(String version, int logicalScreenWidth, int logicalScreenHeight, int colorResolution, int pixelAspectRatio, int backgroundColorIndex, boolean sortFlag, int bitsPerPixel, byte[] globalColorTable) throws IOException {
        try {
            this.stream.writeBytes("GIF" + version);
            this.stream.writeShort((short)logicalScreenWidth);
            this.stream.writeShort((short)logicalScreenHeight);
            int packedFields = globalColorTable != null ? 128 : 0;
            packedFields |= (colorResolution - 1 & 7) << 4;
            if (sortFlag) {
                packedFields |= 8;
            }
            this.stream.write(packedFields |= bitsPerPixel - 1);
            this.stream.write(backgroundColorIndex);
            this.stream.write(pixelAspectRatio);
            if (globalColorTable != null) {
                this.stream.write(globalColorTable);
            }
        }
        catch (IOException e) {
            throw new IIOException("I/O error writing header!", e);
        }
    }

    private void writeHeader(IIOMetadata streamMetadata, int bitsPerPixel) throws IOException {
        GIFWritableStreamMetadata sm;
        if (streamMetadata instanceof GIFWritableStreamMetadata) {
            sm = (GIFWritableStreamMetadata)streamMetadata;
        } else {
            sm = new GIFWritableStreamMetadata();
            Node root = streamMetadata.getAsTree(STREAM_METADATA_NAME);
            sm.setFromTree(STREAM_METADATA_NAME, root);
        }
        this.writeHeader(sm.version, sm.logicalScreenWidth, sm.logicalScreenHeight, sm.colorResolution, sm.pixelAspectRatio, sm.backgroundColorIndex, sm.sortFlag, bitsPerPixel, sm.globalColorTable);
    }

    private void writeGraphicControlExtension(int disposalMethod, boolean userInputFlag, boolean transparentColorFlag, int delayTime, int transparentColorIndex) throws IOException {
        try {
            this.stream.write(33);
            this.stream.write(249);
            this.stream.write(4);
            int packedFields = (disposalMethod & 3) << 2;
            if (userInputFlag) {
                packedFields |= 2;
            }
            if (transparentColorFlag) {
                packedFields |= 1;
            }
            this.stream.write(packedFields);
            this.stream.writeShort((short)delayTime);
            this.stream.write(transparentColorIndex);
            this.stream.write(0);
        }
        catch (IOException e) {
            throw new IIOException("I/O error writing Graphic Control Extension!", e);
        }
    }

    private void writeGraphicControlExtension(GIFWritableImageMetadata im) throws IOException {
        this.writeGraphicControlExtension(im.disposalMethod, im.userInputFlag, im.transparentColorFlag, im.delayTime, im.transparentColorIndex);
    }

    private void writeBlocks(byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            int len;
            for (int offset = 0; offset < data.length; offset += len) {
                len = Math.min(data.length - offset, 255);
                this.stream.write(len);
                this.stream.write(data, offset, len);
            }
        }
    }

    private void writePlainTextExtension(GIFWritableImageMetadata im) throws IOException {
        if (im.hasPlainTextExtension) {
            try {
                this.stream.write(33);
                this.stream.write(1);
                this.stream.write(12);
                this.stream.writeShort(im.textGridLeft);
                this.stream.writeShort(im.textGridTop);
                this.stream.writeShort(im.textGridWidth);
                this.stream.writeShort(im.textGridHeight);
                this.stream.write(im.characterCellWidth);
                this.stream.write(im.characterCellHeight);
                this.stream.write(im.textForegroundColor);
                this.stream.write(im.textBackgroundColor);
                this.writeBlocks(im.text);
                this.stream.write(0);
            }
            catch (IOException e) {
                throw new IIOException("I/O error writing Plain Text Extension!", e);
            }
        }
    }

    private void writeApplicationExtension(GIFWritableImageMetadata im) throws IOException {
        if (im.applicationIDs != null) {
            Iterator iterIDs = im.applicationIDs.iterator();
            Iterator iterCodes = im.authenticationCodes.iterator();
            Iterator iterData = im.applicationData.iterator();
            while (iterIDs.hasNext()) {
                try {
                    this.stream.write(33);
                    this.stream.write(255);
                    this.stream.write(11);
                    this.stream.write((byte[])iterIDs.next(), 0, 8);
                    this.stream.write((byte[])iterCodes.next(), 0, 3);
                    this.writeBlocks((byte[])iterData.next());
                    this.stream.write(0);
                }
                catch (IOException e) {
                    throw new IIOException("I/O error writing Application Extension!", e);
                }
            }
        }
    }

    private void writeCommentExtension(GIFWritableImageMetadata im) throws IOException {
        if (im.comments != null) {
            try {
                Iterator iter = im.comments.iterator();
                while (iter.hasNext()) {
                    this.stream.write(33);
                    this.stream.write(254);
                    this.writeBlocks((byte[])iter.next());
                    this.stream.write(0);
                }
            }
            catch (IOException e) {
                throw new IIOException("I/O error writing Comment Extension!", e);
            }
        }
    }

    private void writeImageDescriptor(int imageLeftPosition, int imageTopPosition, int imageWidth, int imageHeight, boolean interlaceFlag, boolean sortFlag, int bitsPerPixel, byte[] localColorTable) throws IOException {
        try {
            int packedFields;
            this.stream.write(44);
            this.stream.writeShort((short)imageLeftPosition);
            this.stream.writeShort((short)imageTopPosition);
            this.stream.writeShort((short)imageWidth);
            this.stream.writeShort((short)imageHeight);
            int n = packedFields = localColorTable != null ? 128 : 0;
            if (interlaceFlag) {
                packedFields |= 0x40;
            }
            if (sortFlag) {
                packedFields |= 8;
            }
            this.stream.write(packedFields |= bitsPerPixel - 1);
            if (localColorTable != null) {
                this.stream.write(localColorTable);
            }
        }
        catch (IOException e) {
            throw new IIOException("I/O error writing Image Descriptor!", e);
        }
    }

    private void writeImageDescriptor(GIFWritableImageMetadata imageMetadata, int bitsPerPixel) throws IOException {
        this.writeImageDescriptor(imageMetadata.imageLeftPosition, imageMetadata.imageTopPosition, imageMetadata.imageWidth, imageMetadata.imageHeight, imageMetadata.interlaceFlag, imageMetadata.sortFlag, bitsPerPixel, imageMetadata.localColorTable);
    }

    private void writeTrailer() throws IOException {
        this.stream.write(59);
    }
}

