/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.imageio.plugins.common;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public class BitFile {
    ImageOutputStream output;
    byte[] buffer;
    int index;
    int bitsLeft;
    boolean blocks = false;

    public BitFile(ImageOutputStream output, boolean blocks) {
        this.output = output;
        this.blocks = blocks;
        this.buffer = new byte[256];
        this.index = 0;
        this.bitsLeft = 8;
    }

    public void flush() throws IOException {
        int numBytes = this.index + (this.bitsLeft == 8 ? 0 : 1);
        if (numBytes > 0) {
            if (this.blocks) {
                this.output.write(numBytes);
            }
            this.output.write(this.buffer, 0, numBytes);
            this.buffer[0] = 0;
            this.index = 0;
            this.bitsLeft = 8;
        }
    }

    public void writeBits(int bits, int numbits) throws IOException {
        int bitsWritten = 0;
        int numBytes = 255;
        do {
            if (this.index == 254 && this.bitsLeft == 0 || this.index > 254) {
                if (this.blocks) {
                    this.output.write(numBytes);
                }
                this.output.write(this.buffer, 0, numBytes);
                this.buffer[0] = 0;
                this.index = 0;
                this.bitsLeft = 8;
            }
            if (numbits <= this.bitsLeft) {
                if (this.blocks) {
                    int n = this.index;
                    this.buffer[n] = (byte)(this.buffer[n] | (bits & (1 << numbits) - 1) << 8 - this.bitsLeft);
                    bitsWritten += numbits;
                    this.bitsLeft -= numbits;
                    numbits = 0;
                    continue;
                }
                int n = this.index;
                this.buffer[n] = (byte)(this.buffer[n] | (bits & (1 << numbits) - 1) << this.bitsLeft - numbits);
                bitsWritten += numbits;
                this.bitsLeft -= numbits;
                numbits = 0;
                continue;
            }
            if (this.blocks) {
                int n = this.index++;
                this.buffer[n] = (byte)(this.buffer[n] | (bits & (1 << this.bitsLeft) - 1) << 8 - this.bitsLeft);
                bitsWritten += this.bitsLeft;
                bits >>= this.bitsLeft;
                numbits -= this.bitsLeft;
                this.buffer[this.index] = 0;
                this.bitsLeft = 8;
                continue;
            }
            int topbits = bits >>> numbits - this.bitsLeft & (1 << this.bitsLeft) - 1;
            int n = this.index++;
            this.buffer[n] = (byte)(this.buffer[n] | topbits);
            numbits -= this.bitsLeft;
            bitsWritten += this.bitsLeft;
            this.buffer[this.index] = 0;
            this.bitsLeft = 8;
        } while (numbits != 0);
    }
}

