/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.imageio.plugins.common;

import java.io.PrintStream;

public class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    byte[] strChr = new byte[4096];
    short[] strNxt = new short[4096];
    short[] strHsh;
    short numStrings;
    int[] strLen = new int[4096];

    public LZWStringTable() {
        this.strHsh = new short[9973];
    }

    public int addCharString(short index, byte b) {
        if (this.numStrings >= 4096) {
            return 65535;
        }
        int hshidx = LZWStringTable.hash(index, b);
        while (this.strHsh[hshidx] != -1) {
            hshidx = (hshidx + 2039) % 9973;
        }
        this.strHsh[hshidx] = this.numStrings;
        this.strChr[this.numStrings] = b;
        if (index == -1) {
            this.strNxt[this.numStrings] = -1;
            this.strLen[this.numStrings] = 1;
        } else {
            this.strNxt[this.numStrings] = index;
            this.strLen[this.numStrings] = this.strLen[index] + 1;
        }
        short s = this.numStrings;
        this.numStrings = (short)(s + 1);
        return s;
    }

    public short findCharString(short index, byte b) {
        short nxtidx;
        if (index == -1) {
            return (short)(b & 0xFF);
        }
        int hshidx = LZWStringTable.hash(index, b);
        while ((nxtidx = this.strHsh[hshidx]) != -1) {
            if (this.strNxt[nxtidx] == index && this.strChr[nxtidx] == b) {
                return nxtidx;
            }
            hshidx = (hshidx + 2039) % 9973;
        }
        return -1;
    }

    public void clearTable(int codesize) {
        this.numStrings = 0;
        for (int q = 0; q < 9973; ++q) {
            this.strHsh[q] = -1;
        }
        int w = (1 << codesize) + 2;
        for (int q = 0; q < w; ++q) {
            this.addCharString((short)-1, (byte)q);
        }
    }

    public static int hash(short index, byte lastbyte) {
        return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
    }

    public int expandCode(byte[] buf, int offset, short code, int skipHead) {
        if (offset == -2 && skipHead == 1) {
            skipHead = 0;
        }
        if (code == -1 || skipHead == this.strLen[code]) {
            return 0;
        }
        int bufSpace = buf.length - offset;
        int codeLen = this.strLen[code] - skipHead;
        int expandLen = bufSpace > codeLen ? codeLen : bufSpace;
        int skipTail = codeLen - expandLen;
        int idx = offset + expandLen;
        while (idx > offset && code != -1) {
            if (--skipTail < 0) {
                buf[--idx] = this.strChr[code];
            }
            code = this.strNxt[code];
        }
        if (codeLen > expandLen) {
            return -expandLen;
        }
        return expandLen;
    }

    public void dump(PrintStream out) {
        for (int i = 258; i < this.numStrings; ++i) {
            out.println(" strNxt[" + i + "] = " + this.strNxt[i] + " strChr " + Integer.toHexString(this.strChr[i] & 0xFF) + " strLen " + Integer.toHexString(this.strLen[i]));
        }
    }
}

