/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.imageio.plugins.common;

import java.awt.Point;
import java.awt.Rectangle;

public class ReaderUtil {
    private static void computeUpdatedPixels(int sourceOffset, int sourceExtent, int destinationOffset, int dstMin, int dstMax, int sourceSubsampling, int passStart, int passExtent, int passPeriod, int[] vals, int offset) {
        boolean gotPixel = false;
        int firstDst = -1;
        int secondDst = -1;
        int lastDst = -1;
        for (int i = 0; i < passExtent; ++i) {
            int src = passStart + i * passPeriod;
            if (src < sourceOffset || (src - sourceOffset) % sourceSubsampling != 0) continue;
            if (src >= sourceOffset + sourceExtent) break;
            int dst = destinationOffset + (src - sourceOffset) / sourceSubsampling;
            if (dst < dstMin) continue;
            if (dst > dstMax) break;
            if (!gotPixel) {
                firstDst = dst;
                gotPixel = true;
            } else if (secondDst == -1) {
                secondDst = dst;
            }
            lastDst = dst;
        }
        vals[offset] = firstDst;
        vals[offset + 2] = !gotPixel ? 0 : lastDst - firstDst + 1;
        vals[offset + 4] = Math.max(secondDst - firstDst, 1);
    }

    public static int[] computeUpdatedPixels(Rectangle sourceRegion, Point destinationOffset, int dstMinX, int dstMinY, int dstMaxX, int dstMaxY, int sourceXSubsampling, int sourceYSubsampling, int passXStart, int passYStart, int passWidth, int passHeight, int passPeriodX, int passPeriodY) {
        int[] vals = new int[6];
        ReaderUtil.computeUpdatedPixels(sourceRegion.x, sourceRegion.width, destinationOffset.x, dstMinX, dstMaxX, sourceXSubsampling, passXStart, passWidth, passPeriodX, vals, 0);
        ReaderUtil.computeUpdatedPixels(sourceRegion.y, sourceRegion.height, destinationOffset.y, dstMinY, dstMaxY, sourceYSubsampling, passYStart, passHeight, passPeriodY, vals, 1);
        return vals;
    }
}

