/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.juzu.ajax;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyMap;
import juzu.Response;
import juzu.impl.common.JSON;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.request.RenderContext;
import org.exoplatform.commons.juzu.ajax.Ajax;

public class AjaxPlugin
extends ApplicationPlugin
implements RequestFilter {
    Map<String, Method> table;
    @Inject
    ApplicationDescriptor desc;

    public AjaxPlugin() {
        super("plf4-ajax");
    }

    public Descriptor init(ApplicationDescriptor application, JSON config) throws Exception {
        return config != null ? new Descriptor() : null;
    }

    @PostConstruct
    public void start() throws Exception {
        HashMap<String, Method> table = new HashMap<String, Method>();
        for (Method cm : this.desc.getControllers().getMethods()) {
            Ajax ajax = cm.getMethod().getAnnotation(Ajax.class);
            if (ajax == null) continue;
            table.put(cm.getName(), cm);
        }
        this.table = table;
    }

    public void invoke(final Request request) {
        Response response;
        request.invoke();
        if (request.getContext() instanceof RenderContext && (response = request.getResponse()) instanceof Response.Render) {
            Response.Render render = (Response.Render)response;
            PropertyMap properties = new PropertyMap(response.getProperties());
            final Streamable decorated = render.getStreamable();
            Streamable<Stream.Char> decorator = new Streamable<Stream.Char>(){

                public void send(Stream.Char stream) throws IOException {
                    stream.append((CharSequence)"<div class=\"jz\">\n");
                    for (Map.Entry<String, Method> entry : AjaxPlugin.this.table.entrySet()) {
                        String baseURL = request.getContext().createDispatch(entry.getValue()).toString();
                        stream.append((CharSequence)"<div data-method-id=\"");
                        stream.append((CharSequence)entry.getValue().getId());
                        stream.append((CharSequence)"\" data-url=\"");
                        stream.append((CharSequence)baseURL);
                        stream.append((CharSequence)"\"/>");
                        stream.append((CharSequence)"</div>");
                    }
                    decorated.send((Stream)stream);
                    stream.append((CharSequence)"</div>");
                }
            };
            request.setResponse((Response)new Response.Render(properties, (Streamable)decorator));
        }
    }
}

