/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.mfa.api.MfaSystemComponentPlugin;
import org.exoplatform.mfa.api.MfaSystemService;
import org.exoplatform.mfa.storage.MfaStorage;
import org.exoplatform.mfa.storage.dto.RevocationRequest;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;

public class MfaService {
    public static final String MFA_FEATURE = "mfa";
    private static final String MFA_SYSTEM_SETTING = "mfaSystem";
    private static final String MFA_PROTECTED_GROUPS = "protectedGroups";
    private String mfaSystem;
    private ExoFeatureService featureService;
    private SettingService settingService;
    private List<String> protectedNavigations = new ArrayList<String>();
    private List<String> protectedGroups;
    private MfaStorage mfaStorage;
    private ListenerService listenerService;
    private static final Log LOG = ExoLogger.getLogger(MfaService.class);
    private Map<String, MfaSystemComponentPlugin> mfaSystemServices;

    public MfaService(InitParams initParams, MfaStorage mfaStorage, ExoFeatureService featureService, SettingService settingService, ListenerService listenerService) {
        this.featureService = featureService;
        this.settingService = settingService;
        this.listenerService = listenerService;
        ValueParam protectedGroupNavigations = initParams.getValueParam("protectedGroupNavigations");
        if (protectedGroupNavigations != null) {
            this.protectedNavigations = Arrays.stream(protectedGroupNavigations.getValue().split(",")).filter(s -> !s.isEmpty()).map(s -> "/portal/g/" + s.replace("/", ":")).collect(Collectors.toList());
        }
        String protectedGroupsValue = "";
        protectedGroupsValue = settingService.get(Context.GLOBAL, Scope.GLOBAL, MFA_PROTECTED_GROUPS) != null && !settingService.get(Context.GLOBAL, Scope.GLOBAL, MFA_PROTECTED_GROUPS).getValue().toString().isEmpty() ? settingService.get(Context.GLOBAL, Scope.GLOBAL, MFA_PROTECTED_GROUPS).getValue().toString() : initParams.getValueParam(MFA_PROTECTED_GROUPS).getValue();
        this.protectedGroups = Arrays.stream(protectedGroupsValue.split(",")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.mfaSystemServices = new HashMap<String, MfaSystemComponentPlugin>();
        this.mfaSystem = settingService.get(Context.GLOBAL, Scope.GLOBAL, MFA_SYSTEM_SETTING) != null && !settingService.get(Context.GLOBAL, Scope.GLOBAL, MFA_SYSTEM_SETTING).getValue().toString().isEmpty() ? settingService.get(Context.GLOBAL, Scope.GLOBAL, MFA_SYSTEM_SETTING).getValue().toString() : initParams.getValueParam(MFA_SYSTEM_SETTING).getValue();
        this.mfaStorage = mfaStorage;
        this.mfaSystemServices = new HashMap<String, MfaSystemComponentPlugin>();
    }

    public MfaSystemService getMfaSystemService(String type) {
        return this.mfaSystemServices.get(type).getMfaSystemService();
    }

    public void addConnector(MfaSystemComponentPlugin mfaSystemComponentPlugin) {
        this.mfaSystemServices.put(mfaSystemComponentPlugin.getMfaSystemService().getType(), mfaSystemComponentPlugin);
    }

    public boolean isProtectedUri(String requestUri) {
        return this.protectedNavigations.stream().anyMatch(requestUri::contains);
    }

    public boolean currentUserIsInProtectedGroup(Identity identity) {
        return this.protectedGroups.stream().anyMatch(arg_0 -> ((Identity)identity).isMemberOf(arg_0));
    }

    public String getMfaSystem() {
        return this.mfaSystem;
    }

    public MfaSystemService getMfaSystemService() {
        return this.mfaSystemServices.get(this.mfaSystem).getMfaSystemService();
    }

    public boolean addRevocationRequest(String username, String mfaType) {
        if (!this.hasRevocationRequest(username, mfaType)) {
            RevocationRequest revocationRequest = new RevocationRequest();
            revocationRequest.setUser(username);
            revocationRequest.setType(mfaType);
            this.mfaStorage.createRevocationRequest(revocationRequest);
            try {
                this.listenerService.broadcast(new Event("mfa.listener.create.revocation.request", null, (Object)username));
            }
            catch (Exception e) {
                LOG.error((Object)"Error when broadcasting mfa revocation request event", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public boolean hasRevocationRequest(String username, String mfaType) {
        return this.mfaStorage.countByUsernameAndType(username, mfaType) > 0L;
    }

    public void deleteRevocationRequest(String username, String type) {
        this.mfaStorage.deleteRevocationRequest(username, type);
    }

    public List<RevocationRequest> getAllRevocationRequests() {
        return this.mfaStorage.findAll();
    }

    public RevocationRequest getRevocationRequestById(Long id) {
        return this.mfaStorage.findById(id);
    }

    public void confirmRevocationRequest(Long id) {
        RevocationRequest revocationRequest = this.mfaStorage.findById(id);
        String type = revocationRequest.getType();
        this.mfaSystemServices.get(type).getMfaSystemService().removeSecret(revocationRequest.getUser());
        this.mfaStorage.deleteById(id);
    }

    public void cancelRevocationRequest(Long id) {
        this.mfaStorage.deleteById(id);
    }

    public List<String> getAvailableMfaSystems() {
        return new ArrayList<String>(this.mfaSystemServices.keySet());
    }

    public void saveActiveFeature(String status) {
        this.featureService.saveActiveFeature(MFA_FEATURE, Boolean.parseBoolean(status));
    }

    public boolean setMfaSystem(String mfaSystem) {
        if (this.mfaSystemServices.containsKey(mfaSystem)) {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, MFA_SYSTEM_SETTING, new SettingValue((Object)mfaSystem));
            this.mfaSystem = mfaSystem;
            return true;
        }
        return false;
    }

    public boolean isMfaFeatureActivated() {
        return this.featureService.isActiveFeature(MFA_FEATURE);
    }

    public void saveProtectedGroups(String groups) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, MFA_PROTECTED_GROUPS, new SettingValue((Object)groups));
        this.protectedGroups = Arrays.asList(groups.split(","));
    }

    public List<String> getProtectedGroups() {
        return this.protectedGroups;
    }
}

