/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.impl.otp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.mfa.api.otp.OtpConnector;
import org.exoplatform.mfa.impl.otp.CodeGenerator;
import org.exoplatform.mfa.impl.otp.SecretGenerator;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExoOtpConnector
implements OtpConnector {
    private static final String OTP_SECRET = "otpSecret";
    private static final String OTP_SECRET_CHECKED = "otpSecretChecked";
    public static final String ISSUER_PARAM = "issuer";
    private int timePeriod = 30;
    private int secretLength = 64;
    private int codeDigits = 6;
    private String algorithm = "SHA1";
    private int timePeriodDiscrepancy = 1;
    private String issuer = "";
    private SettingService settingservice;
    private CodeGenerator codeGenerator;
    String name = "ExoOtpConnector";
    private static final Log LOGGER = ExoLogger.getExoLogger(ExoOtpConnector.class);

    public ExoOtpConnector(InitParams initParams, SettingService settingService, BrandingService brandingService) {
        this.settingservice = settingService;
        this.issuer = initParams.getValueParam(ISSUER_PARAM) != null && !initParams.getValueParam(ISSUER_PARAM).getValue().isBlank() ? initParams.getValueParam(ISSUER_PARAM).getValue() : brandingService.getCompanyName();
        if (initParams.getValueParam("timePeriod") != null) {
            this.timePeriod = Integer.parseInt(initParams.getValueParam("timePeriod").getValue());
        }
        if (initParams.getValueParam("secretLength") != null) {
            this.secretLength = Integer.parseInt(initParams.getValueParam("secretLength").getValue());
        }
        if (initParams.getValueParam("codeDigits") != null) {
            this.codeDigits = Integer.parseInt(initParams.getValueParam("codeDigits").getValue());
        }
        if (initParams.getValueParam("timePeriodDiscrepancy") != null) {
            this.timePeriodDiscrepancy = Integer.parseInt(initParams.getValueParam("timePeriodDiscrepancy").getValue());
        }
        if (initParams.getValueParam("algorithm") != null) {
            this.algorithm = initParams.getValueParam("algorithm").getValue();
        }
        this.codeGenerator = new CodeGenerator(this.codeDigits);
    }

    @Override
    public boolean isMfaInitializedForUser(String user) {
        return this.settingservice.get(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET) != null && this.settingservice.get(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET_CHECKED) != null && Boolean.valueOf(this.settingservice.get(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET_CHECKED).getValue().toString()) != false;
    }

    @Override
    public String generateSecret(String user) {
        SecretGenerator secretGenerator = new SecretGenerator(this.secretLength);
        String secret = secretGenerator.generate();
        this.settingservice.set(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET, new SettingValue((Object)secret));
        this.settingservice.set(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET_CHECKED, new SettingValue((Object)"false"));
        return secret;
    }

    @Override
    public void removeSecret(String user) {
        this.settingservice.remove(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET);
        this.settingservice.remove(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET_CHECKED);
    }

    @Override
    public String generateUrlFromSecret(String user, String secret) {
        return "otpauth://totp/" + this.uriEncode(user) + "?secret=" + this.uriEncode(secret) + "&issuer=" + this.uriEncode(this.issuer) + "&algorithm=" + this.uriEncode(this.algorithm) + "&digits=" + this.codeDigits + "&period=" + this.timePeriod;
    }

    @Override
    public boolean validateToken(String user, String code, Clock clock) {
        long time = Instant.now(clock).getEpochSecond();
        String secret = (String)this.settingservice.get(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET).getValue();
        long currentBucket = Math.floorDiv(time, this.timePeriod);
        boolean success = false;
        for (int i = -this.timePeriodDiscrepancy; i <= this.timePeriodDiscrepancy; ++i) {
            success = this.checkCode(secret, currentBucket + (long)i, code) || success;
        }
        if (success && !this.isMfaInitializedForUser(user)) {
            this.settingservice.set(new Context(Context.USER.getName(), user), Scope.APPLICATION, OTP_SECRET_CHECKED, new SettingValue((Object)"true"));
        }
        return success;
    }

    private boolean checkCode(String secret, long counter, String code) {
        try {
            String actualCode = this.codeGenerator.generate(secret, counter);
            return this.timeSafeStringComparison(actualCode, code);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean timeSafeStringComparison(String a, String b) {
        byte[] bBytes;
        byte[] aBytes = a.getBytes();
        if (aBytes.length != (bBytes = b.getBytes()).length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            result |= aBytes[i] ^ bBytes[i];
        }
        return result == 0;
    }

    private String uriEncode(String text) {
        if (text == null) {
            return "";
        }
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.toString()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Unable to encode {}", new Object[]{text});
            return "";
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

