/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mfa.rest.otp;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.exoplatform.mfa.api.otp.OtpService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/otp")
@Api(value="/otp")
public class OtpRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(OtpRestService.class);
    private OtpService otpService;

    public OtpRestService(OtpService otpService) {
        this.otpService = otpService;
    }

    @Path(value="/checkRegistration")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Check if user have activated his OTP", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response checkRegistration(@Context HttpServletRequest request) {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok().entity((Object)("{\"result\":\"" + this.otpService.isMfaInitializedForUser(userId) + "\"}")).build();
    }

    @Path(value="/generateSecret")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Generate New secret OTP for user", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response generateSecret(@Context HttpServletRequest request) {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.otpService.isMfaInitializedForUser(userId)) {
            String secret = this.otpService.generateSecret(userId);
            String urlFromSecret = this.otpService.generateUrlFromSecret(userId, secret);
            return Response.ok().entity((Object)("{\"secret\":\"" + secret + "\",\"url\":\"" + urlFromSecret + "\"}")).build();
        }
        return Response.ok().build();
    }

    @Path(value="/verify")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Verify OTP token", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response verifyToken(@Context HttpServletRequest request, @ApiParam(value="Token to verify", required=true) @QueryParam(value="token") String token) {
        String userId = null;
        try {
            userId = ConversationState.getCurrent().getIdentity().getUserId();
            boolean otpResult = this.otpService.validateToken(userId, token);
            request.getSession().setAttribute("mfaValidated", (Object)otpResult);
            return Response.ok().entity((Object)("{\"result\":\"" + otpResult + "\"}")).build();
        }
        catch (Exception e) {
            LOG.warn("Error when checking OTP token for user='{}', token='{}'", new Object[]{userId, token, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

