/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.search.es.client.ElasticClient;
import org.exoplatform.commons.search.es.client.ElasticClientException;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ElasticIndexingClient
extends ElasticClient {
    public static final String EMPTY_JSON = "{}";
    private static final Log LOG = ExoLogger.getExoLogger(ElasticIndexingClient.class);
    private static final String ES_INDEX_CLIENT_PROPERTY_NAME = "exo.es.index.server.url";
    private static final String ES_INDEX_CLIENT_PROPERTY_USERNAME = "exo.es.index.server.username";
    private static final String ES_INDEX_CLIENT_PROPERTY_PASSWORD = "exo.es.index.server.password";
    private ElasticIndexingAuditTrail auditTrail;

    public ElasticIndexingClient(ElasticIndexingAuditTrail auditTrail) {
        super(auditTrail);
        if (auditTrail == null) {
            throw new IllegalArgumentException("AuditTrail is null");
        }
        this.auditTrail = auditTrail;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_NAME))) {
            this.urlClient = PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_NAME);
            LOG.info("Using {} as Indexing URL", new Object[]{this.urlClient});
        } else {
            LOG.info((Object)"Using default as Indexing URL");
        }
    }

    public boolean sendCreateIndexRequest(String index, String settings) {
        String indexURL = this.urlClient + "/" + index;
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.info("Index {} already exists. Index creation requests will not be sent.", new Object[]{index});
            return false;
        }
        LOG.info("Index {} doesn't exist. Index creation requests will be sent.", new Object[]{index});
        long startTime = System.currentTimeMillis();
        ElasticResponse responseCreate = this.sendHttpPutRequest(indexURL, settings);
        this.auditTrail.audit("create_index", null, index, null, responseCreate.getStatusCode(), responseCreate.getMessage(), System.currentTimeMillis() - startTime);
        return true;
    }

    public void sendCreateTypeRequest(String index, String type, String mappings) {
        String url = this.urlClient + "/" + index + "/_mapping/" + type;
        if (!this.sendIsTypeExistsRequest(index, type)) {
            LOG.info("Mapping doesn't exist for type {}. Mapping creation requests will be sent.", new Object[]{type});
            long startTime = System.currentTimeMillis();
            ElasticResponse response = this.sendHttpPutRequest(url, mappings);
            this.auditTrail.audit("create_type", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
        } else {
            LOG.info("Mapping already exists for type {}. Mapping creation requests will not be sent.", new Object[]{type});
        }
    }

    public void sendDeleteAllDocsOfTypeRequest(String index, String type) {
        long startTime = System.currentTimeMillis();
        String request = this.getDeleteAllDocumentsRequestContent();
        ElasticResponse response = this.sendHttpPostRequest(this.urlClient + "/" + index + "/" + type + "/_delete_by_query?conflicts=proceed&wait_for_completion=true", request);
        this.auditTrail.audit("delete_type", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
    }

    public void sendCUDRequest(String bulkRequest) {
        long startTime = System.currentTimeMillis();
        ElasticResponse response = this.sendHttpPostRequest(this.urlClient + "/_bulk", bulkRequest);
        this.logBulkResponse(response.getMessage(), System.currentTimeMillis() - startTime);
    }

    public void sendCreateAttachmentPipelineRequest(String index, String type, String pipelineName, String processorMappings) {
        String url = this.urlClient + "/_ingest/pipeline/" + pipelineName;
        ElasticResponse responseExists = this.sendHttpGetRequest(url);
        if (responseExists.getStatusCode() == 200 || responseExists.getStatusCode() == 404 || responseExists.getStatusCode() == 400) {
            if (EMPTY_JSON.equals(responseExists.getMessage())) {
                LOG.info("Pipeline doesn't exist for type {}. Mapping creation requests will be sent.", new Object[]{type});
                long startTime = System.currentTimeMillis();
                ElasticResponse response = this.sendHttpPutRequest(url, processorMappings);
                this.auditTrail.audit("create_pipeline", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
            } else {
                LOG.info("Pipeline already exists for type {}. Pipeline creation requests will not be sent.", new Object[]{type});
            }
        } else {
            LOG.error("Error while creating pipeline: Unsupported HttpStatusCode {}. url={}", new Object[]{responseExists.getStatusCode(), url});
        }
    }

    public void sendCreateDocOnPipeline(String index, String type, String id, String pipelineName, String pipelineRequestOperation) {
        this.refreshIndex(index);
        String pipelineURL = this.urlClient + "/_ingest/pipeline/" + pipelineName;
        ElasticResponse responseExists = this.sendHttpGetRequest(pipelineURL);
        if (responseExists.getStatusCode() == 200) {
            long startTime = System.currentTimeMillis();
            String url = this.urlClient + "/" + index + "/" + type + "/" + id + "?pipeline=" + pipelineName;
            ElasticResponse response = this.sendHttpPutRequest(url, pipelineRequestOperation);
            this.auditTrail.audit("create_doc_pipeline", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
        } else {
            LOG.error("Error while creating attachment on pipeline '{}': Unsupported HttpStatusCode {}. url={}", new Object[]{pipelineName, responseExists.getStatusCode(), pipelineURL});
        }
    }

    public void sendCreateIndexAliasRequest(String index, String oldIndex, String indexAlias) {
        if (oldIndex == null) {
            LOG.info("Index alias '{}' will be created to refer the index '{}'", new Object[]{indexAlias, index});
        } else {
            LOG.info("Index alias '{}' will be created to refer the index {} instead of old index '{}'", new Object[]{indexAlias, index, oldIndex});
        }
        long startTime = System.currentTimeMillis();
        String aliasesURL = this.urlClient + "/_aliases";
        ElasticResponse responseUpdateIndex = this.sendHttpPostRequest(aliasesURL, this.getCreateAliasRequestContent(index, oldIndex, indexAlias));
        if (responseUpdateIndex.getStatusCode() != 200) {
            this.auditTrail.audit("create_index_alias", null, index, null, responseUpdateIndex.getStatusCode(), responseUpdateIndex.getMessage(), System.currentTimeMillis() - startTime);
            throw new ElasticClientException("Index alias " + indexAlias + " update from old index " + oldIndex + " to new index " + index + " error, http code = '" + responseUpdateIndex.getStatusCode() + "', message = '" + responseUpdateIndex.getMessage() + "'");
        }
        this.auditTrail.audit("create_index_alias", null, index, null, responseUpdateIndex.getStatusCode(), responseUpdateIndex.getMessage(), System.currentTimeMillis() - startTime);
    }

    public boolean sendIsTypeExistsRequest(String index, String type) {
        String url = this.urlClient + "/" + index + "/_mapping/" + type;
        ElasticResponse responseExists = this.sendHttpHeadRequest(url);
        if (responseExists.getStatusCode() == 200) {
            return true;
        }
        if (responseExists.getStatusCode() == 404) {
            return false;
        }
        LOG.error("Error while checking Type existence: Unsupported HttpStatusCode {}. url={}", new Object[]{responseExists.getStatusCode(), url});
        throw new ElasticClientException("Can't request ES to get index/type " + index + "/" + type + " existence status");
    }

    public Set<String> sendGetIndexAliasesRequest(String index) {
        String indexAliasURL = this.urlClient + "/" + index + "/_aliases/";
        ElasticResponse responseExists = this.sendHttpGetRequest(indexAliasURL);
        if (responseExists.getStatusCode() == 200) {
            Map json;
            String aliasesURL = this.urlClient + "/_aliases";
            ElasticResponse responseAliases = this.sendHttpGetRequest(indexAliasURL);
            if (responseAliases.getStatusCode() != 200) {
                throw new ElasticClientException("Can't get aliases from URL " + aliasesURL);
            }
            String jsonResponse = responseAliases.getMessage();
            JSONParser parser = new JSONParser();
            try {
                json = (Map)parser.parse(jsonResponse);
            }
            catch (ParseException e) {
                throw new ElasticClientException("Unable to parse JSON response: " + jsonResponse, e);
            }
            if (!json.containsKey(index)) {
                return Collections.emptySet();
            }
            JSONObject indexAliases = (JSONObject)((Map)json.get(index)).get("aliases");
            return indexAliases.keySet();
        }
        throw new ElasticClientException("Uknow response code was sent by ES: \\n\\t\\t code = " + responseExists.getStatusCode() + ", \\n\\t\\t message: " + responseExists.getMessage());
    }

    public long sendCountIndexObjectsRequest(String index) {
        this.refreshIndex(index);
        String indexCountObjectsURL = this.urlClient + "/" + index + "/_count?q=*";
        ElasticResponse mappingsResponse = this.sendHttpGetRequest(indexCountObjectsURL);
        if (mappingsResponse.getStatusCode() == 200) {
            Map json;
            String jsonResponse = mappingsResponse.getMessage();
            JSONParser parser = new JSONParser();
            try {
                json = (Map)parser.parse(jsonResponse);
            }
            catch (ParseException e) {
                throw new ElasticClientException("Unable to parse JSON response: " + jsonResponse, e);
            }
            if (!json.containsKey("count")) {
                throw new ElasticClientException("Unexpected content in JSON response from ES: " + jsonResponse);
            }
            return (Long)json.get("count");
        }
        throw new ElasticClientException("Uknow response code was sent by ES: \\n\\t\\t code = " + mappingsResponse.getStatusCode() + ", \\n\\t\\t message: " + mappingsResponse.getMessage());
    }

    public String sendGetESVersion() {
        ElasticResponse mappingsResponse = this.sendHttpGetRequest(this.urlClient);
        if (mappingsResponse.getStatusCode() == 200) {
            Map json;
            String jsonResponse = mappingsResponse.getMessage();
            JSONParser parser = new JSONParser();
            try {
                json = (Map)parser.parse(jsonResponse);
            }
            catch (ParseException e) {
                throw new ElasticClientException("Unable to parse JSON response: " + jsonResponse, e);
            }
            if (!json.containsKey("version")) {
                throw new ElasticClientException("Unexpected content in JSON response from ES: " + jsonResponse);
            }
            return (String)((JSONObject)json.get("version")).get((Object)"number");
        }
        throw new ElasticClientException("Uknow response code was sent by ES: \\n\\t\\t code = " + mappingsResponse.getStatusCode() + ", \\n\\t\\t message: " + mappingsResponse.getMessage());
    }

    public void sendDeleteIndexRequest(String index) {
        long startTime = System.currentTimeMillis();
        ElasticResponse response = this.sendHttpDeleteRequest(this.urlClient + "/" + index);
        this.auditTrail.audit("delete_type", null, index, null, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
        if (response.getStatusCode() != 200) {
            throw new ElasticClientException("Can't delete index " + index + ", reqponse code = " + response.getStatusCode() + ", message = " + response.getMessage());
        }
    }

    public void sendReindexTypeRequest(String index, String oldIndex, String type, String pipeline) {
        long startTime = System.currentTimeMillis();
        String request = this.getReindexRequestContent(index, oldIndex, type, pipeline);
        ElasticResponse response = this.sendHttpPostRequest(this.urlClient + "/_reindex", request);
        this.auditTrail.audit("reindex_type", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
        if (response.getStatusCode() != 200) {
            throw new ElasticClientException("Can't reindex index " + index + ", type = " + type + ", reqponse code = " + response.getStatusCode() + ", message = " + response.getMessage());
        }
    }

    public boolean sendIsIndexExistsRequest(String index) {
        String indexURL = this.urlClient + "/" + index;
        ElasticResponse responseExists = this.sendHttpGetRequest(indexURL);
        if (responseExists.getStatusCode() == 200) {
            return true;
        }
        if (responseExists.getStatusCode() == 404 || responseExists.getStatusCode() == 400) {
            return false;
        }
        throw new ElasticClientException("Can't get index '" + index + "' status");
    }

    private void refreshIndex(String index) {
        String indexRefreshURL = this.urlClient + "/" + index + "/_refresh";
        this.sendHttpPostRequest(indexRefreshURL, null);
    }

    private void logBulkResponse(String response, long executionTime) {
        try {
            Object parsedResponse = JSONValue.parseWithException((String)response);
            if (!(parsedResponse instanceof JSONObject)) {
                LOG.error("Unable to parse Bulk response: response is not a JSON. response={}", new Object[]{response});
                throw new ElasticClientException("Unable to parse Bulk response: response is not a JSON.");
            }
            Object items = ((JSONObject)parsedResponse).get((Object)"items");
            if (items != null) {
                if (!(items instanceof JSONArray)) {
                    LOG.error("Unable to parse Bulk response: items is not a JSONArray. items={}", new Object[]{items});
                    throw new ElasticClientException("Unable to parse Bulk response: items is not a JSONArray.");
                }
                for (Object item : ((JSONArray)items).toArray()) {
                    if (!(item instanceof JSONObject)) {
                        LOG.error("Unable to parse Bulk response: item is not a JSONObject. item={}", new Object[]{item});
                        throw new ElasticClientException("Unable to parse Bulk response: item is not a JSONObject.");
                    }
                    this.logBulkResponseItem((JSONObject)item, executionTime);
                }
            }
        }
        catch (ParseException e) {
            throw new ElasticClientException("Unable to parse Bulk response", e);
        }
    }

    private void logBulkResponseItem(JSONObject item, long executionTime) {
        for (Map.Entry operation : item.entrySet()) {
            Integer httpStatusCode;
            String operationName;
            String string = operationName = operation.getKey() == null ? null : (String)operation.getKey();
            if (operation.getValue() == null) continue;
            JSONObject operationDetails = (JSONObject)operation.getValue();
            String index = operationDetails.get((Object)"_index") == null ? null : (String)operationDetails.get((Object)"_index");
            String type = operationDetails.get((Object)"_type") == null ? null : (String)operationDetails.get((Object)"_type");
            String id = operationDetails.get((Object)"_id") == null ? null : (String)operationDetails.get((Object)"_id");
            Long status = operationDetails.get((Object)"status") == null ? null : (Long)operationDetails.get((Object)"status");
            String error = operationDetails.get((Object)"error") == null ? null : (String)((JSONObject)operationDetails.get((Object)"error")).get((Object)"reason");
            Integer n = httpStatusCode = status == null ? null : Integer.valueOf(status.intValue());
            if (ElasticIndexingAuditTrail.isError(httpStatusCode)) {
                this.auditTrail.logRejectedDocumentBulkOperation(operationName, id, index, type, httpStatusCode, error, executionTime);
                continue;
            }
            if (!this.auditTrail.isFullLogEnabled()) continue;
            this.auditTrail.logAcceptedBulkOperation(operationName, id, index, type, httpStatusCode, error, executionTime);
        }
    }

    private String getDeleteAllDocumentsRequestContent() {
        JSONObject deleteAllRequest = new JSONObject();
        JSONObject deleteQueryRequest = new JSONObject();
        deleteQueryRequest.put((Object)"match_all", (Object)new JSONObject());
        deleteAllRequest.put((Object)"query", (Object)deleteQueryRequest);
        String request = deleteAllRequest.toJSONString();
        LOG.debug("Delete All request to ES: \n {}", new Object[]{request});
        return request;
    }

    private String getReindexRequestContent(String index, String oldIndex, String type, String pipeline) {
        JSONObject reindexRequest = new JSONObject();
        JSONObject reindexSourceRequest = new JSONObject();
        reindexRequest.put((Object)"source", (Object)reindexSourceRequest);
        reindexSourceRequest.put((Object)"index", (Object)oldIndex);
        reindexSourceRequest.put((Object)"type", (Object)type);
        JSONObject reindexDestRequest = new JSONObject();
        reindexRequest.put((Object)"dest", (Object)reindexDestRequest);
        reindexDestRequest.put((Object)"index", (Object)index);
        if (pipeline != null) {
            reindexDestRequest.put((Object)"pipeline", (Object)pipeline);
        }
        String request = reindexRequest.toJSONString();
        LOG.debug("Reindex Request from old index {} type {} to new index : \n {}", new Object[]{oldIndex, type, index, request});
        return request;
    }

    private String getCreateAliasRequestContent(String index, String oldIndex, String alias) {
        JSONObject updateAliasRequest = new JSONObject();
        JSONArray updateAliasActionsRequest = new JSONArray();
        updateAliasRequest.put((Object)"actions", (Object)updateAliasActionsRequest);
        if (oldIndex != null) {
            JSONObject updateAliasActionRemoveRequest = new JSONObject();
            JSONObject updateAliasActionRemoveOptionsRequest = new JSONObject();
            updateAliasActionRemoveRequest.put((Object)"remove", (Object)updateAliasActionRemoveOptionsRequest);
            updateAliasActionRemoveOptionsRequest.put((Object)"alias", (Object)alias);
            updateAliasActionRemoveOptionsRequest.put((Object)"index", (Object)oldIndex);
            updateAliasActionsRequest.add((Object)updateAliasActionRemoveRequest);
        }
        JSONObject updateAliasActionAddRequest = new JSONObject();
        JSONObject updateAliasActionAddOptionsRequest = new JSONObject();
        updateAliasActionAddRequest.put((Object)"add", (Object)updateAliasActionAddOptionsRequest);
        updateAliasActionAddOptionsRequest.put((Object)"alias", (Object)alias);
        updateAliasActionAddOptionsRequest.put((Object)"index", (Object)index);
        updateAliasActionsRequest.add((Object)updateAliasActionAddRequest);
        String request = updateAliasRequest.toJSONString();
        LOG.debug("Create Index alias ES: \n {}", new Object[]{request});
        return request;
    }

    @Override
    protected String getEsUsernameProperty() {
        return PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_USERNAME);
    }

    @Override
    protected String getEsPasswordProperty() {
        return PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_PASSWORD);
    }

    @Override
    protected HttpClientConnectionManager getClientConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }
}

