/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class IndexingOperationProcessor {
    private static final Log LOG = ExoLogger.getExoLogger(IndexingOperationProcessor.class);
    private static final ThreadLocal<String> CURRENT_TENANT_NAME = new ThreadLocal();
    private Map<String, IndexingServiceConnector> connectors = new HashMap<String, IndexingServiceConnector>();

    public static String getCurrentTenantName() {
        return CURRENT_TENANT_NAME.get();
    }

    public static void setCurrentTenantName(String tenantName) {
        CURRENT_TENANT_NAME.set(tenantName);
    }

    public void addConnector(IndexingServiceConnector indexingServiceConnector) {
        this.addConnector(indexingServiceConnector, false);
    }

    public void addConnector(IndexingServiceConnector indexingServiceConnector, Boolean override) {
        if (this.connectors.containsKey(indexingServiceConnector.getType()) && override.equals(false)) {
            LOG.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{indexingServiceConnector.getType()});
        } else {
            this.connectors.put(indexingServiceConnector.getType(), indexingServiceConnector);
            LOG.info("An Indexing Connector has been added: {}", new Object[]{indexingServiceConnector.getType()});
        }
    }

    public Map<String, IndexingServiceConnector> getConnectors() {
        return this.connectors;
    }

    public abstract void process();

    public abstract void interrupt();
}

