/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.search.dao.IndexingOperationDAO;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.domain.IndexingOperation;
import org.exoplatform.commons.search.domain.OperationType;
import org.exoplatform.commons.search.es.client.ElasticContentRequestBuilder;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticIndexingClient;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.commons.search.index.impl.ElasticIndexingOperationProcessor;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ElasticOperationProcessorTest {
    private ElasticIndexingOperationProcessor elasticIndexingOperationProcessor;
    @Mock
    private IndexingOperationDAO indexingOperationDAO;
    @Mock
    private ElasticIndexingAuditTrail auditTrail;
    @Mock
    private ElasticIndexingClient elasticIndexingClient;
    @Mock
    private ElasticIndexingServiceConnector elasticIndexingServiceConnector;
    @Mock
    private ElasticContentRequestBuilder elasticContentRequestBuilder;
    private EntityManagerService entityManagerService;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        PortalContainer.getInstance();
        this.entityManagerService = new EntityManagerService();
        this.entityManagerService.startRequest(null);
        InitParams initParams = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("es.version");
        param.setValue("Test version");
        initParams.addParameter((Parameter)param);
        this.elasticIndexingOperationProcessor = new ElasticIndexingOperationProcessor(this.indexingOperationDAO, this.elasticIndexingClient, this.elasticContentRequestBuilder, this.auditTrail, this.entityManagerService, initParams);
        this.initElasticServiceConnector();
        this.initElasticContentRequestBuilder();
        this.elasticIndexingOperationProcessor.setInitialized(true);
    }

    private void initElasticServiceConnector() {
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getReplicas()).thenReturn((Object)1);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getShards()).thenReturn((Object)5);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.getConnectorName()).thenReturn((Object)"post");
        Mockito.when((Object)this.elasticIndexingServiceConnector.getMapping()).thenReturn((Object)"anyMapping");
    }

    private void initElasticContentRequestBuilder() {
        Mockito.when((Object)this.elasticContentRequestBuilder.getCreateIndexRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector))).thenReturn((Object)"SomeIndexSettings");
        Mockito.when((Object)this.elasticContentRequestBuilder.getCreateDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector), Mockito.anyString())).thenReturn((Object)"{ \"workspace\": \"collaboration\", \"title\": \"doc1.pdf\", \"file\": \"xxxx\"}");
        Mockito.when((Object)this.elasticContentRequestBuilder.getUpdateDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector), Mockito.anyString())).thenReturn((Object)"{ \"workspace\": \"collaboration\", \"title\": \"doc1.pdf\", \"file\": \"xxxx\"}");
        Mockito.when((Object)this.elasticContentRequestBuilder.getDeleteDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector), Mockito.anyString())).thenReturn((Object)"{\"delete\":{\"_index\":\"file_alias\",\"_type\":\"file\",\"_id\":\"xxxx\"}}\n");
    }

    @After
    public void clean() {
        this.elasticIndexingOperationProcessor.getConnectors().clear();
        this.entityManagerService.endRequest(null);
    }

    @Test
    public void addConnector_ifNewConnector_connectorAdded() {
        Assert.assertEquals((long)0L, (long)this.elasticIndexingOperationProcessor.getConnectors().size());
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        Assert.assertEquals((long)1L, (long)this.elasticIndexingOperationProcessor.getConnectors().size());
    }

    @Test
    public void addConnector_ifConnectorAlreadyExist_connectorNotAdded() {
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        Assert.assertEquals((long)1L, (long)this.elasticIndexingOperationProcessor.getConnectors().size());
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        Assert.assertEquals((long)1L, (long)this.elasticIndexingOperationProcessor.getConnectors().size());
    }

    @Test
    public void addConnector_ifConnectorAlreadyExist_initIndexingQueueNotCreated() {
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation indexingOperation = new IndexingOperation(null, "post", OperationType.INIT);
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        ((IndexingOperationDAO)Mockito.verify((Object)this.indexingOperationDAO, (VerificationMode)Mockito.times((int)0))).create((Object)indexingOperation);
    }

    @Test
    public void process_ifAllOperationsInQueue_requestShouldBeSentInAnExpectedOrder() throws ParseException {
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation create = new IndexingOperation("1", "post", OperationType.CREATE);
        create.setId(Long.valueOf(4L));
        IndexingOperation delete = new IndexingOperation("1", "post", OperationType.DELETE);
        delete.setId(Long.valueOf(5L));
        IndexingOperation update = new IndexingOperation("1", "post", OperationType.UPDATE);
        update.setId(Long.valueOf(2L));
        IndexingOperation init = new IndexingOperation(null, "post", OperationType.INIT);
        init.setId(Long.valueOf(3L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(delete);
        indexingOperations.add(update);
        indexingOperations.add(init);
        Document document = new Document("1", new Date());
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("1")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        InOrder orderClient = Mockito.inOrder((Object[])new Object[]{this.elasticIndexingClient});
        String createIndexRequestContent = this.elasticContentRequestBuilder.getCreateIndexRequestContent(this.elasticIndexingServiceConnector);
        ((ElasticIndexingClient)orderClient.verify((Object)this.elasticIndexingClient)).sendCreateIndexRequest(this.elasticIndexingServiceConnector.getIndexAlias(), createIndexRequestContent, this.elasticIndexingServiceConnector.getMapping());
        ((ElasticIndexingClient)orderClient.verify((Object)this.elasticIndexingClient)).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    @Test
    public void process_ifAllOperationsInQueue_requestShouldBeCreatedInAnExpectedOrder() throws ParseException {
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        this.elasticIndexingOperationProcessor.getConnectors().put("post1", this.elasticIndexingServiceConnector);
        this.elasticIndexingOperationProcessor.getConnectors().put("post2", this.elasticIndexingServiceConnector);
        this.elasticIndexingOperationProcessor.getConnectors().put("post3", this.elasticIndexingServiceConnector);
        IndexingOperation init = new IndexingOperation(null, "post", OperationType.INIT);
        init.setId(Long.valueOf(4L));
        IndexingOperation delete = new IndexingOperation("1", "post1", OperationType.DELETE);
        delete.setId(Long.valueOf(2L));
        IndexingOperation create = new IndexingOperation("2", "post2", OperationType.CREATE);
        create.setId(Long.valueOf(1L));
        IndexingOperation update = new IndexingOperation("3", "post3", OperationType.UPDATE);
        update.setId(Long.valueOf(3L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(delete);
        indexingOperations.add(update);
        indexingOperations.add(init);
        Document document = new Document("1", new Date());
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("2")).thenReturn((Object)document);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("3")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        InOrder orderRequestBuilder = Mockito.inOrder((Object[])new Object[]{this.elasticContentRequestBuilder});
        ((ElasticContentRequestBuilder)orderRequestBuilder.verify((Object)this.elasticContentRequestBuilder)).getCreateIndexRequestContent(this.elasticIndexingServiceConnector);
        ((ElasticContentRequestBuilder)orderRequestBuilder.verify((Object)this.elasticContentRequestBuilder)).getDeleteDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.any(ElasticIndexingServiceConnector.class), Mockito.anyString());
        ((ElasticContentRequestBuilder)orderRequestBuilder.verify((Object)this.elasticContentRequestBuilder)).getCreateDocumentRequestContent(this.elasticIndexingServiceConnector, "2");
        ((ElasticContentRequestBuilder)orderRequestBuilder.verify((Object)this.elasticContentRequestBuilder)).getUpdateDocumentRequestContent(this.elasticIndexingServiceConnector, "3");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticContentRequestBuilder});
    }

    @Test
    public void process_ifAllOperationsInQueue_requestShouldContinueOnException() throws ParseException {
        this.elasticIndexingOperationProcessor.getConnectors().put("post1", this.elasticIndexingServiceConnector);
        this.elasticIndexingOperationProcessor.getConnectors().put("post2", this.elasticIndexingServiceConnector);
        this.elasticIndexingOperationProcessor.getConnectors().put("post3", this.elasticIndexingServiceConnector);
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        IndexingOperation delete = new IndexingOperation("1", "post1", OperationType.DELETE);
        delete.setId(Long.valueOf(2L));
        indexingOperations.add(delete);
        IndexingOperation create = new IndexingOperation("2", "post2", OperationType.CREATE);
        create.setId(Long.valueOf(1L));
        indexingOperations.add(create);
        IndexingOperation update = new IndexingOperation("3", "post3", OperationType.UPDATE);
        update.setId(Long.valueOf(3L));
        indexingOperations.add(update);
        ((ElasticContentRequestBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fake error")}).when((Object)this.elasticContentRequestBuilder)).getDeleteDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        this.elasticIndexingOperationProcessor.process();
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder)).getDeleteDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.any(ElasticIndexingServiceConnector.class), (String)Mockito.eq((Object)"1"));
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder)).getCreateDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.any(ElasticIndexingServiceConnector.class), (String)Mockito.eq((Object)"2"));
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder)).getUpdateDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.any(ElasticIndexingServiceConnector.class), (String)Mockito.eq((Object)"3"));
    }

    @Test
    public void process_ifDeleteOperation_allOldestCreateOperationsWithSameEntityIdStillInQueueShouldBeCanceled() throws ParseException {
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation delete = new IndexingOperation("1", "post", OperationType.DELETE);
        delete.setId(Long.valueOf(2L));
        IndexingOperation create = new IndexingOperation("1", "post", OperationType.CREATE);
        create.setId(Long.valueOf(1L));
        IndexingOperation update = new IndexingOperation("1", "post", OperationType.UPDATE);
        update.setId(Long.valueOf(3L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(delete);
        indexingOperations.add(update);
        Document document = new Document("1", new Date());
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("1")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.elasticIndexingClient});
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder, (VerificationMode)Mockito.times((int)1))).getDeleteDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticContentRequestBuilder});
        ((ElasticIndexingClient)order.verify((Object)this.elasticIndexingClient, Mockito.times((int)1))).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    @Test
    public void process_ifCreateOperation_allOldestAndNewestUpdateOperationsWithSameEntityIdStillInQueueShouldBeCanceled() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation create = new IndexingOperation("1", "post", OperationType.CREATE);
        create.setId(Long.valueOf(1L));
        IndexingOperation oldUpdate = new IndexingOperation("1", "post", OperationType.UPDATE);
        oldUpdate.setId(Long.valueOf(2L));
        IndexingOperation newUpdate = new IndexingOperation("1", "post", OperationType.UPDATE);
        newUpdate.setId(Long.valueOf(3L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(oldUpdate);
        indexingOperations.add(newUpdate);
        Document document = new Document("1", sdf.parse("19/01/1989"));
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("1")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.elasticIndexingClient});
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder, (VerificationMode)Mockito.times((int)1))).getCreateDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticContentRequestBuilder});
        ((ElasticIndexingClient)order.verify((Object)this.elasticIndexingClient, Mockito.times((int)1))).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    @Test
    public void process_ifDeleteAllOperation_allNewestCreateDeleteOperationsStillInQueueShouldBeProcessed() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation create = new IndexingOperation("1", "post", OperationType.CREATE);
        create.setId(Long.valueOf(3L));
        IndexingOperation delete = new IndexingOperation("1", "post", OperationType.DELETE);
        delete.setId(Long.valueOf(2L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(delete);
        Document document = new Document("1", sdf.parse("19/01/1989"));
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        InOrder orderClient = Mockito.inOrder((Object[])new Object[]{this.elasticIndexingClient});
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder, (VerificationMode)Mockito.times((int)1))).getCreateDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder, (VerificationMode)Mockito.times((int)1))).getDeleteDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        ((ElasticIndexingClient)orderClient.verify((Object)this.elasticIndexingClient, Mockito.times((int)1))).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    @Test
    public void process_ifDeleteOperation_allNewestCreateOperationsStillInQueueShouldBeProcessed() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation delete = new IndexingOperation("1", "post", OperationType.DELETE);
        delete.setId(Long.valueOf(1L));
        IndexingOperation create = new IndexingOperation("1", "post", OperationType.CREATE);
        create.setId(Long.valueOf(2L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(delete);
        Document document = new Document("1", sdf.parse("19/01/1989"));
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.elasticContentRequestBuilder});
        ((ElasticContentRequestBuilder)order.verify((Object)this.elasticContentRequestBuilder, Mockito.times((int)1))).getDeleteDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        ((ElasticContentRequestBuilder)order.verify((Object)this.elasticContentRequestBuilder, Mockito.times((int)1))).getCreateDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticContentRequestBuilder});
        ((ElasticIndexingClient)Mockito.verify((Object)this.elasticIndexingClient, (VerificationMode)Mockito.times((int)1))).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    public void process_ifDeleteOperation_allNewestUpdateOperationsWithSameEntityIdStillInQueueShouldBeCanceled() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation delete = new IndexingOperation("1", "post", OperationType.DELETE);
        delete.setId(Long.valueOf(1L));
        IndexingOperation update = new IndexingOperation("1", "post", OperationType.UPDATE);
        update.setId(Long.valueOf(2L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(update);
        indexingOperations.add(delete);
        Document document = new Document("1", sdf.parse("19/01/1989"));
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("1")).thenReturn((Object)document);
        this.elasticIndexingOperationProcessor.process();
        ((ElasticContentRequestBuilder)Mockito.verify((Object)this.elasticContentRequestBuilder, (VerificationMode)Mockito.times((int)1))).getDeleteDocumentRequestContent(this.elasticIndexingServiceConnector, "1");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticContentRequestBuilder});
        ((ElasticIndexingClient)Mockito.verify((Object)this.elasticIndexingClient, (VerificationMode)Mockito.times((int)1))).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    @Test
    public void process_ifBulkRequestReachedSizeLimit_requestIsSent() throws ParseException {
        this.elasticIndexingOperationProcessor.setRequestSizeLimit(Integer.valueOf(1));
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation create1 = new IndexingOperation("1", "post", OperationType.CREATE);
        create1.setId(Long.valueOf(1L));
        IndexingOperation create2 = new IndexingOperation("2", "post", OperationType.CREATE);
        create2.setId(Long.valueOf(2L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create1);
        indexingOperations.add(create2);
        Document document1 = new Document("1", sdf.parse("19/01/1989"));
        Document document2 = new Document("2", sdf.parse("19/01/1989"));
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document1);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("2")).thenReturn((Object)document2);
        this.elasticIndexingOperationProcessor.process();
        ((ElasticIndexingClient)Mockito.verify((Object)this.elasticIndexingClient, (VerificationMode)Mockito.times((int)2))).sendCUDRequest(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.elasticIndexingClient});
    }

    @Test
    public void process_ifAllOperationsInQueue_requestShouldNotBeSentIfDocumentsAreNull() throws ParseException {
        this.elasticIndexingOperationProcessor.addConnector((IndexingServiceConnector)this.elasticIndexingServiceConnector);
        IndexingOperation create = new IndexingOperation("1", "post", OperationType.CREATE);
        create.setId(Long.valueOf(4L));
        IndexingOperation delete = new IndexingOperation("1", "post", OperationType.DELETE);
        delete.setId(Long.valueOf(5L));
        IndexingOperation update = new IndexingOperation("1", "post", OperationType.UPDATE);
        update.setId(Long.valueOf(2L));
        IndexingOperation init = new IndexingOperation(null, "post", OperationType.INIT);
        init.setId(Long.valueOf(3L));
        ArrayList<IndexingOperation> indexingOperations = new ArrayList<IndexingOperation>();
        indexingOperations.add(create);
        indexingOperations.add(delete);
        indexingOperations.add(update);
        indexingOperations.add(init);
        Document document = new Document("1", new Date());
        Mockito.when((Object)this.indexingOperationDAO.findAllFirst(Integer.valueOf(Mockito.anyInt()))).thenReturn(indexingOperations);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.create("1")).thenReturn((Object)document);
        Mockito.lenient().when((Object)this.elasticIndexingServiceConnector.update("1")).thenReturn((Object)document);
        Mockito.lenient().when((Object)this.elasticContentRequestBuilder.getCreateDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector), Mockito.anyString())).thenReturn(null);
        Mockito.lenient().when((Object)this.elasticContentRequestBuilder.getUpdateDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector), Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)this.elasticContentRequestBuilder.getDeleteDocumentRequestContent((ElasticIndexingServiceConnector)Mockito.eq((Object)this.elasticIndexingServiceConnector), Mockito.anyString())).thenReturn(null);
        this.elasticIndexingOperationProcessor.process();
        ((ElasticIndexingClient)Mockito.verify((Object)this.elasticIndexingClient, (VerificationMode)Mockito.never())).sendCUDRequest(Mockito.anyString());
    }
}

