/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.search.es.client.ElasticClientAuthenticationException;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticIndexingClient;
import org.exoplatform.commons.utils.PropertyManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ElasticIndexingClientTest {
    private ElasticIndexingClient elasticIndexingClient;
    @Mock
    private HttpClient httpClient;
    @Mock
    private ElasticIndexingAuditTrail auditTrail;
    @Captor
    private ArgumentCaptor<HttpPut> httpPutRequestCaptor;
    @Captor
    private ArgumentCaptor<HttpPost> httpPostRequestCaptor;
    @Captor
    private ArgumentCaptor<HttpDelete> httpDeleteRequestCaptor;
    @Captor
    private ArgumentCaptor<HttpGet> httpGetRequestCaptor;

    @Before
    public void initMock() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        PropertyManager.setProperty((String)"exo.es.index.server.url", (String)"http://127.0.0.1:9200");
        this.elasticIndexingClient = new ElasticIndexingClient(this.auditTrail);
        this.elasticIndexingClient.client = this.httpClient;
        this.elasticIndexingClient.resetMaxConnections();
    }

    @Test
    public void sendCreateIndexRequest_IfCreateNewIndex_requestShouldBeSentToElastic() throws IOException {
        this.initClientMock(404, "Not Found", 200, "Success");
        this.elasticIndexingClient.sendCreateIndexRequest("index", "fakeSettings", "fakeMappings");
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)Mockito.any(HttpRequestBase.class));
    }

    @Test
    public void sendCUDRequest_IfCUDOperation_bulkRequestShouldBeSentToElastic() throws IOException {
        String response = "{\"took\":15,\"errors\":true,\"items\":[{\"index\":{\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_version\":3,\"status\":200}}]}";
        this.initClientMock(999, "", 200, response);
        this.elasticIndexingClient.sendCUDRequest("FakeBulkRequest");
        ((HttpClient)Mockito.verify((Object)this.httpClient)).execute((HttpUriRequest)this.httpPostRequestCaptor.capture());
        Assert.assertEquals((Object)"http://127.0.0.1:9200/_bulk", (Object)((HttpPost)this.httpPostRequestCaptor.getValue()).getURI().toString());
        Assert.assertEquals((Object)"FakeBulkRequest", (Object)IOUtils.toString((InputStream)((HttpPost)this.httpPostRequestCaptor.getValue()).getEntity().getContent()));
    }

    @Test
    public void sendBulkRequest_forEveryDocument_callAuditTrail() throws IOException {
        String response = "{\"took\":15,\"errors\":true,\"items\":[{\"index\":{\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_version\":3,\"status\":200}},{\"delete\":{\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"2\",\"_version\":1,\"status\":404,\"found\":false}},{\"create\":{\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"3\",\"status\":409,\"error\":{\"reason\":\"DocumentAlreadyExistsException[[test][4] [type1][3]: document already exists]\"}}},{\"update\":{\"_index\":\"index1\",\"_type\":\"type1\",\"_id\":\"1\",\"status\":404,\"error\":{\"reason\":\"DocumentMissingException[[index1][-1] [type1][1]: document missing]\"}}}]}";
        this.initClientMock(999, "", 200, response);
        Mockito.when((Object)this.auditTrail.isFullLogEnabled()).thenReturn((Object)true);
        this.elasticIndexingClient.sendCUDRequest("myBulk");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).isFullLogEnabled();
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logAcceptedBulkOperation((String)Mockito.eq((Object)"index"), (String)Mockito.eq((Object)"1"), (String)Mockito.eq((Object)"test"), Integer.valueOf(Mockito.eq((int)200)), (String)Mockito.isNull(String.class), Mockito.anyLong());
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logRejectedDocumentBulkOperation((String)Mockito.eq((Object)"delete"), (String)Mockito.eq((Object)"2"), (String)Mockito.eq((Object)"test"), Integer.valueOf(Mockito.eq((int)404)), (String)Mockito.isNull(String.class), Mockito.anyLong());
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logRejectedDocumentBulkOperation((String)Mockito.eq((Object)"create"), (String)Mockito.eq((Object)"3"), (String)Mockito.eq((Object)"test"), Integer.valueOf(Mockito.eq((int)409)), (String)Mockito.eq((Object)"DocumentAlreadyExistsException[[test][4] [type1][3]: document already exists]"), Mockito.anyLong());
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logRejectedDocumentBulkOperation((String)Mockito.eq((Object)"update"), (String)Mockito.eq((Object)"1"), (String)Mockito.eq((Object)"index1"), Integer.valueOf(Mockito.eq((int)404)), (String)Mockito.eq((Object)"DocumentMissingException[[index1][-1] [type1][1]: document missing]"), Mockito.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test
    public void createIndex_callAuditTrail() throws IOException {
        String response = "{\"error\":\"IndexAlreadyExistsException[[profile] already exists]\",\"status\":400}";
        this.initClientMock(404, "Not Found", 400, response);
        this.elasticIndexingClient.sendCreateIndexRequest("profile", "mySettings", "someMappings");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).audit((String)Mockito.eq((Object)"create_index"), (String)Mockito.isNull(String.class), (String)Mockito.eq((Object)"profile"), Integer.valueOf(Mockito.eq((int)400)), (String)Mockito.eq((Object)"{\"error\":\"IndexAlreadyExistsException[[profile] already exists]\",\"status\":400}"), Mockito.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test
    public void sendBulkRequest_fullLogNotEnabled_auditTrailNotCalled() throws IOException {
        String response = "{\"took\":15,\"errors\":false,\"items\":[{\"index\":{\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_version\":3,\"status\":200}}]}";
        this.initClientMock(999, "", 200, response);
        Mockito.when((Object)this.auditTrail.isFullLogEnabled()).thenReturn((Object)false);
        this.elasticIndexingClient.sendCUDRequest("myBulk");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).isFullLogEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test(expected=ElasticClientAuthenticationException.class)
    public void createType_notAuthenticated_throwsException() throws IOException {
        this.initClientMock(999, "", 401, "Authentication Required");
        this.elasticIndexingClient.sendCUDRequest("myBulk");
        Assert.fail((String)"ElasticClientAuthenticationException expected");
    }

    @Test
    public void createIndex_indexAlreadyExists_noRequestIsSentToES() throws IOException {
        this.initClientMock(200, "{my existing Mapping}", 999, "");
        this.elasticIndexingClient.sendCreateIndexRequest("myIndex", "mySettings", "someMappings");
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)1))).execute((HttpUriRequest)this.httpGetRequestCaptor.capture());
        Assert.assertEquals((Object)"http://127.0.0.1:9200/myIndex", (Object)((HttpGet)this.httpGetRequestCaptor.getValue()).getURI().toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.httpClient});
    }

    @Test
    public void createIndex_indexNotExists_requestIsSentToES() throws IOException {
        this.initClientMock(404, "{}", 200, "Success");
        this.elasticIndexingClient.sendCreateIndexRequest("myIndex", "mySettings", "someMappings");
        ((HttpClient)Mockito.verify((Object)this.httpClient, (VerificationMode)Mockito.times((int)2))).execute((HttpUriRequest)this.httpPutRequestCaptor.capture());
        Assert.assertEquals((Object)"http://127.0.0.1:9200/myIndex", (Object)((HttpPut)this.httpPutRequestCaptor.getValue()).getURI().toString());
        Assert.assertEquals((Object)"{\"settings\": mySettings, \"mappings\": someMappings}", (Object)IOUtils.toString((InputStream)((HttpPut)this.httpPutRequestCaptor.getValue()).getEntity().getContent()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.httpClient});
    }

    @Test
    public void shouldUseDefaultHttpMaxConnectionsPerRouteWhenNoConfiguration() {
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticIndexingClient.getClientConnectionManager();
        Assert.assertEquals((long)100L, (long)clientConnectionManager.getDefaultMaxPerRoute());
    }

    @Test
    public void shouldUseDefaultHttpMaxConnectionsPerRouteWhenConfiguredValueIsNotANumber() {
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"string");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticIndexingClient.getClientConnectionManager();
        Assert.assertEquals((long)100L, (long)clientConnectionManager.getDefaultMaxPerRoute());
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"");
    }

    @Test
    public void shouldUseDefaultHttpMaxConnectionsPerRouteWhenConfiguredValueIsNotAPositiveNumber() {
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"0");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticIndexingClient.getClientConnectionManager();
        Assert.assertEquals((long)100L, (long)clientConnectionManager.getDefaultMaxPerRoute());
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"");
    }

    @Test
    public void shouldUseConfiguredHttpMaxConnectionsPerRouteWhenConfiguredValueIsAPositiveNumber() {
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"10");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticIndexingClient.getClientConnectionManager();
        Assert.assertEquals((long)10L, (long)clientConnectionManager.getDefaultMaxPerRoute());
        PropertyManager.setProperty((String)"exo.es.index.http.connections.max", (String)"");
    }

    private void initClientMock(Integer getOrHeadStatus, String getOrHeadContent, Integer postStatus, String postContent) throws IOException {
        final HttpResponse getOrHeadResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine getOrHeadStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity getOrHeadHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)getOrHeadResponse.getStatusLine()).thenReturn((Object)getOrHeadStatusLine);
        Mockito.when((Object)getOrHeadStatusLine.getStatusCode()).thenReturn((Object)getOrHeadStatus);
        Mockito.when((Object)getOrHeadResponse.getEntity()).thenReturn((Object)getOrHeadHttpEntity);
        Mockito.when((Object)getOrHeadHttpEntity.getContent()).thenReturn((Object)IOUtils.toInputStream((String)getOrHeadContent, (String)"UTF-8"));
        final HttpResponse postResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine postStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity postHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)postResponse.getStatusLine()).thenReturn((Object)postStatusLine);
        Mockito.when((Object)postStatusLine.getStatusCode()).thenReturn((Object)postStatus);
        Mockito.when((Object)postResponse.getEntity()).thenReturn((Object)postHttpEntity);
        Mockito.when((Object)postHttpEntity.getContent()).thenReturn((Object)IOUtils.toInputStream((String)postContent, (String)"UTF-8"));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpRequestBase.class))).thenAnswer((Answer)new Answer<HttpResponse>(){

            public HttpResponse answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                if (args[0] instanceof HttpGet || args[0] instanceof HttpHead) {
                    return getOrHeadResponse;
                }
                return postResponse;
            }
        });
    }
}

