/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.commons.search.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.PropertyManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class ElasticSearchingClientTest {
    private ElasticSearchingClient elasticSearchingClient;
    @Mock
    private HttpClient httpClient;
    @Mock
    private ElasticIndexingAuditTrail auditTrail;
    @Captor
    private ArgumentCaptor<HttpPost> httpPostRequestCaptor;

    @Before
    public void initMock() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        PropertyManager.setProperty((String)"exo.es.search.server.url", (String)"http://127.0.0.1:9200");
        this.elasticSearchingClient = new ElasticSearchingClient(this.auditTrail);
        this.elasticSearchingClient.client = this.httpClient;
        this.elasticSearchingClient.resetMaxConnections();
    }

    @Test
    public void sendSearchRequest_successRequest_callAuditTrailWithSuccessMessage() throws IOException {
        String response = "{\n  \"took\":7,\n  \"timed_out\":false,\n  \"_shards\":{\"total\":5,\"successful\":5,\"failed\":0},\n  \"hits\":{\n    \"total\":2,\n    \"max_score\":1.0,\n    \"hits\":[\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value1\" }},\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"3\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value3\" }}\n    ]\n  }\n}";
        this.initClientMock(200, response);
        Mockito.when((Object)this.auditTrail.isFullLogEnabled()).thenReturn((Object)true);
        this.elasticSearchingClient.sendRequest("mySearch", "test");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).isFullLogEnabled();
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logAcceptedSearchOperation((String)Mockito.eq((Object)"search_type"), (String)Mockito.eq((Object)"test"), Integer.valueOf(Mockito.eq((int)200)), (String)Mockito.eq((Object)response), Mockito.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test
    public void sendSearchRequest_errorRequest_callAuditTrailWithErrorMessage() throws IOException {
        String response = "{\n  \"took\":7,\n  \"timed_out\":false,\n  \"_shards\":{\"total\":5,\"successful\":5,\"failed\":0},\n  \"hits\":{\n    \"total\":2,\n    \"max_score\":1.0,\n    \"hits\":[\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value1\" }},\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"3\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value3\" }}\n    ]\n  }\n}";
        this.initClientMock(404, response);
        Mockito.lenient().when((Object)this.auditTrail.isFullLogEnabled()).thenReturn((Object)true);
        this.elasticSearchingClient.sendRequest("mySearch", "test");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logRejectedSearchOperation((String)Mockito.eq((Object)"search_type"), (String)Mockito.eq((Object)"test"), Integer.valueOf(Mockito.eq((int)404)), Mockito.anyString(), Mockito.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test
    public void sendSearchRequest_fullLogNotEnabledAndSuccessRequest_auditTrailNotCalled() throws IOException {
        String response = "{\n  \"took\":7,\n  \"timed_out\":false,\n  \"_shards\":{\"total\":5,\"successful\":5,\"failed\":0},\n  \"hits\":{\n    \"total\":2,\n    \"max_score\":1.0,\n    \"hits\":[\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value1\" }},\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"3\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value3\" }}\n    ]\n  }\n}";
        this.initClientMock(200, response);
        Mockito.when((Object)this.auditTrail.isFullLogEnabled()).thenReturn((Object)false);
        this.elasticSearchingClient.sendRequest("mySearch", "test");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).isFullLogEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test
    public void sendSearchRequest_fullLogNotEnabledAndErrorRequest_auditTrailCalled() throws IOException {
        String response = "{\n  \"took\":7,\n  \"timed_out\":false,\n  \"_shards\":{\"total\":5,\"successful\":5,\"failed\":0},\n  \"hits\":{\n    \"total\":2,\n    \"max_score\":1.0,\n    \"hits\":[\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"1\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value1\" }},\n      {\"_index\":\"test\",\"_type\":\"type1\",\"_id\":\"3\",\"_score\":1.0,\"_source\":{ \"field1\" : \"value3\" }}\n    ]\n  }\n}";
        this.initClientMock(404, response);
        Mockito.lenient().when((Object)this.auditTrail.isFullLogEnabled()).thenReturn((Object)false);
        this.elasticSearchingClient.sendRequest("mySearch", "test");
        ((ElasticIndexingAuditTrail)Mockito.verify((Object)this.auditTrail)).logRejectedSearchOperation((String)Mockito.eq((Object)"search_type"), (String)Mockito.eq((Object)"test"), Integer.valueOf(Mockito.eq((int)404)), Mockito.anyString(), Mockito.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.auditTrail});
    }

    @Test
    public void shouldUseDefaultHttpMaxConnectionsPerRouteWhenNoConfiguration() {
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticSearchingClient.getClientConnectionManager();
        Assert.assertEquals((long)100L, (long)clientConnectionManager.getDefaultMaxPerRoute());
    }

    @Test
    public void shouldUseDefaultHttpMaxConnectionsPerRouteWhenConfiguredValueIsNotANumber() {
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"string");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticSearchingClient.getClientConnectionManager();
        Assert.assertEquals((long)100L, (long)clientConnectionManager.getDefaultMaxPerRoute());
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"");
    }

    @Test
    public void shouldUseDefaultHttpMaxConnectionsPerRouteWhenConfiguredValueIsNotAPositiveNumber() {
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"0");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticSearchingClient.getClientConnectionManager();
        Assert.assertEquals((long)100L, (long)clientConnectionManager.getDefaultMaxPerRoute());
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"");
    }

    @Test
    public void shouldUseConfiguredHttpMaxConnectionsPerRouteWhenConfiguredValueIsAPositiveNumber() {
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"10");
        PoolingHttpClientConnectionManager clientConnectionManager = (PoolingHttpClientConnectionManager)this.elasticSearchingClient.getClientConnectionManager();
        Assert.assertEquals((long)10L, (long)clientConnectionManager.getDefaultMaxPerRoute());
        PropertyManager.setProperty((String)"exo.es.search.http.connections.max", (String)"");
    }

    private void initClientMock(Integer postStatus, String postContent) throws IOException {
        final HttpResponse postResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        StatusLine postStatusLine = (StatusLine)Mockito.mock(StatusLine.class);
        HttpEntity postHttpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)postResponse.getStatusLine()).thenReturn((Object)postStatusLine);
        Mockito.when((Object)postStatusLine.getStatusCode()).thenReturn((Object)postStatus);
        Mockito.when((Object)postResponse.getEntity()).thenReturn((Object)postHttpEntity);
        Mockito.when((Object)postHttpEntity.getContent()).thenReturn((Object)IOUtils.toInputStream((String)postContent, (String)"UTF-8"));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Mockito.any(HttpPost.class))).thenAnswer((Answer)new Answer<HttpResponse>(){

            public HttpResponse answer(InvocationOnMock invocation) throws Throwable {
                return postResponse;
            }
        });
    }
}

