/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.es.client;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ElasticIndexingAuditTrail {
    public static final String REINDEX_ALL = "reindex_all";
    public static final String DELETE_ALL = "delete_all";
    public static final String CREATE_INDEX = "create_index";
    public static final String DELETE_INDEX = "delete_index";
    public static final String CREATE_INDEX_ALIAS = "create_index_alias";
    public static final String REINDEX_TYPE = "reindex_type";
    public static final String SEARCH_INDEX = "search_type";
    public static final String CREATE_PIPELINE = "create_pipeline";
    public static final String CREATE_DOC_PIPELINE = "create_doc_pipeline";
    private static final Log AUDIT_TRAIL = ExoLogger.getExoLogger((String)"org.exoplatform.es.audittrail");
    private static final char SEPARATOR = ';';
    private static final String LOG_PATTERN = "{}" + StringUtils.repeat((String)";{}", (int)6);

    public static boolean isError(Integer httpStatusCode) {
        return httpStatusCode != null && (httpStatusCode < 200 || httpStatusCode > 299);
    }

    public void audit(String action, String entityId, String index, Integer httpStatusCode, String message, long executionTime) {
        if (ElasticIndexingAuditTrail.isError(httpStatusCode)) {
            this.logError(action, entityId, index, httpStatusCode, message, executionTime);
        } else {
            this.logInfo(action, entityId, index, httpStatusCode, message, executionTime);
        }
    }

    public void logRejectedDocumentBulkOperation(String action, String entityId, String index, Integer httpStatusCode, String message, long executionTime) {
        this.logError(action, entityId, index, httpStatusCode, message, executionTime);
    }

    public boolean isFullLogEnabled() {
        return AUDIT_TRAIL.isDebugEnabled();
    }

    public void logAcceptedBulkOperation(String action, String entityId, String index, Integer httpStatusCode, String message, long executionTime) {
        this.logDebug(action, entityId, index, httpStatusCode, message, executionTime);
    }

    public void logRejectedSearchOperation(String action, String index, Integer httpStatusCode, String message, long executionTime) {
        this.logError(action, null, index, httpStatusCode, message, executionTime);
    }

    public void logAcceptedSearchOperation(String action, String index, Integer httpStatusCode, String message, long executionTime) {
        this.logDebug(action, null, index, httpStatusCode, message, executionTime);
    }

    private void logInfo(String action, String entityId, String index, Integer httpStatusCode, String message, long executionTime) {
        AUDIT_TRAIL.info(LOG_PATTERN, new Object[]{action, StringUtils.isBlank((String)entityId) ? "" : this.escape(entityId), StringUtils.isBlank((String)index) ? "" : this.escape(index), httpStatusCode == null ? "" : httpStatusCode, StringUtils.isBlank((String)message) ? "" : this.escape(message), executionTime});
    }

    private void logError(String action, String entityId, String index, Integer httpStatusCode, String message, long executionTime) {
        if (AUDIT_TRAIL.isDebugEnabled() || PropertyManager.isDevelopping()) {
            AUDIT_TRAIL.error(LOG_PATTERN, new Object[]{action, StringUtils.isBlank((String)entityId) ? "" : this.escape(entityId), StringUtils.isBlank((String)index) ? "" : this.escape(index), httpStatusCode == null ? "" : httpStatusCode, StringUtils.isBlank((String)message) ? "" : this.escape(message), executionTime, new IllegalStateException()});
        } else {
            AUDIT_TRAIL.error(LOG_PATTERN, new Object[]{action, StringUtils.isBlank((String)entityId) ? "" : this.escape(entityId), StringUtils.isBlank((String)index) ? "" : this.escape(index), httpStatusCode == null ? "" : httpStatusCode, StringUtils.isBlank((String)message) ? "" : this.escape(message), executionTime});
        }
    }

    private void logDebug(String action, String entityId, String index, Integer httpStatusCode, String message, long executionTime) {
        AUDIT_TRAIL.debug(LOG_PATTERN, new Object[]{action, StringUtils.isBlank((String)entityId) ? "" : this.escape(entityId), StringUtils.isBlank((String)index) ? "" : this.escape(index), httpStatusCode == null ? "" : httpStatusCode, StringUtils.isBlank((String)message) ? "" : this.escape(message), executionTime});
    }

    private String escape(String message) {
        if (message == null) {
            return null;
        }
        return message.replace(';', ',');
    }
}

