/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.job;

import org.exoplatform.commons.search.index.IndexingOperationProcessor;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

@DisallowConcurrentExecution
public class BulkIndexingJob
implements InterruptableJob {
    private static final Log LOG = ExoLogger.getExoLogger(BulkIndexingJob.class);
    private IndexingOperationProcessor indexingOperationProcessor;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LOG.debug((Object)"Running job BulkIndexingJob");
        long startTime = System.currentTimeMillis();
        this.getIndexingOperationProcessor().process();
        long duration = System.currentTimeMillis() - startTime;
        if (duration > 60000L) {
            LOG.info("End running BulkIndexingJob in {}ms", new Object[]{duration});
        } else {
            LOG.debug("End running BulkIndexingJob in {}ms", new Object[]{duration});
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOG.debug((Object)"Interrupting job BulkIndexingJob");
        this.getIndexingOperationProcessor().interrupt();
    }

    private IndexingOperationProcessor getIndexingOperationProcessor() {
        if (this.indexingOperationProcessor == null) {
            this.indexingOperationProcessor = (IndexingOperationProcessor)CommonsUtils.getService(IndexingOperationProcessor.class);
        }
        return this.indexingOperationProcessor;
    }
}

