/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.junit.BeforeClass;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/test-root-configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/test-portal-configuration.xml")})
public abstract class BaseCommonsTestCase
extends AbstractKernelTest {
    private static final Log LOG = ExoLogger.getLogger(BaseCommonsTestCase.class);
    protected final String REPO_NAME = "repository";
    protected final String WORKSPACE_NAME = "portal-test";
    protected PortalContainer container;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected Session session;
    protected Node root;

    public void setUp() throws Exception {
        System.setProperty("exo.test.random.name", "" + Math.random());
        super.setUp();
        this.begin();
        this.container = PortalContainer.getInstance();
        this.repositoryService = this.getService(RepositoryService.class);
        this.configurationManager = this.getService(ConfigurationManager.class);
        this.session = this.repositoryService.getCurrentRepository().getSystemSession("portal-test");
        this.root = this.session.getRootNode();
        System.setProperty("gatein.email.domain.url", "http://localhost:8080");
    }

    protected void tearDown() throws Exception {
        NodeIterator iter = this.root.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            node.remove();
        }
        this.session.save();
        this.end();
        super.tearDown();
    }

    @BeforeClass
    protected void beforeRunBare() {
        if (System.getProperty("gatein.test.output.path") == null) {
            System.setProperty("gatein.test.output.path", System.getProperty("java.io.tmpdir"));
        }
        super.beforeRunBare();
    }

    protected <T> T getService(Class<T> clazz) {
        return clazz.cast(this.container.getComponentInstanceOfType(clazz));
    }
}

