/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing.jcr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.testing.AbstractExoContainerTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.junit.Assert;
import org.junit.Before;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/jcr/jcr-configuration.xml")})
public abstract class AbstractJCRTestCase
extends AbstractExoContainerTestCase {
    private static final Log LOG = ExoLogger.getLogger(AbstractJCRTestCase.class);
    private static String tempDir;

    @Before
    public void setUp() {
    }

    @Override
    public void beforeContainerStart() {
        this.initTempDir();
    }

    public void initTempDir() {
        tempDir = "target/temp" + System.nanoTime() + AbstractJCRTestCase.class.getCanonicalName();
        System.setProperty("test.tmpdir", tempDir);
    }

    ManageableRepository getRepo() throws RepositoryException, RepositoryConfigurationException {
        RepositoryService repos = (RepositoryService)this.getComponent(RepositoryService.class);
        return repos.getCurrentRepository();
    }

    protected String getWorkspace() throws RepositoryException, RepositoryConfigurationException {
        return this.getRepo().getConfiguration().getDefaultWorkspaceName();
    }

    protected String getRepository() throws RepositoryException, RepositoryConfigurationException {
        return this.getRepo().getConfiguration().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNodeExists(String path) {
        Session session = null;
        try {
            session = this.getSession();
            boolean exists = session.getRootNode().hasNode(path);
            if (!exists) {
                Assert.fail((String)("no node exists at " + path));
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)"failed to assert node exists", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            LOG.error((Object)"failed to assert node exists", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNodeNotExists(String path) {
        Session session = null;
        try {
            session = this.getSession();
            boolean exists = session.getRootNode().hasNode(path);
            if (exists) {
                Assert.fail((String)("node exists at " + path));
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)"failed to assert node exists", (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            LOG.error((Object)"failed to assert node exists", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node getNode(String path) {
        Session session = null;
        try {
            session = this.getSession();
            Node node = session.getRootNode().getNode(path);
            return node;
        }
        catch (RepositoryException e) {
            LOG.error((Object)"failed to load node exists", (Throwable)e);
            Node node = null;
            return node;
        }
        catch (RepositoryConfigurationException e) {
            LOG.error((Object)"failed to load node exists", (Throwable)e);
            Node node = null;
            return node;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Session getSession() throws RepositoryException, RepositoryConfigurationException {
        return this.getRepo().getSystemSession(this.getWorkspace());
    }

    protected Node addNode(String path) {
        return this.addNode(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node addNode(String path, String nodetype) {
        Session session = null;
        try {
            Node sections;
            session = this.getSession();
            Node parent = session.getRootNode();
            for (String section : sections = path.split("/")) {
                if (section.length() > 0 && !parent.hasNode(section)) {
                    if (nodetype != null && path.endsWith(section)) {
                        parent.addNode(section, nodetype);
                    } else {
                        parent.addNode(section);
                    }
                }
                parent = parent.getNode(section);
            }
            session.save();
            Node node = parent;
            return node;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("failed to add node" + path), (Throwable)e);
            }
            Node node = null;
            return node;
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("failed to add node" + path), (Throwable)e);
            }
            Node node = null;
            return node;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected Node addFile(String path) {
        Session session = null;
        try {
            String[] sections;
            session = this.getSession();
            Node parent = session.getRootNode();
            for (String section : sections = path.split("/")) {
                if (section.length() > 0 && !parent.hasNode(section)) {
                    if (path.endsWith(section)) {
                        Node ntfile = parent.addNode(section, "nt:file");
                        Node nodeContent = ntfile.addNode("jcr:content", "nt:resource");
                        nodeContent.setProperty("jcr:mimeType", "text/plain");
                        nodeContent.setProperty("jcr:data", (InputStream)new ByteArrayInputStream("stuff".getBytes()));
                        nodeContent.setProperty("jcr:lastModified", Calendar.getInstance().getTimeInMillis());
                    } else {
                        parent.addNode(section);
                    }
                }
                parent = parent.getNode(section);
            }
            session.save();
            return parent;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("failed to add node" + path), (Throwable)e);
            }
            return null;
        }
        catch (RepositoryConfigurationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("failed to add node" + path), (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteNode(String path) {
        Session session = null;
        try {
            session = this.getSession();
            Node parent = session.getRootNode();
            Node target = parent.getNode(path);
            target.remove();
            session.save();
        }
        catch (RepositoryException e) {
            LOG.error((Object)("failed to remove node" + path), (Throwable)e);
        }
        catch (RepositoryConfigurationException e) {
            LOG.error((Object)("failed to remove node" + path), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    protected void assertPropertyExists(Node node, String property) {
        try {
            Assert.assertTrue((String)("Node misses property " + property), (boolean)node.hasProperty(property));
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Repository Exception: ", (Throwable)e);
        }
    }

    protected void assertBinaryPropertyNotEmpty(Node node, String property) {
        this.assertPropertyExists(node, property);
        try {
            String str;
            InputStream is = node.getProperty(property).getStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuffer buff = new StringBuffer();
            while ((str = reader.readLine()) != null) {
                buff.append(str);
            }
            reader.close();
            Assert.assertTrue((String)("property " + property + " was empty"), (buff.length() > 0 ? 1 : 0) != 0);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Repository error: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IOException when using the reader: ", (Throwable)e);
        }
    }

    protected void assertPropertyEquals(String expected, Node node, String property) {
        try {
            Assert.assertEquals((Object)expected, (Object)node.getProperty(property).getString());
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Repository error: ", (Throwable)e);
        }
    }

    protected void assertPropertyEquals(boolean expected, Node node, String property) {
        try {
            Assert.assertEquals((Object)expected, (Object)node.getProperty(property).getBoolean());
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Repository error: ", (Throwable)e);
        }
    }
}

