/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.testing.ContainerBuilder;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.junit.Before;

public abstract class AbstractExoContainerTestCase {
    private static boolean isInit = false;

    @Before
    public final void startContainer() {
        if (!isInit) {
            this.beforeContainerStart();
            this.initExoContainer();
            this.afterContainerStart();
            isInit = true;
        }
    }

    protected void afterContainerStart() {
    }

    protected void beforeContainerStart() {
    }

    private void initExoContainer() {
        HashSet<String> rootConfigPaths = new HashSet<String>();
        rootConfigPaths.add("conf/test-root-configuration.xml");
        HashSet<String> portalConfigPaths = new HashSet<String>();
        portalConfigPaths.add("conf/test-portal-configuration.xml");
        portalConfigPaths.add("conf/" + this.getClass().getSimpleName() + ".xml");
        EnumMap<ContainerScope, HashSet<String>> configs = new EnumMap<ContainerScope, HashSet<String>>(ContainerScope.class);
        configs.put(ContainerScope.ROOT, rootConfigPaths);
        configs.put(ContainerScope.PORTAL, portalConfigPaths);
        ConfiguredBy cfBy = this.getClass().getAnnotation(ConfiguredBy.class);
        if (cfBy != null) {
            for (ConfigurationUnit src : cfBy.value()) {
                ((Set)configs.get(src.scope())).add(src.path());
            }
        }
        ContainerBuilder builder = new ContainerBuilder();
        Set rootConfs = (Set)configs.get(ContainerScope.ROOT);
        for (String rootConf : rootConfs) {
            builder.withRoot(rootConf);
        }
        Set portalConfs = (Set)configs.get(ContainerScope.PORTAL);
        for (String portalConf : portalConfs) {
            builder.withPortal(portalConf);
        }
        builder.build();
    }

    protected <T, I extends T> void registerComponent(Class<T> key, I instance) {
        ExoContainerContext.getCurrentContainer().registerComponentInstance(key, instance);
    }

    protected <T, U extends T> U getComponent(Class<T> key) {
        PortalContainer container = PortalContainer.getInstance();
        return (U)container.getComponentInstanceOfType(key);
    }

    protected <T, I extends T> void replaceComponent(Class<T> key, I instance) {
        ExoContainerContext.getCurrentContainer().unregisterComponent(key);
        this.registerComponent(key, instance);
    }
}

