/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestSuite;
import org.exoplatform.commons.testing.BaseExoTestCase;
import org.exoplatform.commons.testing.ConfigTestCase;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.KernelBootstrap;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
public abstract class BaseExoContainerTestSuite {
    private static KernelBootstrap bootstrap;
    private static final Map<Class<?>, AtomicLong> counters;
    private static Class<?> testCaseClazz;

    @BeforeClass
    public static void setUp() throws Exception {
        BaseExoContainerTestSuite.beforeSetup();
    }

    @AfterClass
    public static void tearDown() {
        BaseExoContainerTestSuite.afterTearDown();
    }

    protected static synchronized void initConfiguration(Class<?> clazz) {
        ConfigTestCase config = clazz.getAnnotation(ConfigTestCase.class);
        testCaseClazz = config != null ? config.value() : AbstractKernelTest.class;
    }

    protected static synchronized void beforeSetup() throws Exception {
        Class<?> key = testCaseClazz;
        if (!counters.containsKey(testCaseClazz)) {
            counters.put(key, new AtomicLong(new TestSuite(testCaseClazz).testCount()));
            bootstrap = new KernelBootstrap(Thread.currentThread().getContextClassLoader());
            bootstrap.addConfiguration(testCaseClazz);
            bootstrap.boot();
            BaseExoTestCase.ownBootstrap = bootstrap;
        }
    }

    protected static synchronized void afterTearDown() {
        Class<?> key = testCaseClazz;
        if (counters.get(key).decrementAndGet() == 0L) {
            bootstrap.dispose();
            bootstrap = null;
            BaseExoTestCase.ownBootstrap = null;
        }
    }

    static {
        counters = new HashMap();
        testCaseClazz = null;
    }
}

