/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.testing.mock;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import junit.framework.TestCase;
import org.exoplatform.commons.testing.AssertUtils;
import org.exoplatform.commons.testing.mock.SimpleMockOrganizationService;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

public class TestSimpleMockOrganizationService
extends TestCase {
    SimpleMockOrganizationService a = new SimpleMockOrganizationService();

    public void setUp() {
        this.a = new SimpleMockOrganizationService();
        this.a.destroy();
    }

    public void testSimpleGroup() {
        TestSimpleMockOrganizationService.assertFalse((boolean)this.group("group1").equals(null));
        TestSimpleMockOrganizationService.assertFalse((boolean)this.group("foo").equals(this.user("foo")));
        TestSimpleMockOrganizationService.assertFalse((boolean)this.group("foo").equals(this.group("bar")));
        TestSimpleMockOrganizationService.assertEquals((Object)this.group("foo"), (Object)this.group("foo"));
        TestSimpleMockOrganizationService.assertEquals((Object)this.group("foo"), (Object)new Group(){

            public String getDescription() {
                return null;
            }

            public String getGroupName() {
                return null;
            }

            public String getId() {
                return "foo";
            }

            public String getLabel() {
                return null;
            }

            public String getParentId() {
                return null;
            }

            public void setDescription(String desc) {
            }

            public void setGroupName(String name) {
            }

            public void setLabel(String name) {
            }

            public void setId(String id) {
            }

            public void setParentId(String id) {
            }
        });
        TestSimpleMockOrganizationService.assertEquals((String)"c", (String)this.group("/a/b/c").getGroupName());
        TestSimpleMockOrganizationService.assertEquals((String)"/a/b", (String)this.group("/a/b/c").getParentId());
        TestSimpleMockOrganizationService.assertEquals((String)"/a/b/c", (String)this.group("/a/b/c").getId());
    }

    public void testGroupHandler() throws Exception {
        GroupHandler groupHandler = this.a.getGroupHandler();
        AssertUtils.assertEmpty((Collection)groupHandler.getAllGroups());
        TestSimpleMockOrganizationService.assertNull((Object)groupHandler.findGroupById("/foo"));
        AssertUtils.assertEmpty((Collection)groupHandler.findGroupByMembership("user", "type"));
        AssertUtils.assertEmpty((Collection)groupHandler.findGroups(this.group("/foo")));
        AssertUtils.assertEmpty((Collection)groupHandler.findGroupsOfUser("user"));
        this.a.addMemberships("user1", new String[]{"member:/platform/users", "*:/platform/administrators"});
        this.a.addMemberships("user2", new String[]{"admin:/foo", "admin:/bar", "member:/baz"});
        TestSimpleMockOrganizationService.assertEquals((Object)this.group("/platform/users"), (Object)groupHandler.findGroupById("/platform/users"));
        AssertUtils.assertContains((Collection)groupHandler.findGroupByMembership("user2", "admin"), (Object[])this.groups("/foo", "/bar"));
        AssertUtils.assertNotContains((Collection)groupHandler.findGroupByMembership("user2", "admin"), (Object[])this.groups("/baz"));
        AssertUtils.assertContains((Collection)groupHandler.findGroups(this.group("/platform")), (Object[])this.groups("/platform/users", "/platform/administrators"));
        AssertUtils.assertNotContains((Collection)groupHandler.findGroups(this.group("/platform")), (Object[])this.groups("/foo", "/bar", "/baz"));
        this.a.addMemberships("user1", new String[]{"*:/foo", "admin:/bar", "member:/baz"});
        AssertUtils.assertContains((Collection)groupHandler.findGroupsOfUser("user1"), (Object[])this.groups("/foo", "/bar", "/baz", "/platform/users", "/platform/administrators"));
    }

    public void testSimpleUser() {
        TestSimpleMockOrganizationService.assertFalse((boolean)this.user("foo").equals(null));
        TestSimpleMockOrganizationService.assertFalse((boolean)this.user("foo").equals(this.user("bar")));
        TestSimpleMockOrganizationService.assertFalse((boolean)this.user("foo").equals(this.group("foo")));
        TestSimpleMockOrganizationService.assertEquals((Object)this.user("foo"), (Object)this.user("foo"));
        TestSimpleMockOrganizationService.assertEquals((Object)this.user("foo"), (Object)new User(){

            public Date getCreatedDate() {
                return null;
            }

            public String getEmail() {
                return null;
            }

            public String getFirstName() {
                return null;
            }

            public String getFullName() {
                return null;
            }

            public Date getLastLoginTime() {
                return null;
            }

            public String getLastName() {
                return null;
            }

            public String getOrganizationId() {
                return null;
            }

            public String getPassword() {
                return null;
            }

            public String getUserName() {
                return "foo";
            }

            public void setCreatedDate(Date t) {
            }

            public void setEmail(String s) {
            }

            public void setFirstName(String s) {
            }

            public void setFullName(String s) {
            }

            public void setLastLoginTime(Date t) {
            }

            public void setLastName(String s) {
            }

            public void setOrganizationId(String organizationId) {
            }

            public void setPassword(String s) {
            }

            public void setUserName(String s) {
            }

            public String getDisplayName() {
                return null;
            }

            public void setDisplayName(String displayName) {
            }

            public boolean isEnabled() {
                return true;
            }
        });
        TestSimpleMockOrganizationService.assertEquals((String)"foo", (String)this.user("foo").getUserName());
        TestSimpleMockOrganizationService.assertEquals((String)"foo", (String)this.group("foo").getId());
        TestSimpleMockOrganizationService.assertEquals((String)"foo@user.com", (String)this.user("foo").getEmail());
        User user = this.user("foo");
        user.setEmail("test@email.com");
        user.setFirstName("ABC");
        user.setLastName("BAZ");
        user.setDisplayName("USER FOO");
        TestSimpleMockOrganizationService.assertEquals((String)"test@email.com", (String)user.getEmail());
        TestSimpleMockOrganizationService.assertEquals((String)"ABC", (String)user.getFirstName());
        TestSimpleMockOrganizationService.assertEquals((String)"BAZ", (String)user.getLastName());
        TestSimpleMockOrganizationService.assertEquals((String)"USER FOO", (String)user.getDisplayName());
    }

    public void testUserHandler() throws Exception {
        UserHandler userHandler = this.a.getUserHandler();
        AssertUtils.assertEmpty((Collection)userHandler.findUsersByGroup("foo").getAll());
        this.a.addMemberships("user1", new String[]{"member:/platform/users", "*:/platform/administrators"});
        this.a.addMemberships("user2", new String[]{"admin:/foo", "admin:/bar", "member:/baz"});
        this.a.addMemberships("user1", new String[]{"*:/foo", "admin:/bar", "member:/baz"});
        AssertUtils.assertContains((Collection)userHandler.findUsersByGroup("/foo").getAll(), (Object[])new User[]{this.user("user1")});
        AssertUtils.assertNotContains((Collection)userHandler.findUsersByGroup("/platform/administrators").getAll(), (Object[])new User[]{this.user("user2")});
        AssertUtils.assertContains(Arrays.asList((User[])userHandler.findUsersByGroupId("/foo").load(0, 2)), (Object[])new User[]{this.user("user1")});
        AssertUtils.assertNotContains(Arrays.asList((User[])userHandler.findUsersByGroupId("/platform/administrators").load(0, 1)), (Object[])new User[]{this.user("user2")});
        ListAccess listAccess = userHandler.findAllUsers();
        AssertUtils.assertContains(Arrays.asList((User[])listAccess.load(0, listAccess.getSize())), (Object[])new User[]{this.user("user2")});
        userHandler.createUser(this.user("user3"), false);
        TestSimpleMockOrganizationService.assertEquals((int)3, (int)userHandler.findAllUsers().getSize());
    }

    public void testMembershipHandler() throws Exception {
        MembershipHandler membershipHandler = this.a.getMembershipHandler();
        AssertUtils.assertEmpty((Collection)membershipHandler.findMembershipsByUser("foo"));
        AssertUtils.assertEmpty((Collection)membershipHandler.findMembershipsByGroup(this.group("foo")));
        this.a.addMemberships("user1", new String[]{"member:/platform/users", "*:/platform/administrators"});
        this.a.addMemberships("user2", new String[]{"admin:/foo", "admin:/bar", "member:/baz"});
        this.a.addMemberships("user1", new String[]{"*:/foo", "admin:/bar", "member:/baz"});
        AssertUtils.assertContains((Collection)membershipHandler.findMembershipsByUser("user1"), (Object[])this.memberships("user1@member:/platform/users", "user1@*:/platform/administrators", "user1@*:/foo", "user1@admin:/bar", "user1@member:/baz"));
        AssertUtils.assertNotContains((Collection)membershipHandler.findMembershipsByUser("user2"), (Object[])this.memberships("user2@member:/platform/users", "user2@*:/platform/administrators", "user1@*:/foo"));
        AssertUtils.assertContains((Collection)membershipHandler.findMembershipsByGroup(this.group("/foo")), (Object[])this.memberships("user1@*:/foo", "user2@admin:/foo"));
        AssertUtils.assertNotContains((Collection)membershipHandler.findMembershipsByUser("/bar"), (Object[])this.memberships("user1@admin:/bar"));
    }

    private Membership membership(String id) {
        String[] parts = id.split("@");
        String[] mparts = parts[1].split(":");
        return new SimpleMockOrganizationService.SimpleMembership(parts[0], mparts[1], mparts[0]);
    }

    private Membership[] memberships(String ... ids) {
        SimpleMockOrganizationService.SimpleMembership[] result = new SimpleMockOrganizationService.SimpleMembership[ids.length];
        int i = 0;
        for (String id : ids) {
            result[i++] = (SimpleMockOrganizationService.SimpleMembership)this.membership(id);
        }
        return result;
    }

    private User user(String name) {
        return new SimpleMockOrganizationService.SimpleUser(name);
    }

    private Object[] users(String ... userNames) {
        Object[] result = new SimpleMockOrganizationService.SimpleUser[userNames.length];
        int i = 0;
        for (String userName : userNames) {
            result[i++] = new SimpleMockOrganizationService.SimpleUser(userName);
        }
        return result;
    }

    private Group group(String id) {
        return new SimpleMockOrganizationService.SimpleGroup(id);
    }

    private Group[] groups(String ... groupNames) {
        SimpleMockOrganizationService.SimpleGroup[] result = new SimpleMockOrganizationService.SimpleGroup[groupNames.length];
        int i = 0;
        for (String groupName : groupNames) {
            result[i++] = new SimpleMockOrganizationService.SimpleGroup(groupName);
        }
        return result;
    }
}

