/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;

public class TimeConvertUtils {
    private static final Log LOG = ExoLogger.getLogger(TimeConvertUtils.class);
    public static String[] strs = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR", "DECADE"};
    public static int DAY = 3;
    public static int WEEK = 4;
    public static int MONTH = 5;
    public static int YEAR = 6;
    private static float MINISECOND_OF_MINUTE = 60000.0f;
    private static float MINUTE_OF_HOUR = 60.0f;
    private static float HOUR_OF_DAY = 24.0f;
    private static float DAY_OF_WEEK = 7.0f;
    private static float WEEK_OF_MONTH = 4.35f;
    private static float MONTH_OF_YEAR = 12.0f;
    private static float YEAR_OF_DECADE = 10.0f;
    private static Float[] timeLength = new Float[]{Float.valueOf(MINISECOND_OF_MINUTE), Float.valueOf(MINUTE_OF_HOUR), Float.valueOf(HOUR_OF_DAY), Float.valueOf(DAY_OF_WEEK), Float.valueOf(WEEK_OF_MONTH), Float.valueOf(MONTH_OF_YEAR), Float.valueOf(YEAR_OF_DECADE), Float.valueOf(YEAR_OF_DECADE)};
    private static String JUSTNOW = "JUSTNOW";
    private static String SPACE = " ";
    private static String STR_EMPTY = "";
    private static String STR_S = "_S";
    private static String UNDERSCORE = "_";
    private static String RESOURCE_KEY = "TimeConvert.type.";

    private static String convertXTimeAgo(Date myDate) {
        float delta = TimeConvertUtils.getGreenwichMeanTime().getTimeInMillis() - myDate.getTime();
        int i = 0;
        for (i = 0; delta >= timeLength[i].floatValue() && i < timeLength.length - 1; delta /= timeLength[i].floatValue(), ++i) {
        }
        int l = (int)delta;
        if (l < 0 || i < 1) {
            return JUSTNOW;
        }
        return l + SPACE + strs[i] + (l > 1 ? STR_S : STR_EMPTY);
    }

    public static String convertXTimeAgo(Date myDate, String format) {
        return TimeConvertUtils.convertXTimeAgo(myDate, format, null);
    }

    public static String convertXTimeAgo(Date myDate, String format, Locale locale) {
        return TimeConvertUtils.convertXTimeAgo(myDate, format, locale, 0);
    }

    public static String convertXTimeAgo(Date myDate, String format, int limit) {
        return TimeConvertUtils.convertXTimeAgo(myDate, format, null, limit);
    }

    public static String convertXTimeAgo(Date myDate, String format, Locale locale, int limit) {
        String[] values = TimeConvertUtils.convertXTimeAgo(myDate).split(SPACE);
        if (values[0].equals(JUSTNOW)) {
            return TimeConvertUtils.getResourceBundle(RESOURCE_KEY + JUSTNOW, locale);
        }
        int i = ArrayUtils.indexOf((Object[])strs, (Object)values[1].replace(STR_S, STR_EMPTY));
        if (limit == 0 || i < limit) {
            return TimeConvertUtils.getMessage(TimeConvertUtils.getResourceBundle(RESOURCE_KEY + values[1].replace(UNDERSCORE, STR_EMPTY), locale), new String[]{values[0]});
        }
        if (locale != null) {
            return TimeConvertUtils.getFormatDate(myDate, format, locale);
        }
        return TimeConvertUtils.getFormatDate(myDate, format);
    }

    public static String getFormatDate(Date myDate, String format) {
        return TimeConvertUtils.getFormatDate(myDate, format, TimeConvertUtils.getLocale());
    }

    public static String getFormatDate(Date myDate, String format, Locale locale) {
        if (myDate == null) {
            return STR_EMPTY;
        }
        return new SimpleDateFormat(format, locale).format(myDate);
    }

    private static String getResourceBundle(String key, Locale locale) {
        if (locale == null) {
            locale = TimeConvertUtils.getLocale();
        }
        ResourceBundle res = null;
        RequestContext ctx = WebuiRequestContext.getCurrentInstance();
        if (ctx != null) {
            res = ctx.getApplicationResourceBundle();
        }
        ResourceBundleService bundleService = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        if (res == null && bundleService != null) {
            res = bundleService.getResourceBundle("locale.commons.Commons", locale);
        }
        if (res == null) {
            LOG.warn((Object)("Can not resource bundle by key: " + key));
            return key.substring(key.lastIndexOf(".") + 1).toLowerCase();
        }
        return res.getString(key);
    }

    private static String getMessage(String message, String[] args) {
        if (message != null && args != null) {
            String oldMes = message;
            for (int i = 0; i < args.length; ++i) {
                message = message.replace("{" + i + "}", args[i]);
            }
            if (message.equals(oldMes) && args.length == 1) {
                message = args[0] + SPACE + message;
            }
        }
        return message;
    }

    public static Locale getLocale() {
        RequestContext ctx = WebuiRequestContext.getCurrentInstance();
        if (ctx == null) {
            return Locale.ENGLISH;
        }
        Locale locale = ctx.getLocale();
        if (locale == null) {
            return Locale.ENGLISH;
        }
        return locale;
    }

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }
}

