/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormRichtextInput
extends UIFormInputBase<String> {
    public static final String FULL_TOOLBAR = "CompleteWCM";
    public static final String BASIC_TOOLBAR = "Basic";
    public static final String SUPER_BASIC_TOOLBAR = "SuperBasicWCM";
    public static final String INLINE_TOOLBAR = "InlineEdit";
    public static final String FORUM_TOOLBAR = "Forum";
    public static final String FAQ_TOOLBAR = "FAQ";
    public static final String ENTER_P = "1";
    public static final String ENTER_BR = "2";
    public static final String ENTER_DIV = "3";
    private String width;
    private String height;
    private String toolbar;
    private String enterMode;
    private String css;
    private boolean isPasteAsPlainText = false;
    private boolean isIgnoreParserHTML = false;

    public UIFormRichtextInput(String name, String bindingField, String value) {
        super(name, bindingField, String.class);
        this.value_ = value;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode, String toolbar) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
        this.toolbar = toolbar;
    }

    public UIFormRichtextInput(String name, String bindingField, String value, String enterMode, String toolbar, String css) {
        super(name, bindingField, String.class);
        this.value_ = value;
        this.enterMode = enterMode;
        this.toolbar = toolbar;
        this.css = css;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getToolbar() {
        return this.toolbar;
    }

    public String getEnterMode() {
        return this.enterMode;
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public void setEnterMode(String enterMode) {
        this.enterMode = enterMode;
    }

    public UIFormRichtextInput setIsPasteAsPlainText(boolean isPasteAsPlainText) {
        this.isPasteAsPlainText = isPasteAsPlainText;
        return this;
    }

    public boolean getIsPasteAsPlainText() {
        return this.isPasteAsPlainText;
    }

    public boolean isIgnoreParserHTML() {
        return this.isIgnoreParserHTML;
    }

    public UIFormRichtextInput setIgnoreParserHTML(boolean isIgnoreParserHTML) {
        this.isIgnoreParserHTML = isIgnoreParserHTML;
        return this;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getCss() {
        return this.css;
    }

    private static String encodeURLComponent(String s) {
        String result = null;
        try {
            result = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    private String buildEditorLayout() throws Exception {
        if (this.toolbar == null) {
            this.toolbar = BASIC_TOOLBAR;
        }
        if (this.width == null) {
            this.width = "98%";
        }
        if (this.height == null) {
            this.height = "'200px'";
        }
        if (this.enterMode == null) {
            this.enterMode = ENTER_P;
        }
        if (this.css == null) {
            this.css = "\"/CommonsResources/ckeditor/contents.css\"";
        }
        if (this.value_ == null) {
            this.value_ = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<div class=\"clearfix\">");
        builder.append("  <span style=\"float:left; width:").append(this.width).append(";\">");
        builder.append("  <textarea id=\"").append(this.name).append("\" name=\"").append(this.name).append("\">").append((String)this.value_).append("</textarea>\n");
        builder.append("<script type=\"text/javascript\">\n");
        if (this.isIgnoreParserHTML() && StringUtils.isNotEmpty((String)((String)this.value_))) {
            String value = UIFormRichtextInput.encodeURLComponent((String)this.value_);
            builder.append(" var textare = document.getElementById('").append(this.name).append("'); ").append(" if(textare) {").append("   var isFirefox = typeof InstallTrigger !== 'undefined';").append("   var value = decodeURIComponent('").append(value).append("');").append("   if(isFirefox) { textare.value = value; } else { textare.innerText = value;}").append(" }");
        }
        builder.append("    require(['/CommonsResources/ckeditor/ckeditor.js'], function() {").append("  //<![CDATA[\n").append("    var instance = CKEDITOR.instances['").append(this.name).append("'];").append("    if (instance) { CKEDITOR.remove(instance); instance = null;}\n");
        builder.append("    CKEDITOR.replace('").append(this.name).append("', {toolbar:'").append(this.toolbar).append("', height:").append(this.height).append(", contentsCss:").append(this.css).append(", enterMode:").append(this.enterMode).append(this.isPasteAsPlainText ? ", forcePasteAsPlainText: true" : "").append("});\n");
        builder.append("    instance = CKEDITOR.instances['" + this.name + "'];").append("    instance.on( 'change', function(e) { document.getElementById('").append(this.name).append("').value = instance.getData(); });\n").append("  //]]>\n").append("});").append("if(eXo.core.Browser.ie==9 || eXo.core.Browser.ie==10){").append(" var textare = document.getElementById('").append(this.name).append("'); ").append(" var form = textare;").append(" while (form && (form.nodeName.toLowerCase() != 'form')) { form = form.parentNode;}").append(" form.onmouseover=function(){").append("  this.onmouseover='';").append("  var textare = document.getElementById('").append(this.name).append("'); ").append("  textare.style.display='block';").append("  textare.style.visibility='visible';").append("  textare.focus();").append("  textare.style.display='none';").append(" }").append("}").append("</script>\n");
        builder.append("  </span>");
        if (this.isMandatory()) {
            builder.append("  <span style=\"float:left\"> &nbsp;*</span>");
        }
        builder.append("</div>");
        return builder.toString();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getWriter().write(this.buildEditorLayout());
    }

    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }
}

