/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class UpgradeProductService
implements Startable {
    private static final Log log = ExoLogger.getLogger(UpgradeProductService.class);
    private Set<UpgradeProductPlugin> upgradePlugins = new HashSet<UpgradeProductPlugin>();
    private ProductInformations productInformations = null;

    public UpgradeProductService(ProductInformations productInformations, InitParams initParams) {
        this.productInformations = productInformations;
    }

    public void addUpgradePlugin(UpgradeProductPlugin upgradeProductPlugin) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add Product UpgradePlugin: name = " + upgradeProductPlugin.getName()));
        }
        if (this.upgradePlugins.contains(upgradeProductPlugin.getName())) {
            log.warn((Object)(upgradeProductPlugin.getName() + " upgrade plugin is duplicated. One of duplicated plugins will be ignore!"));
        }
        this.upgradePlugins.add(upgradeProductPlugin);
    }

    public void start() {
        block7: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"start method begin");
            }
            try {
                String currentVersion = this.productInformations.getVersion();
                String previousVersion = this.productInformations.getPreviousVersion();
                if (previousVersion.equals(currentVersion)) break block7;
                log.info((Object)("New version has been detected: proceed upgrading from " + previousVersion + " to " + currentVersion));
                for (UpgradeProductPlugin upgradeProductPlugin : this.upgradePlugins) {
                    block8: {
                        try {
                            String currentProductPluginVersion = this.productInformations.getVersion(upgradeProductPlugin.getProductGroupId());
                            String previousProductPluginVersion = this.productInformations.getPreviousVersion(upgradeProductPlugin.getProductGroupId());
                            if (!upgradeProductPlugin.shouldProceedToUpgrade(currentProductPluginVersion, previousProductPluginVersion)) break block8;
                            log.info((Object)("Proceed upgrade plugin: name = " + upgradeProductPlugin.getName() + " from version " + previousProductPluginVersion + " to " + currentProductPluginVersion));
                            upgradeProductPlugin.processUpgrade(previousProductPluginVersion, currentProductPluginVersion);
                        }
                        catch (Exception exception) {
                            log.error((Object)("The plugin " + upgradeProductPlugin.getName() + " generated an error."), (Throwable)exception);
                            continue;
                        }
                    }
                    log.info((Object)("Upgrade " + upgradeProductPlugin.getName() + " completed."));
                }
                this.productInformations.storeProductsInformationsInJCR();
                log.info((Object)"Version upgrade completed.");
            }
            catch (MissingProductInformationException missingProductInformationException) {
                log.error((Object)"Can't proceed to the upgrade", (Throwable)missingProductInformationException);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"start method end");
        }
    }

    public void stop() {
    }
}

