package company.portlet.language;

import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/**
 * Created by The eXo Platform SAS 
 * Author : TrungTN
 * 
 */

@ComponentConfig(lifecycle = UIApplicationLifecycle.class, 	template = "app:/templates/LanguageSelectPortlet/UILanguageSelectPortlet.gtmpl", 
															events = { @EventConfig(listeners = UILanguageSelectPortlet.SaveActionListener.class) })
public class UILanguageSelectPortlet extends UIPortletApplication {

	static public class SaveActionListener extends EventListener<UILanguageSelectPortlet> {
		public void execute(Event<UILanguageSelectPortlet> event) throws Exception {

			String language = event.getRequestContext().getRequestParameter(OBJECTID);

			UIPortalApplication uiApp = Util.getUIPortalApplication();
			UIMaskWorkspace uiMaskWS = uiApp.getChildById(UIPortalApplication.UI_MASK_WS_ID);
			uiMaskWS.setUIComponent(null);
			Util.getPortalRequestContext().setFullRender(false);
			if (language == null || language.trim().length() < 1)
				return;
			LocaleConfigService localeConfigService = event.getSource().getApplicationComponent(LocaleConfigService.class);
			LocaleConfig localeConfig = localeConfigService.getLocaleConfig(language);
			if (localeConfig == null)
				localeConfig = localeConfigService.getDefaultLocaleConfig();
			uiApp.setLocale(localeConfig.getLocale());
			uiApp.setOrientation(localeConfig.getOrientation());
			uiApp.localizeNavigations();
			OrganizationService orgService = event.getSource().getApplicationComponent(OrganizationService.class);
			String remoteUser = event.getRequestContext().getRemoteUser();
			if (remoteUser != null) {
				UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(remoteUser);
				userProfile.getUserInfoMap().put("user.language", language);
				UserProfileHandler hanlder = orgService.getUserProfileHandler();
				hanlder.saveUserProfile(userProfile, true);
			}
		}
	}

	public UILanguageSelectPortlet() throws Exception {
	}
}
