/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package company.portlet.rss;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.exoplatform.services.rss.parser.DefaultRSSItem;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.company.component.web.RssReaderCompanyService;

/**
 * Created by The eXo Platform SAS 
 * Author : Phung Nam
 */
@ComponentConfig(lifecycle = UIApplicationLifecycle.class, template = "app:/templates/RssReaderPortlet/UIRssReaderPortlet.gtmpl")
public class UIRssReaderPortlet extends UIPortletApplication {

	public UIRssReaderPortlet() throws Exception {
	}

	public List<DefaultRSSItem> getRssListItem() throws Exception {
		RssReaderCompanyService readerService = getApplicationComponent(RssReaderCompanyService.class);
		return readerService.getRssListItems();
	}

	@SuppressWarnings("deprecation")
	public String formatDate(String inputDate) {
		Date dateUp = null;
		String dateOut = "";
		DateFormat dateFormatter = null;
		Locale currenLocate = Locale.US;
		dateFormatter = DateFormat.getDateInstance(DateFormat.DEFAULT, currenLocate);
		dateUp = new Date(inputDate);
		dateOut = dateFormatter.format(dateUp);	
		return dateOut;
	}

}
