package com.naftogaz.profile;


import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity_;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;

import javax.persistence.TypedQuery;
import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.List;

public class ProfileExtraDAO extends GenericDAOJPAImpl<IdentityEntity, Long> {

    public List<IdentityEntity> getIdentitiesByPropertyAndValueLike(String propertyName, String propertyValue) {
        CriteriaBuilder cb = getEntityManager().getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(IdentityEntity.class);
        Root<IdentityEntity> identity = query.from(IdentityEntity.class);
        MapJoin<IdentityEntity, String, String> properties = identity.join(IdentityEntity_.properties, JoinType.LEFT);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(cb.and(cb.and(cb.equal(properties.key(), propertyName), properties.value().isNotNull()),
                cb.and(cb.equal(properties.key(), propertyName), cb.like(properties.value(),propertyValue + "%"))));
        Predicate[] pds = predicates.toArray(new Predicate[predicates.size()]);
        query.select(identity).distinct(true).where(pds);
        TypedQuery<IdentityEntity> select = getEntityManager().createQuery(query);
        return select.getResultList();
    }
}
