package com.naftogaz.services;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.naftogaz.profile.BirthdayService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import static com.naftogaz.profile.BirthdayService.BIRTHDAY;

@Path("/naftogaz")
public class NaftogazUserProfileService implements ResourceContainer {

    private static final Log LOG = ExoLogger.getLogger(NaftogazUserProfileService.class);

    private BirthdayService birthdayService;


    public NaftogazUserProfileService(BirthdayService birthdayService) {
        this.birthdayService = birthdayService;
    }

    @POST
    @Path("/userProfile")
    @RolesAllowed("users")
    public Response saveUserProfile(Map<String, String> profileAttributes) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        boolean result = birthdayService.updateBirthday(currentUser, profileAttributes);
        if(result) {
            return Response.ok("success").build();
        } else {
            return Response.serverError().build();
        }
    }

    /**
     *
     * @param value
     * @return
     */
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    @Path("list")
    public Response list(@Context UriInfo uriInfo, @QueryParam("value") String value) {
        List<Identity> userIdentities = birthdayService.getIdentitiesByBirthDate(value);
        List<DataEntity> identityEntities = new ArrayList<DataEntity>();
        for (Identity identity : userIdentities) {
            identityEntities.add(EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), "").getDataEntity());
        }
        CollectionEntity collectionIdentity = new CollectionEntity(identityEntities, EntityBuilder.IDENTITIES_TYPE, 0, userIdentities.size());

        return EntityBuilder.getResponse(collectionIdentity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);    }
}
