/*
 * Decompiled with CFR 0.152.
 */
package com.naftogaz.profile;

import com.naftogaz.profile.ProfileExtraDAO;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.EntityConverterUtils;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.manager.IdentityManager;

public class BirthdayService {
    private Log log = ExoLogger.getLogger(BirthdayService.class);
    private ProfileExtraDAO profileExtraDAO;
    private IdentityManager identityManager;
    private OrganizationService organizationService;
    public static final String BIRTHDAY = "user.bdate";
    public static final String POSITION = "user.jobtitle";
    public static final String MOBILE = "user.business-info.telecom.mobile.number";
    public static final String HOME_PHONE = "user.business-info.telecom.telephone.number";
    private static final List<String> AVAILABLE_USER_ATTRIBUTES_TO_SAVE = Arrays.asList("user.bdate");

    public BirthdayService(ProfileExtraDAO profileExtraDAO, IdentityManager identityManager, OrganizationService organizationService) {
        this.profileExtraDAO = profileExtraDAO;
        this.identityManager = identityManager;
        this.organizationService = organizationService;
    }

    public List<Identity> getIdentitiesByBirthDate(String birthDate) {
        if (StringUtils.isBlank((CharSequence)birthDate)) {
            throw new IllegalArgumentException("Birthdate should not be empty");
        }
        if (!birthDate.matches("\\d\\d?\\W\\d\\d\\W\\d\\d\\d\\d$")) {
            throw new IllegalArgumentException("Birthdate should be with format dd-MM-yyyy");
        }
        birthDate = birthDate.substring(0, birthDate.length() - 5);
        List<IdentityEntity> identityEntities = this.profileExtraDAO.getIdentitiesByPropertyAndValueLike(BIRTHDAY, birthDate);
        return EntityConverterUtils.convertToIdentities((IdentityEntity[])identityEntities.toArray(new IdentityEntity[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBirthday(String userName, Map<String, String> profileAttributes) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", userName);
        Profile profile = this.identityManager.getProfile(identity);
        try {
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(userName);
            if (userProfile == null) {
                userProfile = this.organizationService.getUserProfileHandler().createUserProfileInstance(userName);
            }
            Thread.sleep(500L);
            for (Map.Entry<String, String> entry : profileAttributes.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (AVAILABLE_USER_ATTRIBUTES_TO_SAVE.contains(key)) {
                    profile.setProperty(key, (Object)value);
                    userProfile.setAttribute(key, value);
                    continue;
                }
                this.log.warn((Object)("Property unavailable to save: " + key));
            }
            this.identityManager.updateProfile(profile);
            if (userProfile != null) {
                this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.log.error("Error updating profile of {}", new Object[]{userName, e});
            boolean bl = false;
            return bl;
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

