/*
 * Decompiled with CFR 0.152.
 */
package com.naftogaz.services;

import com.naftogaz.profile.BirthdayService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;

@Path(value="/naftogaz")
public class NaftogazUserProfileService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(NaftogazUserProfileService.class);
    private BirthdayService birthdayService;

    public NaftogazUserProfileService(BirthdayService birthdayService) {
        this.birthdayService = birthdayService;
    }

    @POST
    @Path(value="/userProfile")
    @RolesAllowed(value={"users"})
    public Response saveUserProfile(Map<String, String> profileAttributes) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        boolean result = this.birthdayService.updateBirthday(currentUser, profileAttributes);
        if (result) {
            return Response.ok((Object)"success").build();
        }
        return Response.serverError().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    public Response list(@Context UriInfo uriInfo, @QueryParam(value="value") String value) {
        List<Identity> userIdentities = this.birthdayService.getIdentitiesByBirthDate(value);
        ArrayList<DataEntity> identityEntities = new ArrayList<DataEntity>();
        for (Identity identity : userIdentities) {
            identityEntities.add(EntityBuilder.buildEntityIdentity((Identity)identity, (String)uriInfo.getPath(), (String)"").getDataEntity());
        }
        CollectionEntity collectionIdentity = new CollectionEntity(identityEntities, "identities", 0, userIdentities.size());
        return EntityBuilder.getResponse((Object)collectionIdentity, (UriInfo)uriInfo, (MediaType)RestUtils.getJsonMediaType(), (Response.Status)Response.Status.OK);
    }
}

