/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.bench;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.cs.bench.SimpleMailServerInitializer;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailDataInjector
extends DataInjector {
    private static Log log = ExoLogger.getExoLogger(MailDataInjector.class);
    public static final String ARRAY_SPLIT = ",";
    public static final String FD_INBOX = "Inbox".intern();
    public static final String FD_DRAFTS = "Drafts".intern();
    public static final String FD_SENT = "Sent".intern();
    public static final String FD_SPAM = "Spam".intern();
    public static final String FD_TRASH = "Trash".intern();
    public static final String[] defaultFolders_ = new String[]{FD_INBOX, FD_DRAFTS, FD_SENT, FD_SPAM, FD_TRASH};
    private MailService mailService;
    private SimpleMailServerInitializer mailServerInitializer;
    private OrganizationService organizationService;

    public MailDataInjector(MailService mailService, SimpleMailServerInitializer mailServerInitializer, OrganizationService organizationService, InitParams initParams) {
        this.mailService = mailService;
        this.mailServerInitializer = mailServerInitializer;
        this.organizationService = organizationService;
    }

    private void printInputParameters(HashMap<String, String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("PARAMS: \n");
        for (String key : params.keySet()) {
            sb.append(String.format("%1$10s    :    %2$10s \n", key, params.get(key)));
        }
        log.info((Object)sb.toString());
    }

    private String makeAccountId(String prefix, String userId, int order) {
        return prefix + "_" + userId + "_" + order;
    }

    private String makeEmailAddress(String username) {
        return username + "@example.com";
    }

    private Account newAccount(String accountId, String incomingProtocol) {
        String email = this.makeEmailAddress(accountId);
        Account account = new Account();
        account.setId(accountId);
        account.setIncomingUser(email);
        account.setLabel(accountId);
        account.setIncomingPassword("password");
        account.setUseIncomingForAuthentication(true);
        account.setEmailAddress(email);
        account.setIncomingHost(this.mailServerInitializer.getHost());
        if (CONSTANTS.POP3.getName().equals(incomingProtocol)) {
            account.setProtocol("pop3");
            account.setIncomingPort(this.mailServerInitializer.getPop3Port());
        } else {
            account.setProtocol("imap");
            account.setIncomingPort(this.mailServerInitializer.getImapPort());
        }
        account.setOutgoingHost(this.mailServerInitializer.getHost());
        account.setOutgoingPort(this.mailServerInitializer.getSmtpPort());
        account.setUserDisplayName(this.randomWords(3));
        account.setDescription(this.randomWords(10));
        account.setIsSavePassword(true);
        account.setAuthMechsIncoming("starttls");
        account.setAuthMechsOutgoing("starttls");
        account.setIncomingSsl(true);
        account.setOutgoingSsl(true);
        account.setSecureAuthsIncoming("starttls");
        account.setSecureAuthsOutgoing("starttls");
        account.setIncomingFolder(FD_INBOX);
        account.setCheckAll(true);
        return account;
    }

    private List<String> readUsers(HashMap<String, String> queryParams) {
        String[] usersString;
        LinkedList<String> users = new LinkedList<String>();
        String value = queryParams.get("users");
        for (String user : usersString = value.split(ARRAY_SPLIT)) {
            users.add(user);
        }
        return users;
    }

    private int readNumOfAccounts(HashMap<String, String> queryParams) {
        String value = queryParams.get("accounts");
        String num = value.split(ARRAY_SPLIT)[0];
        return Integer.parseInt(num);
    }

    private String readPrefix(HashMap<String, String> queryParams) {
        String value = queryParams.get("accounts");
        return value.split(ARRAY_SPLIT)[1];
    }

    private String readInComingProtocol(HashMap<String, String> queryParams) {
        return queryParams.get("inPro");
    }

    private boolean readCheckNow(HashMap<String, String> queryParams) {
        return Boolean.parseBoolean(queryParams.get("check"));
    }

    private int readNumberOfMessages(HashMap<String, String> queryParams) {
        return Integer.parseInt(queryParams.get("msgs"));
    }

    private int readAttachmentSize(HashMap<String, String> queryParams) {
        return Integer.parseInt(queryParams.get("attSize"));
    }

    private void validateUsers(List<String> users) throws Exception {
        for (String user : users) {
            if (this.organizationService.getUserHandler().findUserByName(user) != null) continue;
            log.info((Object)String.format("\t Validate User: %s does not exist!", user));
            users.remove(user);
        }
    }

    private List<Folder> generateDefaultFolders(String accountId) {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (String folderName : defaultFolders_) {
            String folderId = Utils.generateFID((String)accountId, (String)folderName, (boolean)false);
            Folder folder = new Folder();
            folder.setId(folderId);
            folder.setName(folderName);
            folder.setPersonalFolder(false);
            folders.add(folder);
        }
        return folders;
    }

    public Log getLog() {
        return log;
    }

    public void inject(HashMap<String, String> queryParams) throws Exception {
        log.info((Object)"Start to inject data ................. ");
        this.printInputParameters(queryParams);
        List<String> users = this.readUsers(queryParams);
        this.validateUsers(users);
        int numOfAccounts = this.readNumOfAccounts(queryParams);
        String accPref = this.readPrefix(queryParams);
        String incProtocol = this.readInComingProtocol(queryParams);
        int numOfMsgs = this.readNumberOfMessages(queryParams);
        int attSize = this.readAttachmentSize(queryParams);
        boolean checkNow = this.readCheckNow(queryParams);
        for (String userId : users) {
            log.info((Object)("\t Process user: " + userId + " ....................."));
            for (int i = 0; i < numOfAccounts; ++i) {
                String accId = this.makeAccountId(accPref, userId, i + 1);
                Account account = this.mailService.getAccountById(userId, accId);
                if (account == null) {
                    account = this.newAccount(accId, incProtocol);
                    this.mailService.createAccount(userId, account);
                    this.mailServerInitializer.addUser(account.getEmailAddress(), account.getIncomingPassword());
                }
                List<Folder> folders = this.generateDefaultFolders(accId);
                for (Folder folder : folders) {
                    this.mailService.saveFolder(userId, accId, folder);
                }
                Random rand = new Random();
                byte[] attachment = this.createTextResource(attSize).getBytes();
                log.info((Object)("\t\t\t Pouring " + numOfMsgs + " messages into account: " + accId + " .............. "));
                for (int j = 0; j < numOfMsgs; ++j) {
                    if (attSize == 0) {
                        this.mailServerInitializer.sendMailMessage(account.getEmailAddress(), this.makeEmailAddress(this.makeAccountId(accPref, userId, rand.nextInt())), this.randomWords(100), this.randomParagraphs(4));
                        continue;
                    }
                    this.mailServerInitializer.sendMailMessage(account.getEmailAddress(), this.makeEmailAddress(this.makeAccountId(accPref, userId, rand.nextInt())), this.randomWords(100), this.randomParagraphs(4), attachment, "filename" + IdGenerator.generate() + ".txt", null);
                }
                if (!checkNow) continue;
                log.info((Object)"\t\t\t Pulling messages from mail server to eXo Mail ........");
                this.mailService.checkNewMessage(userId, account.getId(), FD_INBOX);
                log.info((Object)String.format("\tAccount %1$s has been created successfully!", account.getEmailAddress()));
            }
        }
    }

    public void reject(HashMap<String, String> queryParams) throws Exception {
        log.info((Object)"Start to reject data ................. ");
        this.printInputParameters(queryParams);
        List<String> users = this.readUsers(queryParams);
        this.validateUsers(users);
        int numOfAccounts = this.readNumOfAccounts(queryParams);
        String accPref = this.readPrefix(queryParams);
        for (String user : users) {
            log.info((Object)("\t Process user: " + user + " ....................."));
            for (int i = 0; i < numOfAccounts; ++i) {
                String accId = this.makeAccountId(accPref, user, i + 1);
                Account acc = this.mailService.getAccountById(user, accId);
                if (acc == null) continue;
                log.info((Object)String.format("Remove account: %1$s of %2$s ...........", accId, user));
                long t1 = System.currentTimeMillis();
                this.mailService.removeAccount(user, accId);
                long t2 = System.currentTimeMillis() - t1;
                log.info((Object)("Account has been removed in " + t2 + " (ms)!"));
            }
        }
        log.info((Object)"Data has been rejected successfully!");
    }

    public Object execute(HashMap<String, String> arg0) throws Exception {
        return new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CONSTANTS {
        POP3("pop3"),
        IMAP("imap");

        private final String name;

        private CONSTANTS(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

