/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.datamigration;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

public class MigrationService
implements Startable {
    private ExtendedNodeTypeManager ntManager_;
    private NodeHierarchyCreator nodeHierarchy_;
    private InitParams params_;
    private RepositoryService repoService_;
    private static final String USERS_PATH = "usersPath".intern();
    private static String ACC_SHARED = "exo:accountShared";

    public MigrationService(NodeHierarchyCreator nodeHierarchy, InitParams params) throws Exception {
        this.nodeHierarchy_ = nodeHierarchy;
        this.params_ = params;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.repoService_ = (RepositoryService)container.getComponentInstance(RepositoryService.class);
    }

    private void saveToFile(byte[] data, String path) throws Exception {
        FileOutputStream file = new FileOutputStream(path);
        file.write(data);
        file.flush();
        file.close();
    }

    private Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        return (Node)this.getSession(sessionProvider).getItem(nodePath);
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ManageableRepository currentRepo = this.repoService_.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public void start() {
        try {
            this.ntManager_ = this.repoService_.getCurrentRepository().getNodeTypeManager();
            NodeTypeIterator ntIter = this.ntManager_.getAllNodeTypes();
            boolean isVersion21 = true;
            while (ntIter.hasNext()) {
                NodeType nt = ntIter.nextNodeType();
                if (!nt.isNodeType(ACC_SHARED)) continue;
                isVersion21 = false;
                break;
            }
            if (isVersion21) {
                System.out.println("\n**********Begin exportion CS data***********");
                boolean expo1 = this.exportUserData();
                boolean expo2 = this.exportSharedData();
                if (expo1 && expo2) {
                    System.out.println("EXO CS DATA EXPORTED SUCCESSFUL");
                } else {
                    System.out.println("EXO CS DATA EXPORTED FAILURE");
                }
                System.out.println("**********End exportion CS data***********\n");
            } else {
                System.out.println("\n**********Begin importion CS data***********");
                boolean impo1 = this.importUserData();
                boolean impo2 = this.importSharedData();
                if (impo1 && impo2) {
                    System.out.println("EXO CS DATA IMPORTED SUCCESSFUL");
                } else {
                    System.out.println("EXO CS DATA IMPORTED FAILURE");
                }
                System.out.println("**********End importion CS data***********\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        System.out.println("\n\n\n");
    }

    public boolean exportUserData() {
        try {
            Node userDataNode = this.getUserDataRootNode();
            if (userDataNode == null) {
                System.out.println("Cannot get user data root node");
                return false;
            }
            String file = this.params_.getValueParam("userData2.1").getValue();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            userDataNode.getSession().exportSystemView(userDataNode.getPath(), (OutputStream)bos, false, false);
            this.saveToFile(bos.toByteArray(), file.replaceAll("file:", ""));
            System.out.println("CS User data 2.1 has exported to file: \"" + file + "\"");
        }
        catch (Exception e) {
            System.out.println("Cannot export eXo CS data 2.1" + e);
            return false;
        }
        return true;
    }

    public boolean exportSharedData() {
        try {
            Node sharedDataNode = this.getSharedDataRootNode();
            if (sharedDataNode == null) {
                System.out.println("Cannot get shared data root node");
                return false;
            }
            String file = this.params_.getValueParam("sharedData2.1").getValue();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            sharedDataNode.getSession().exportSystemView(sharedDataNode.getPath(), (OutputStream)bos, false, false);
            this.saveToFile(bos.toByteArray(), file.replaceAll("file:", ""));
            System.out.println("CS Shared data 2.1 has exported to file: \"" + file + "\"");
        }
        catch (Exception e) {
            System.out.println("Cannot export eXo CS data 2.13");
            return false;
        }
        return true;
    }

    public Node getUserDataRootNode() {
        try {
            return this.getNodeByPath(this.nodeHierarchy_.getJcrPath(USERS_PATH), SessionProvider.createSystemProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Node getSharedDataRootNode() {
        try {
            return this.nodeHierarchy_.getPublicApplicationNode(SessionProvider.createSystemProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean importUserData() {
        try {
            String file = this.params_.getValueParam("userData2.1").getValue();
            System.out.println("\n CS User data version 2.2 is importing.... ");
            Node userDataNode = this.getUserDataRootNode();
            FileInputStream in = new FileInputStream(file.replace("file:", ""));
            Node root = userDataNode.getParent();
            userDataNode.remove();
            root.getSession().save();
            if (root != null) {
                root.getSession().importXML(root.getPath(), (InputStream)in, 0);
                root.getSession().save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Cannot import CS User data.");
            return false;
        }
        return true;
    }

    public boolean importSharedData() {
        try {
            String file = this.params_.getValueParam("sharedData2.1").getValue();
            System.out.println("\n CS Shared data version 2.2 is importing.... ");
            Node sharedDataNode = this.getSharedDataRootNode();
            FileInputStream in = new FileInputStream(file.replace("file:", ""));
            Node root = sharedDataNode.getParent();
            sharedDataNode.remove();
            root.getSession().save();
            if (root != null) {
                root.getSession().importXML(root.getPath(), (InputStream)in, 0);
                root.getSession().save();
            }
        }
        catch (Exception e) {
            System.out.println("Cannot import CS Shared data." + e);
            return false;
        }
        return true;
    }
}

