/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class NewGroupListener
extends GroupEventListener {
    protected CalendarService calendarService_;
    private String defaultCalendarDescription;
    private String defaultLocale;
    private String defaultTimeZone;
    private String[] editPermission;
    private String[] viewPermission;

    public NewGroupListener(CalendarService calendarService, InitParams params) {
        this.calendarService_ = calendarService;
        if (params.getValueParam("defaultEditPermission") != null) {
            this.editPermission = params.getValueParam("defaultEditPermission").getValue().split(",");
        }
        if (params.getValueParam("defaultViewPermission") != null) {
            this.viewPermission = params.getValueParam("defaultViewPermission").getValue().split(",");
        }
        if (params.getValueParam("defaultCalendarDescription") != null) {
            this.defaultCalendarDescription = params.getValueParam("defaultCalendarDescription").getValue();
        }
        if (params.getValueParam("defaultLocale") != null) {
            this.defaultLocale = params.getValueParam("defaultLocale").getValue();
        }
        if (params.getValueParam("defaultTimeZone") != null) {
            this.defaultTimeZone = params.getValueParam("defaultTimeZone").getValue();
        }
    }

    public void postSave(Group group, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        String groupId = group.getId();
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        boolean isPublic = true;
        Calendar calendar = new Calendar();
        calendar.setName(group.getGroupName() + " calendar");
        if (this.defaultCalendarDescription != null) {
            calendar.setDescription(this.defaultCalendarDescription);
        }
        calendar.setGroups(new String[]{groupId});
        calendar.setPublic(isPublic);
        if (this.defaultLocale != null) {
            calendar.setLocale(this.defaultLocale);
        }
        if (this.defaultTimeZone != null) {
            calendar.setTimeZone(this.defaultTimeZone);
        }
        calendar.setCalendarColor(Calendar.SEASHELL);
        ArrayList<String> perms = new ArrayList<String>();
        for (String s : this.viewPermission) {
            if (perms.contains(s)) continue;
            perms.add(s);
        }
        calendar.setViewPermission(perms.toArray(new String[perms.size()]));
        perms.clear();
        for (String s : this.editPermission) {
            if (perms.contains(s)) continue;
            perms.add(s);
        }
        calendar.setEditPermission(perms.toArray(new String[perms.size()]));
        this.calendarService_.savePublicCalendar(sProvider, calendar, isNew, null);
    }
}

