/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.CalendarUpdateEventListener;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.impl.CsvImportExport;
import org.exoplatform.calendar.service.impl.ICalendarImportExport;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarServiceImpl
implements CalendarService,
Startable {
    public static final String ICALENDAR = "ICalendar(.ics)".intern();
    public static final String EXPORTEDCSV = "ExportedCsv(.csv)".intern();
    private RepositoryService repositorySerivce_;
    private JCRDataStorage storage_;
    private Map<String, CalendarImportExport> calendarImportExport_ = new LinkedHashMap<String, CalendarImportExport>();
    protected List<CalendarUpdateEventListener> listeners_ = new ArrayList<CalendarUpdateEventListener>(3);

    public CalendarServiceImpl(NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator);
        this.calendarImportExport_.put(ICALENDAR, new ICalendarImportExport(this.storage_));
        this.calendarImportExport_.put(EXPORTEDCSV, new CsvImportExport(this.storage_));
    }

    @Override
    public List<CalendarCategory> getCategories(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getCategories(sProvider, username);
    }

    @Override
    public List<GroupCalendarData> getCalendarCategories(SessionProvider sProvider, String username, boolean isShowAll) throws Exception {
        return this.storage_.getCalendarCategories(sProvider, username, isShowAll);
    }

    @Override
    public CalendarCategory getCalendarCategory(SessionProvider sProvider, String username, String calendarCategoryId) throws Exception {
        return this.storage_.getCalendarCategory(sProvider, username, calendarCategoryId);
    }

    @Override
    public void saveCalendarCategory(SessionProvider sProvider, String username, CalendarCategory calendarCategory, boolean isNew) throws Exception {
        this.storage_.saveCalendarCategory(sProvider, username, calendarCategory, isNew);
    }

    @Override
    public CalendarCategory removeCalendarCategory(SessionProvider sProvider, String username, String calendarCategoryId) throws Exception {
        return this.storage_.removeCalendarCategory(sProvider, username, calendarCategoryId);
    }

    @Override
    public Calendar getUserCalendar(SessionProvider sProvider, String username, String calendarId) throws Exception {
        return this.storage_.getUserCalendar(sProvider, username, calendarId);
    }

    @Override
    public List<Calendar> getUserCalendars(SessionProvider sProvider, String username, boolean isShowAll) throws Exception {
        return this.storage_.getUserCalendars(sProvider, username, isShowAll);
    }

    @Override
    public List<Calendar> getUserCalendarsByCategory(SessionProvider sProvider, String username, String calendarCategoryId) throws Exception {
        return this.storage_.getUserCalendarsByCategory(sProvider, username, calendarCategoryId);
    }

    @Override
    public void saveUserCalendar(SessionProvider sProvider, String username, Calendar calendar, boolean isNew) throws Exception {
        this.storage_.saveUserCalendar(sProvider, username, calendar, isNew);
    }

    @Override
    public Calendar removeUserCalendar(SessionProvider sProvider, String username, String calendarId) throws Exception {
        return this.storage_.removeUserCalendar(sProvider, username, calendarId);
    }

    @Override
    public Calendar getGroupCalendar(SessionProvider sProvider, String calendarId) throws Exception {
        return this.storage_.getGroupCalendar(sProvider, calendarId);
    }

    @Override
    public List<GroupCalendarData> getGroupCalendars(SessionProvider sProvider, String[] groupIds, boolean isShowAll, String username) throws Exception {
        return this.storage_.getGroupCalendars(sProvider, groupIds, isShowAll, username);
    }

    @Override
    public void savePublicCalendar(SessionProvider sProvider, Calendar calendar, boolean isNew, String username) throws Exception {
        this.storage_.savePublicCalendar(sProvider, calendar, isNew, username);
    }

    @Override
    public Calendar removePublicCalendar(SessionProvider sProvider, String calendarId) throws Exception {
        return this.storage_.removeGroupCalendar(sProvider, calendarId);
    }

    @Override
    public List<EventCategory> getEventCategories(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getEventCategories(sProvider, username);
    }

    @Override
    public void saveEventCategory(SessionProvider sProvider, String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        this.storage_.saveEventCategory(sProvider, username, eventCategory, values, isNew);
    }

    @Override
    public void removeEventCategory(SessionProvider sProvider, String username, String eventCategoryName) throws Exception {
        this.storage_.removeEventCategory(sProvider, username, eventCategoryName);
    }

    @Override
    public List<CalendarEvent> getUserEventByCalendar(SessionProvider sProvider, String username, List<String> calendarIds) throws Exception {
        return this.storage_.getUserEventByCalendar(sProvider, username, calendarIds);
    }

    @Override
    public List<CalendarEvent> getUserEvents(SessionProvider sProvider, String username, EventQuery eventQuery) throws Exception {
        return this.storage_.getUserEvents(sProvider, username, eventQuery);
    }

    @Override
    public void saveUserEvent(SessionProvider sProvider, String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveUserEvent(sProvider, username, calendarId, event, isNew);
    }

    @Override
    public CalendarEvent removeUserEvent(SessionProvider sProvider, String username, String calendarId, String eventId) throws Exception {
        return this.storage_.removeUserEvent(sProvider, username, calendarId, eventId);
    }

    @Override
    public CalendarEvent getGroupEvent(SessionProvider sProvider, String calendarId, String eventId) throws Exception {
        return this.storage_.getGroupEvent(sProvider, calendarId, eventId);
    }

    @Override
    public List<CalendarEvent> getGroupEventByCalendar(SessionProvider sProvider, List<String> calendarIds) throws Exception {
        return this.storage_.getGroupEventByCalendar(sProvider, calendarIds);
    }

    @Override
    public List<CalendarEvent> getPublicEvents(SessionProvider sProvider, EventQuery eventQuery) throws Exception {
        return this.storage_.getPublicEvents(sProvider, eventQuery);
    }

    @Override
    public void savePublicEvent(SessionProvider sProvider, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.savePublicEvent(sProvider, calendarId, event, isNew);
    }

    @Override
    public CalendarEvent removePublicEvent(SessionProvider sProvider, String calendarId, String eventId) throws Exception {
        return this.storage_.removePublicEvent(sProvider, calendarId, eventId);
    }

    @Override
    public CalendarImportExport getCalendarImportExports(String type) {
        return this.calendarImportExport_.get(type);
    }

    @Override
    public String[] getExportImportType() throws Exception {
        return this.calendarImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public void saveCalendarSetting(SessionProvider sProvider, String username, CalendarSetting setting) throws Exception {
        this.storage_.saveCalendarSetting(sProvider, username, setting);
    }

    @Override
    public CalendarSetting getCalendarSetting(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getCalendarSetting(sProvider, username);
    }

    @Override
    public int generateRss(SessionProvider sProvider, String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateRss(sProvider, username, calendarIds, rssData, this.calendarImportExport_.get(ICALENDAR));
    }

    @Override
    public int generateCalDav(SessionProvider sProvider, String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateCalDav(sProvider, username, calendarIds, rssData, this.calendarImportExport_.get(ICALENDAR));
    }

    @Override
    public List<FeedData> getFeeds(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getFeeds(sProvider, username);
    }

    @Override
    public Node getRssHome(SessionProvider sProvider, String username) throws Exception {
        return this.storage_.getRssHome(sProvider, username);
    }

    @Override
    public EventPageList searchEvent(SessionProvider sProvider, String username, EventQuery query, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchEvent(sProvider, username, query, publicCalendarIds);
    }

    @Override
    public EventCategory getEventCategory(SessionProvider sProvider, String username, String eventCategoryId) throws Exception {
        return this.storage_.getEventCategory(sProvider, username, eventCategoryId);
    }

    @Override
    public Map<Integer, String> searchHightLightEvent(SessionProvider sProvider, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchHightLightEvent(sProvider, username, eventQuery, publicCalendarIds);
    }

    @Override
    public void shareCalendar(SessionProvider sProvider, String username, String calendarId, List<String> receiverUsers) throws Exception {
        this.storage_.shareCalendar(sProvider, username, calendarId, receiverUsers);
    }

    @Override
    public GroupCalendarData getSharedCalendars(SessionProvider sProvider, String username, boolean isShowAll) throws Exception {
        return this.storage_.getSharedCalendars(sProvider, username, isShowAll);
    }

    @Override
    public List<CalendarEvent> getEvents(SessionProvider sProvider, String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.getEvents(sProvider, username, eventQuery, publicCalendarIds);
    }

    @Override
    public void removeSharedCalendar(SessionProvider sProvider, String username, String calendarId) throws Exception {
        this.storage_.removeSharedCalendar(sProvider, username, calendarId);
    }

    @Override
    public void saveEventToSharedCalendar(SessionProvider sProvider, String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveEventToSharedCalendar(sProvider, username, calendarId, event, isNew);
    }

    @Override
    public Map<String, String> checkFreeBusy(SessionProvider sysProvider, EventQuery eventQuery) throws Exception {
        return this.storage_.checkFreeBusy(sysProvider, eventQuery);
    }

    @Override
    public void saveSharedCalendar(SessionProvider sProvider, String username, Calendar calendar) throws Exception {
        this.storage_.saveSharedCalendar(sProvider, username, calendar);
    }

    @Override
    public void removeSharedEvent(SessionProvider sessionProvider, String username, String calendarId, String eventId) throws Exception {
        this.storage_.removeSharedEvent(sessionProvider, username, calendarId, eventId);
    }

    @Override
    public void moveEvent(SessionProvider sProvider, String formCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        this.storage_.moveEvent(sProvider, formCalendar, toCalendar, fromType, toType, calEvents, username);
    }

    @Override
    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) throws Exception {
        this.storage_.confirmInvitation(fromUserId, toUserId, calType, calendarId, eventId, answer);
    }

    public void start() {
        for (CalendarUpdateEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof CalendarUpdateEventListener) {
            this.listeners_.add((CalendarUpdateEventListener)listener);
        }
    }
}

