/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Completed;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Repeat;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalendarImportExport
implements CalendarImportExport {
    private static final String PRIVATE_TYPE = String.valueOf(0);
    private static final String SHARED_TYPE = String.valueOf(1);
    private static final String PUBLIC_TYPE = String.valueOf(2);
    private JCRDataStorage storage_;

    public ICalendarImportExport(JCRDataStorage storage) throws Exception {
        this.storage_ = storage;
    }

    private net.fortuna.ical4j.model.Calendar getVEvent(net.fortuna.ical4j.model.Calendar calendar, CalendarEvent exoEvent) throws Exception {
        VEvent event;
        Uid id = new Uid(exoEvent.getId());
        long start = exoEvent.getFromDateTime().getTime();
        long end = exoEvent.getToDateTime().getTime();
        String summary = exoEvent.getSummary();
        if (end > 0L) {
            event = new VEvent((Date)new DateTime(start), (Date)new DateTime(end), summary);
            event.getProperties().getProperty("DTEND").getParameters().add((Parameter)Value.DATE_TIME);
        } else {
            event = new VEvent((Date)new DateTime(start), summary);
        }
        event.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
        event.getProperties().add((Property)new Description(exoEvent.getDescription()));
        event.getProperties().getProperty("DESCRIPTION").getParameters().add((Parameter)Value.TEXT);
        event.getProperties().add((Property)new Location(exoEvent.getLocation()));
        event.getProperties().getProperty("LOCATION").getParameters().add((Parameter)Value.TEXT);
        if (exoEvent.getEventCategoryName() != null) {
            event.getProperties().add((Property)new Categories(exoEvent.getEventCategoryName()));
            event.getProperties().getProperty("CATEGORIES").getParameters().add((Parameter)Value.TEXT);
        }
        if (exoEvent.getPriority() != null) {
            for (int i = 0; i < CalendarEvent.PRIORITY.length; ++i) {
                if (!exoEvent.getPriority().equalsIgnoreCase(CalendarEvent.PRIORITY[i])) continue;
                event.getProperties().add((Property)new Priority(i));
                event.getProperties().getProperty("PRIORITY").getParameters().add((Parameter)Value.INTEGER);
                break;
            }
        }
        if (!exoEvent.getAttachment().isEmpty()) {
            for (Attachment att : exoEvent.getAttachment()) {
                byte[] bytes = new byte[att.getInputStream().available()];
                att.getInputStream().read(bytes);
                ParameterList plist = new ParameterList();
                plist.add((Parameter)new XParameter("CN", att.getName()));
                plist.add((Parameter)new XParameter("FMTTYPE", att.getMimeType()));
                plist.add((Parameter)Encoding.BASE64);
                plist.add((Parameter)Value.BINARY);
                Attach attach = new Attach(plist, bytes);
                event.getProperties().add((Property)attach);
            }
        }
        if (!exoEvent.getReminders().isEmpty()) {
            for (Reminder r : exoEvent.getReminders()) {
                Attendee a;
                VAlarm reminder = new VAlarm(new DateTime(r.getFromDateTime()));
                Long times = new Long(1L);
                if (r.isRepeat()) {
                    times = r.getAlarmBefore() / r.getRepeatInterval();
                }
                reminder.getProperties().add((Property)new Repeat(times.intValue()));
                reminder.getProperties().add((Property)new Duration(new Dur(new Long(r.getAlarmBefore()).intValue())));
                if (Reminder.TYPE_POPUP.equals(r.getReminderType())) {
                    for (String n : r.getReminderOwner().split(Utils.COMMA)) {
                        a = new Attendee(n);
                        reminder.getProperties().add((Property)a);
                    }
                    reminder.getProperties().add((Property)Action.DISPLAY);
                } else {
                    for (String m : r.getEmailAddress().split(Utils.COMMA)) {
                        a = new Attendee(m);
                        reminder.getProperties().add((Property)a);
                    }
                    reminder.getProperties().add((Property)Action.EMAIL);
                }
                reminder.getProperties().add((Property)new Summary(exoEvent.getSummary()));
                reminder.getProperties().add((Property)new Description(r.getDescription()));
                reminder.getProperties().add((Property)id);
                calendar.getComponents().add((Component)reminder);
            }
        }
        if (exoEvent.isPrivate()) {
            event.getProperties().add((Property)new Clazz(Clazz.PRIVATE.getValue()));
        } else {
            event.getProperties().add((Property)new Clazz(Clazz.PUBLIC.getValue()));
        }
        event.getProperties().getProperty("CLASS").getParameters().add((Parameter)Value.TEXT);
        String[] attendees = exoEvent.getInvitation();
        if (attendees != null && attendees.length > 0) {
            for (int i = 0; i < attendees.length; ++i) {
                if (attendees[i] == null) continue;
                event.getProperties().add((Property)new Attendee(attendees[i]));
            }
            event.getProperties().getProperty("ATTENDEE").getParameters().add((Parameter)Value.TEXT);
        }
        if (!Utils.isEmpty(exoEvent.getRepeatType())) {
            Recur rc = null;
            if (!CalendarEvent.RP_NOREPEAT.equalsIgnoreCase(exoEvent.getRepeatType())) {
                if (CalendarEvent.RP_WEEKEND.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.SU);
                    rc.getDayList().add(WeekDay.SA);
                    rc.setInterval(1);
                } else if (CalendarEvent.RP_WORKINGDAYS.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.MO);
                    rc.getDayList().add(WeekDay.TU);
                    rc.getDayList().add(WeekDay.WE);
                    rc.getDayList().add(WeekDay.TH);
                    rc.getDayList().add(WeekDay.FR);
                    rc.setInterval(1);
                } else if (CalendarEvent.RP_WEEKLY.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.SU);
                    rc.getDayList().add(WeekDay.MO);
                    rc.getDayList().add(WeekDay.TU);
                    rc.getDayList().add(WeekDay.WE);
                    rc.getDayList().add(WeekDay.TH);
                    rc.getDayList().add(WeekDay.FR);
                    rc.getDayList().add(WeekDay.SA);
                    rc.setInterval(1);
                } else {
                    rc = new Recur(exoEvent.getRepeatType().toUpperCase(), 1);
                    rc.setInterval(1);
                }
            }
            if (rc != null) {
                rc.setWeekStartDay(WeekDay.SU.getDay());
                RRule r = new RRule(rc);
                event.getProperties().add((Property)r);
            }
        }
        event.getProperties().add((Property)id);
        calendar.getComponents().add((Component)event);
        return calendar;
    }

    private net.fortuna.ical4j.model.Calendar getVTask(net.fortuna.ical4j.model.Calendar calendar, CalendarEvent exoEvent) throws Exception {
        VToDo event;
        Uid id = new Uid(exoEvent.getId());
        long start = exoEvent.getFromDateTime().getTime();
        long end = exoEvent.getToDateTime().getTime();
        String summary = exoEvent.getSummary();
        if (end > 0L) {
            event = new VToDo((Date)new DateTime(start), (Date)new DateTime(end), summary);
            if (event.getProperties().getProperty("DTEND") != null) {
                event.getProperties().getProperty("DTEND").getParameters().add((Parameter)Value.DATE_TIME);
            }
        } else {
            event = new VToDo((Date)new DateTime(start), summary);
        }
        event.getProperties().getProperty("DTSTART").getParameters().add((Parameter)Value.DATE_TIME);
        event.getProperties().add((Property)new Description(exoEvent.getDescription()));
        event.getProperties().getProperty("DESCRIPTION").getParameters().add((Parameter)Value.TEXT);
        event.getProperties().add((Property)new Location(exoEvent.getLocation()));
        event.getProperties().getProperty("LOCATION").getParameters().add((Parameter)Value.TEXT);
        if (exoEvent.getEventCategoryName() != null) {
            event.getProperties().add((Property)new Categories(exoEvent.getEventCategoryName()));
            event.getProperties().getProperty("CATEGORIES").getParameters().add((Parameter)Value.TEXT);
        }
        if (exoEvent.getPriority() != null) {
            for (int i = 0; i < CalendarEvent.PRIORITY.length; ++i) {
                if (!exoEvent.getPriority().equalsIgnoreCase(CalendarEvent.PRIORITY[i])) continue;
                event.getProperties().add((Property)new Priority(i));
                event.getProperties().getProperty("PRIORITY").getParameters().add((Parameter)Value.INTEGER);
                break;
            }
        }
        if (exoEvent.getCompletedDateTime() != null) {
            long completed = exoEvent.getCompletedDateTime().getTime();
            event.getProperties().add((Property)new Completed(new DateTime(completed)));
            event.getProperties().getProperty("COMPLETED").getParameters().add((Parameter)Value.DATE_TIME);
        }
        event.getProperties().add((Property)new Due((Date)new DateTime(end)));
        event.getProperties().getProperty("DUE").getParameters().add((Parameter)Value.DATE_TIME);
        if (!Utils.isEmpty(exoEvent.getStatus())) {
            event.getProperties().add((Property)new Status(exoEvent.getStatus()));
            event.getProperties().getProperty("STATUS").getParameters().add((Parameter)Value.TEXT);
        }
        if (!exoEvent.getAttachment().isEmpty()) {
            for (Attachment att : exoEvent.getAttachment()) {
                byte[] bytes = new byte[att.getInputStream().available()];
                att.getInputStream().read(bytes);
                ParameterList plist = new ParameterList();
                plist.add((Parameter)new XParameter("CN", att.getName()));
                plist.add((Parameter)new XParameter("FMTTYPE", att.getMimeType()));
                plist.add((Parameter)Encoding.BASE64);
                plist.add((Parameter)Value.BINARY);
                Attach attach = new Attach(plist, bytes);
                event.getProperties().add((Property)attach);
            }
        }
        if (!exoEvent.getReminders().isEmpty()) {
            for (Reminder r : exoEvent.getReminders()) {
                Attendee a;
                VAlarm reminder = new VAlarm(new DateTime(r.getFromDateTime()));
                Long times = new Long(1L);
                if (r.isRepeat()) {
                    times = r.getAlarmBefore() / r.getRepeatInterval();
                }
                reminder.getProperties().add((Property)new Repeat(times.intValue()));
                reminder.getProperties().add((Property)new Duration(new Dur(new Long(r.getAlarmBefore()).intValue())));
                if (Reminder.TYPE_POPUP.equals(r.getReminderType())) {
                    for (String n : r.getReminderOwner().split(Utils.COMMA)) {
                        a = new Attendee(n);
                        reminder.getProperties().add((Property)a);
                    }
                    reminder.getProperties().add((Property)Action.DISPLAY);
                } else {
                    for (String m : r.getEmailAddress().split(Utils.COMMA)) {
                        a = new Attendee(m);
                        reminder.getProperties().add((Property)a);
                    }
                    reminder.getProperties().add((Property)Action.EMAIL);
                }
                reminder.getProperties().add((Property)new Summary(exoEvent.getSummary()));
                reminder.getProperties().add((Property)new Description(r.getDescription()));
                reminder.getProperties().add((Property)id);
                calendar.getComponents().add((Component)reminder);
            }
        }
        if (exoEvent.isPrivate()) {
            event.getProperties().add((Property)new Clazz(Clazz.PRIVATE.getValue()));
        } else {
            event.getProperties().add((Property)new Clazz(Clazz.PUBLIC.getValue()));
        }
        event.getProperties().getProperty("CLASS").getParameters().add((Parameter)Value.TEXT);
        String[] attendees = exoEvent.getInvitation();
        if (attendees != null && attendees.length > 0) {
            for (int i = 0; i < attendees.length; ++i) {
                if (attendees[i] == null) continue;
                event.getProperties().add((Property)new Attendee(attendees[i]));
            }
            event.getProperties().getProperty("ATTENDEE").getParameters().add((Parameter)Value.TEXT);
        }
        if (!Utils.isEmpty(exoEvent.getRepeatType())) {
            Recur rc = null;
            if (!CalendarEvent.RP_NOREPEAT.equalsIgnoreCase(exoEvent.getRepeatType())) {
                if (CalendarEvent.RP_WEEKEND.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.SU);
                    rc.getDayList().add(WeekDay.SA);
                    rc.setInterval(1);
                } else if (CalendarEvent.RP_WORKINGDAYS.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.MO);
                    rc.getDayList().add(WeekDay.TU);
                    rc.getDayList().add(WeekDay.WE);
                    rc.getDayList().add(WeekDay.TH);
                    rc.getDayList().add(WeekDay.FR);
                    rc.setInterval(1);
                } else if (CalendarEvent.RP_WEEKLY.equalsIgnoreCase(exoEvent.getRepeatType())) {
                    rc = new Recur("WEEKLY", 1);
                    rc.getDayList().add(WeekDay.SU);
                    rc.getDayList().add(WeekDay.MO);
                    rc.getDayList().add(WeekDay.TU);
                    rc.getDayList().add(WeekDay.WE);
                    rc.getDayList().add(WeekDay.TH);
                    rc.getDayList().add(WeekDay.FR);
                    rc.getDayList().add(WeekDay.SA);
                    rc.setInterval(1);
                } else {
                    rc = new Recur(exoEvent.getRepeatType().toUpperCase(), 1);
                    rc.setInterval(1);
                }
            }
            if (rc != null) {
                rc.setWeekStartDay(WeekDay.SU.getDay());
                RRule r = new RRule(rc);
                event.getProperties().add((Property)r);
            }
        }
        event.getProperties().add((Property)id);
        calendar.getComponents().add((Component)event);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream exportCalendar(SessionProvider sProvider, String username, List<String> calendarIds, String type) throws Exception {
        List<Object> events = new ArrayList();
        SessionProvider systemSession = SessionProvider.createSystemProvider();
        if (type.equals(PRIVATE_TYPE)) {
            events = this.storage_.getUserEventByCalendar(sProvider, username, calendarIds);
        } else if (type.equals(SHARED_TYPE)) {
            events = this.storage_.getSharedEventByCalendars(systemSession, username, calendarIds);
        } else if (type.equals(PUBLIC_TYPE)) {
            events = this.storage_.getGroupEventByCalendar(systemSession, calendarIds);
        }
        if (events.isEmpty()) {
            return null;
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        for (CalendarEvent calendarEvent : events) {
            if (calendarEvent.getEventType().equals(CalendarEvent.TYPE_EVENT)) {
                calendar = this.getVEvent(calendar, calendarEvent);
                continue;
            }
            calendar = this.getVTask(calendar, calendarEvent);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter calendarOutputter = new CalendarOutputter();
        try {
            calendarOutputter.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            OutputStream outputStream = null;
            return outputStream;
        }
        finally {
            systemSession.close();
        }
        return bout;
    }

    @Override
    public OutputStream exportEventCalendar(SessionProvider sProvider, String username, String calendarId, String type, String eventId) throws Exception {
        List<Object> events = new ArrayList();
        List<String> calendarIds = Arrays.asList(calendarId);
        if (type.equals(PRIVATE_TYPE)) {
            events = this.storage_.getUserEventByCalendar(sProvider, username, calendarIds);
        } else if (type.equals(SHARED_TYPE)) {
            events = this.storage_.getSharedEventByCalendars(sProvider, username, calendarIds);
        } else if (type.equals(PUBLIC_TYPE)) {
            events = this.storage_.getGroupEventByCalendar(sProvider, calendarIds);
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        for (CalendarEvent calendarEvent : events) {
            if (!calendarEvent.getId().equals(eventId)) continue;
            if (calendarEvent.getEventType().equals(CalendarEvent.TYPE_EVENT)) {
                calendar = this.getVEvent(calendar, calendarEvent);
                break;
            }
            calendar = this.getVTask(calendar, calendarEvent);
            break;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter calendarOutputter = new CalendarOutputter();
        try {
            calendarOutputter.output(calendar, (OutputStream)bout);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            return null;
        }
        return bout;
    }

    @Override
    public void importCalendar(SessionProvider sProvider, String username, InputStream icalInputStream, String calendarName) throws Exception {
        String categoryId;
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(icalInputStream);
        NodeIterator iter = this.storage_.getCalendarCategoryHome(sProvider, username).getNodes();
        Node cat = null;
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        boolean isExists = false;
        while (iter.hasNext()) {
            cat = iter.nextNode();
            if (!cat.getProperty(Utils.EXO_NAME).getString().equals("Imported")) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            CalendarCategory calendarCate = new CalendarCategory();
            calendarCate.setDescription("Imported icalendar category");
            calendarCate.setName("Imported");
            categoryId = calendarCate.getId();
            this.storage_.saveCalendarCategory(sProvider, username, calendarCate, true);
        } else {
            categoryId = cat.getProperty(Utils.EXO_ID).getString();
        }
        Calendar exoCalendar = new Calendar();
        exoCalendar.setName(calendarName);
        exoCalendar.setCalendarColor(Calendar.COLORS[new Random().nextInt(Calendar.COLORS.length - 1)]);
        exoCalendar.setDescription(iCalendar.getProductId().getValue());
        exoCalendar.setCategoryId(categoryId);
        exoCalendar.setPublic(false);
        exoCalendar.setCalendarOwner(username);
        this.storage_.saveUserCalendar(sProvider, username, exoCalendar, true);
        ComponentList componentList = iCalendar.getComponents();
        for (Object obj : componentList) {
            VEvent v;
            if (obj instanceof VEvent && !(v = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : v.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(v.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            ByteArrayInputStream in;
            Attachment att;
            Attach a;
            PropertyList dataList;
            String[] invitation;
            PropertyList attendees;
            EventCategory evCate;
            CalendarEvent exoEvent;
            VEvent event;
            if (obj instanceof VEvent) {
                event = (VEvent)obj;
                exoEvent = new CalendarEvent();
                if (event.getProperty("CATEGORIES") != null) {
                    evCate = new EventCategory();
                    evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                    try {
                        this.storage_.saveEventCategory(sProvider, username, evCate, null, true);
                    }
                    catch (Exception e) {
                        for (EventCategory ev : this.storage_.getEventCategories(sProvider, username)) {
                            if (!ev.getName().equalsIgnoreCase(evCate.getName())) continue;
                            evCate = ev;
                            break;
                        }
                        System.out.println("\n\n event category " + evCate.getName() + " existed !");
                    }
                    exoEvent.setEventCategoryId(evCate.getId());
                    exoEvent.setEventCategoryName(evCate.getName());
                }
                exoEvent.setCalType(String.valueOf(0));
                exoEvent.setCalendarId(exoCalendar.getId());
                if (event.getSummary() != null) {
                    exoEvent.setSummary(event.getSummary().getValue());
                }
                if (event.getDescription() != null) {
                    exoEvent.setDescription(event.getDescription().getValue());
                }
                if (event.getStatus() != null) {
                    exoEvent.setStatus(event.getStatus().getValue());
                }
                exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
                if (event.getStartDate() != null) {
                    exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
                }
                if (event.getEndDate() != null) {
                    exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
                }
                if (event.getLocation() != null) {
                    exoEvent.setLocation(event.getLocation().getValue());
                }
                if (event.getPriority() != null) {
                    exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                }
                if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                    exoEvent.setStatus(CalendarEvent.ST_BUSY);
                }
                if (event.getClassification() != null) {
                    exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
                }
                if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                    invitation = new String[attendees.size()];
                    for (int i = 0; i < attendees.size(); ++i) {
                        invitation[i] = ((Attendee)attendees.get(i)).getValue();
                    }
                    exoEvent.setInvitation(invitation);
                }
                try {
                    dataList = event.getProperties("ATTACH");
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    for (Object o : dataList) {
                        a = (Attach)o;
                        att = new Attachment();
                        att.setName(a.getParameter("CN").getValue());
                        att.setMimeType(a.getParameter("FMTTYPE").getValue());
                        in = new ByteArrayInputStream(a.getBinary());
                        att.setSize(((InputStream)in).available());
                        att.setInputStream(in);
                        attachments.add(att);
                    }
                    if (!attachments.isEmpty()) {
                        exoEvent.setAttachment(attachments);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.storage_.saveUserEvent(sProvider, username, exoCalendar.getId(), exoEvent, true);
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            if (event.getProperty("CATEGORIES") != null) {
                evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                try {
                    this.storage_.saveEventCategory(sProvider, username, evCate, null, true);
                }
                catch (Exception e) {
                    for (EventCategory ev : this.storage_.getEventCategories(sProvider, username)) {
                        if (!ev.getName().equalsIgnoreCase(evCate.getName())) continue;
                        evCate = ev;
                        break;
                    }
                    System.out.println("\n\n event category " + evCate.getName() + " existed !");
                }
                exoEvent.setEventCategoryId(evCate.getId());
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalType(String.valueOf(0));
            exoEvent.setCalendarId(exoCalendar.getId());
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
            }
            if (event.getDue() != null) {
                exoEvent.setToDateTime((java.util.Date)event.getDue().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
            }
            if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                exoEvent.setStatus(CalendarEvent.ST_BUSY);
            }
            if (event.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
            }
            if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                dataList = event.getProperties("ATTACH");
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Object o : dataList) {
                    a = (Attach)o;
                    att = new Attachment();
                    att.setName(a.getParameter("CN").getValue());
                    att.setMimeType(a.getParameter("FMTTYPE").getValue());
                    in = new ByteArrayInputStream(a.getBinary());
                    att.setSize(((InputStream)in).available());
                    att.setInputStream(in);
                    attachments.add(att);
                }
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.storage_.saveUserEvent(sProvider, username, exoCalendar.getId(), exoEvent, true);
        }
    }

    @Override
    public List<CalendarEvent> getEventObjects(InputStream icalInputStream) throws Exception {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(icalInputStream);
        ComponentList componentList = iCalendar.getComponents();
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        for (Object obj : componentList) {
            if (!(obj instanceof VEvent)) continue;
            CalendarEvent exoEvent = new CalendarEvent();
            VEvent event = (VEvent)obj;
            if (event.getProperty("UID") != null) {
                exoEvent.setId(event.getProperty("UID").getValue());
            }
            if (event.getProperty("CATEGORIES") != null) {
                exoEvent.setEventCategoryName(event.getProperty("CATEGORIES").getValue().trim());
            }
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
            }
            if (event.getEndDate() != null) {
                exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                try {
                    exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                RRule r = (RRule)event.getProperty("RRULE");
                if (r != null && r.getRecur() != null) {
                    Recur rc = r.getRecur();
                    rc.getFrequency();
                    if ("WEEKLY".equalsIgnoreCase(rc.getFrequency())) {
                        if (rc.getDayList().size() == 2) {
                            exoEvent.setRepeatType(CalendarEvent.RP_WEEKEND);
                        } else if (rc.getDayList().size() == 5) {
                            exoEvent.setRepeatType(CalendarEvent.RP_WORKINGDAYS);
                        }
                        if (rc.getDayList().size() == 7) {
                            exoEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
                        }
                    } else {
                        exoEvent.setRepeatType(rc.getFrequency().toLowerCase());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            exoEvent.setPrivate(true);
            PropertyList attendees = event.getProperties("ATTENDEE");
            if (attendees.size() < 1) {
                exoEvent.setInvitation(new String[0]);
            } else {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            eventList.add(exoEvent);
        }
        return eventList;
    }

    @Override
    public void importToCalendar(SessionProvider sProvider, String username, InputStream icalInputStream, String calendarId) throws Exception {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        net.fortuna.ical4j.model.Calendar iCalendar = calendarBuilder.build(icalInputStream);
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        ComponentList componentList = iCalendar.getComponents();
        for (Object obj : componentList) {
            VEvent v;
            if (obj instanceof VEvent && !(v = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : v.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(v.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            ByteArrayInputStream in;
            Attachment att;
            Attach a;
            PropertyList dataList;
            RRule r;
            String[] invitation;
            PropertyList attendees;
            EventCategory evCate;
            CalendarEvent exoEvent;
            VEvent event;
            if (obj instanceof VEvent) {
                event = (VEvent)obj;
                exoEvent = new CalendarEvent();
                if (event.getProperty("CATEGORIES") != null) {
                    evCate = new EventCategory();
                    evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                    try {
                        this.storage_.saveEventCategory(sProvider, username, evCate, null, true);
                    }
                    catch (Exception e) {
                        for (EventCategory ev : this.storage_.getEventCategories(sProvider, username)) {
                            if (!ev.getName().equalsIgnoreCase(evCate.getName())) continue;
                            evCate = ev;
                            break;
                        }
                        System.out.println("\n\n event category " + evCate.getName() + " existed !");
                    }
                    exoEvent.setEventCategoryId(evCate.getId());
                    exoEvent.setEventCategoryName(evCate.getName());
                }
                exoEvent.setCalType(String.valueOf(0));
                exoEvent.setCalendarId(calendarId);
                if (event.getSummary() != null) {
                    exoEvent.setSummary(event.getSummary().getValue());
                }
                if (event.getDescription() != null) {
                    exoEvent.setDescription(event.getDescription().getValue());
                }
                if (event.getStatus() != null) {
                    exoEvent.setStatus(event.getStatus().getValue());
                }
                exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
                if (event.getStartDate() != null) {
                    exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
                }
                if (event.getEndDate() != null) {
                    exoEvent.setToDateTime((java.util.Date)event.getEndDate().getDate());
                }
                if (event.getLocation() != null) {
                    exoEvent.setLocation(event.getLocation().getValue());
                }
                if (event.getPriority() != null) {
                    exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                }
                if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                    exoEvent.setStatus(CalendarEvent.ST_BUSY);
                }
                if (event.getClassification() != null) {
                    exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
                }
                if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                    invitation = new String[attendees.size()];
                    for (int i = 0; i < attendees.size(); ++i) {
                        invitation[i] = ((Attendee)attendees.get(i)).getValue();
                    }
                    exoEvent.setInvitation(invitation);
                }
                try {
                    r = (RRule)event.getProperty("RRULE");
                    if (r != null && r.getRecur() != null) {
                        Recur rc = r.getRecur();
                        rc.getFrequency();
                        if ("WEEKLY".equalsIgnoreCase(rc.getFrequency())) {
                            if (rc.getDayList().size() == 2) {
                                exoEvent.setRepeatType(CalendarEvent.RP_WEEKEND);
                            } else if (rc.getDayList().size() == 5) {
                                exoEvent.setRepeatType(CalendarEvent.RP_WORKINGDAYS);
                            }
                            if (rc.getDayList().size() == 7) {
                                exoEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
                            }
                        } else {
                            exoEvent.setRepeatType(rc.getFrequency().toLowerCase());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    dataList = event.getProperties("ATTACH");
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    for (Object o : dataList) {
                        a = (Attach)o;
                        att = new Attachment();
                        att.setName(a.getParameter("CN").getValue());
                        att.setMimeType(a.getParameter("FMTTYPE").getValue());
                        in = new ByteArrayInputStream(a.getBinary());
                        att.setSize(((InputStream)in).available());
                        att.setInputStream(in);
                        attachments.add(att);
                    }
                    if (!attachments.isEmpty()) {
                        exoEvent.setAttachment(attachments);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.storage_.saveUserEvent(sProvider, username, calendarId, exoEvent, true);
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            if (event.getProperty("CATEGORIES") != null) {
                evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                try {
                    this.storage_.saveEventCategory(sProvider, username, evCate, null, true);
                }
                catch (Exception e) {
                    for (EventCategory ev : this.storage_.getEventCategories(sProvider, username)) {
                        if (!ev.getName().equalsIgnoreCase(evCate.getName())) continue;
                        evCate = ev;
                        break;
                    }
                    System.out.println("\n\n event category " + evCate.getName() + " existed !");
                }
                exoEvent.setEventCategoryId(evCate.getId());
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalType(String.valueOf(0));
            exoEvent.setCalendarId(calendarId);
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((java.util.Date)event.getStartDate().getDate());
            }
            if (event.getDue() != null) {
                exoEvent.setToDateTime((java.util.Date)event.getDue().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
            }
            if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                exoEvent.setStatus(CalendarEvent.ST_BUSY);
            }
            if (event.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
            }
            if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                r = (RRule)event.getProperty("RRULE");
                if (r != null && r.getRecur() != null) {
                    Recur rc = r.getRecur();
                    rc.getFrequency();
                    if ("WEEKLY".equalsIgnoreCase(rc.getFrequency())) {
                        if (rc.getDayList().size() == 2) {
                            exoEvent.setRepeatType(CalendarEvent.RP_WEEKEND);
                        } else if (rc.getDayList().size() == 5) {
                            exoEvent.setRepeatType(CalendarEvent.RP_WORKINGDAYS);
                        }
                        if (rc.getDayList().size() == 7) {
                            exoEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
                        }
                    } else {
                        exoEvent.setRepeatType(rc.getFrequency().toLowerCase());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dataList = event.getProperties("ATTACH");
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Object o : dataList) {
                    a = (Attach)o;
                    att = new Attachment();
                    att.setName(a.getParameter("CN").getValue());
                    att.setMimeType(a.getParameter("FMTTYPE").getValue());
                    in = new ByteArrayInputStream(a.getBinary());
                    att.setSize(((InputStream)in).available());
                    att.setInputStream(in);
                    attachments.add(att);
                }
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.storage_.saveUserEvent(sProvider, username, calendarId, exoEvent, true);
        }
    }

    @Override
    public boolean isValidate(InputStream icalInputStream) throws Exception {
        try {
            CalendarBuilder calendarBuilder = new CalendarBuilder();
            calendarBuilder.build(icalInputStream);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

