/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarUpdateEventListener;
import org.exoplatform.calendar.service.CsNodeTypeMapping;
import org.exoplatform.calendar.service.CsObjectParam;
import org.exoplatform.calendar.service.CsPropertyMapping;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class UpdateCalendarVersion
extends CalendarUpdateEventListener {
    private CalendarService cservice_;
    private RepositoryService repositorySerivce_;
    CsObjectParam csObj_;

    public UpdateCalendarVersion(CalendarService cservice, InitParams params, RepositoryService repositorySerivce) throws Exception {
        this.cservice_ = cservice;
        this.repositorySerivce_ = repositorySerivce;
        this.csObj_ = (CsObjectParam)params.getObjectParam("cs.calendar.update.object").getObject();
    }

    public void preUpdate() {
        if (this.csObj_ != null) {
            try {
                SessionProvider sessionProvider = SessionProvider.createSystemProvider();
                String wsName = this.repositorySerivce_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
                Session session = sessionProvider.getSession(wsName, this.repositorySerivce_.getCurrentRepository());
                QueryManager qm = session.getWorkspace().getQueryManager();
                for (CsNodeTypeMapping nt : this.csObj_.getNodeTypes()) {
                    PropertyDefinition pDef;
                    Query query;
                    StringBuffer sql;
                    ExtendedNodeType nodeType = (ExtendedNodeType)this.repositorySerivce_.getCurrentRepository().getNodeTypeManager().getNodeType(nt.getNodeTypeName());
                    if (nt.getAddedProperties() != null && nt.getAddedProperties().size() > 0) {
                        sql = new StringBuffer("/jcr:root //element(*," + nodeType.getName() + ")");
                        System.out.println("\n\n The query ---------------------- " + sql);
                        query = qm.createQuery(sql.toString(), "xpath");
                        for (CsPropertyMapping addedProperty : nt.getAddedProperties()) {
                            try {
                                NodeIterator it;
                                QueryResult result;
                                pDef = nodeType.getPropertyDefinitions(addedProperty.getPropertyName()).getAnyDefinition();
                                if (pDef == null) continue;
                                String value = null;
                                Value[] vls = pDef.getDefaultValues();
                                if (!pDef.isAutoCreated() && !pDef.isMandatory()) continue;
                                if (vls != null && vls.length > 0) {
                                    result = query.execute();
                                    it = result.getNodes();
                                    this.setValue(pDef.getRequiredType(), it, addedProperty.getPropertyName(), vls);
                                    continue;
                                }
                                if (pDef.isMandatory()) {
                                    if (addedProperty.getDefaultValue() == null || addedProperty.getDefaultValue().trim().length() <= 0) continue;
                                    value = addedProperty.getDefaultValue();
                                    result = query.execute();
                                    it = result.getNodes();
                                    this.setValue(pDef.getRequiredType(), pDef.isMultiple(), it, addedProperty.getPropertyName(), value);
                                    continue;
                                }
                                value = addedProperty.getDefaultValue();
                                result = query.execute();
                                it = result.getNodes();
                                this.setValue(pDef.getRequiredType(), pDef.isMultiple(), it, addedProperty.getPropertyName(), value);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (nt.getRemovedProperties() != null && nt.getRemovedProperties().size() > 0) {
                        sql = new StringBuffer("/jcr:root //element(*," + nodeType.getName() + ")");
                        System.out.println("\n\n The query ---------------------- " + sql);
                        query = qm.createQuery(sql.toString(), "xpath");
                        for (CsPropertyMapping removed : nt.getAddedProperties()) {
                            try {
                                pDef = nodeType.getPropertyDefinitions(removed.getPropertyName()).getAnyDefinition();
                                if (pDef == null) continue;
                                QueryResult result = query.execute();
                                NodeIterator it = result.getNodes();
                                while (it.hasNext()) {
                                    Node node = it.nextNode();
                                    node.getProperty(removed.getPropertyName()).remove();
                                    node.save();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (nt.getUpdatedProperties() == null || nt.getUpdatedProperties().size() <= 0) continue;
                    sql = new StringBuffer("/jcr:root //element(*," + nodeType.getName() + ")");
                    System.out.println("\n\n The query ---------------------- " + sql);
                    query = qm.createQuery(sql.toString(), "xpath");
                    QueryResult result = query.execute();
                    NodeIterator it = result.getNodes();
                    for (CsPropertyMapping updated : nt.getAddedProperties()) {
                        try {
                            PropertyDefinition pDef2 = nodeType.getPropertyDefinitions(updated.getPropertyName()).getAnyDefinition();
                            if (pDef2 == null) continue;
                            this.updateValue(pDef2.getRequiredType(), pDef2.isMultiple(), it, updated.getPropertyName(), updated.getReplaceName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setValue(int propertyType, boolean isMultiple, NodeIterator it, String proName, String value) throws Exception {
        while (it.hasNext()) {
            Node node = it.nextNode();
            ValueFactory vf = node.getSession().getValueFactory();
            switch (propertyType) {
                case 1: {
                    if (isMultiple) {
                        node.setProperty(proName, value.split(","));
                        break;
                    }
                    node.setProperty(proName, value);
                    break;
                }
                case 6: {
                    Value[] values;
                    String[] strings;
                    if (isMultiple) {
                        strings = value.split(",");
                        values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            values[i] = vf.createValue(Boolean.parseBoolean(strings[i]));
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    node.setProperty(proName, Boolean.parseBoolean(value));
                    break;
                }
                case 3: {
                    Value[] values;
                    String[] strings;
                    if (isMultiple) {
                        strings = value.split(",");
                        values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            values[i] = vf.createValue(Long.parseLong(strings[i]));
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    node.setProperty(proName, Long.parseLong(value));
                    break;
                }
                case 4: {
                    Value[] values;
                    String[] strings;
                    if (isMultiple) {
                        strings = value.split(",");
                        values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            values[i] = vf.createValue(Double.parseDouble(strings[i]));
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    node.setProperty(proName, Double.parseDouble(value));
                    break;
                }
                case 5: {
                    SimpleDateFormat df = new SimpleDateFormat();
                    Calendar cal = Calendar.getInstance();
                    if (isMultiple) {
                        String[] strings = value.split(",");
                        Value[] values = new Value[strings.length];
                        for (int i = 0; i < strings.length; ++i) {
                            cal.setTime(df.parse(value));
                            values[i] = vf.createValue(cal);
                        }
                        node.setProperty(proName, values);
                        break;
                    }
                    cal.setTime(df.parse(value));
                    node.setProperty(proName, cal);
                    break;
                }
            }
            node.save();
        }
    }

    private void setValue(int propertyType, NodeIterator it, String proName, Value[] vls) throws Exception {
        while (it.hasNext()) {
            Node node = it.nextNode();
            node.setProperty(proName, vls);
            node.save();
        }
    }

    private void updateValue(int propertyType, boolean isMultiple, NodeIterator it, String addPropertyName, String removeName) throws Exception {
        while (it.hasNext()) {
            Node node = it.nextNode();
            switch (propertyType) {
                case 1: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getString());
                    break;
                }
                case 6: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getBoolean());
                    break;
                }
                case 3: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getLong());
                    break;
                }
                case 4: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getDouble());
                    break;
                }
                case 5: {
                    if (isMultiple) {
                        node.setProperty(addPropertyName, node.getProperty(removeName).getValues());
                        break;
                    }
                    node.setProperty(addPropertyName, node.getProperty(removeName).getDate());
                    break;
                }
            }
            node.getProperty(removeName).remove();
            node.save();
        }
    }

    public void updateReminderDataBase() {
    }

    public void updateEventCategoryDataBase() {
    }

    public void updateCalendarEventDataBase() {
    }

    public void postUpdate() {
        super.postUpdate();
    }
}

